/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import com.brandon3055.draconicevolution.client.gui.componentguis.GUIToolConfig;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.utills.IHudDisplayBlock;
import com.brandon3055.draconicevolution.common.utills.IHudDisplayItem;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class HudHandler {
    private static List<String> hudList = null;
    int width;
    int height;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHUD(RenderGameOverlayEvent.Post event) {
        if (ConfigHandler.enableHudDisplay && event.type == RenderGameOverlayEvent.ElementType.ALL) {
            if (hudList == null) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71474_y.field_74330_P) {
                return;
            }
            ScaledResolution resolution = event.resolution;
            this.width = resolution.func_78326_a();
            this.height = resolution.func_78328_b();
            FontRenderer fontRenderer = mc.field_71466_p;
            int x = (int)((float)ConfigHandler.hudX / 1000.0f * (float)this.width);
            int y = (int)((float)ConfigHandler.hudY / 1000.0f * (float)this.height);
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            this.drawHoveringText(hudList, x, y, fontRenderer);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientTick() {
        MovingObjectPosition mop;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        hudList = null;
        if (mc.field_71462_r != null) {
            if (mc.field_71462_r instanceof GUIToolConfig) {
                hudList = new ArrayList<String>();
                hudList.add(StatCollector.func_74838_a((String)"info.de.hudDisplayConfigTxt1.txt"));
                hudList.add("");
                hudList.add(StatCollector.func_74838_a((String)"info.de.hudDisplayConfigTxt2.txt"));
                hudList.add("");
                hudList.add(StatCollector.func_74838_a((String)"info.de.hudDisplayConfigTxt3.txt"));
            }
        } else if (mc.field_71439_g.func_70694_bm() != null && mc.field_71439_g.func_70694_bm().func_77973_b() instanceof IHudDisplayItem) {
            hudList = ((IHudDisplayItem)mc.field_71439_g.func_70694_bm().func_77973_b()).getDisplayData(mc.field_71439_g.func_70694_bm());
        }
        if ((mop = mc.field_71439_g.func_70614_a(5.0, 0.0f)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mc.field_71441_e.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) instanceof IHudDisplayBlock) {
            hudList = ((IHudDisplayBlock)mc.field_71441_e.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)).getDisplayData((World)mc.field_71441_e, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        }
    }

    protected void drawHoveringText(List list, int x, int y, FontRenderer font) {
        if (!list.isEmpty()) {
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : list) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int adjX = x + 12;
            int adjY = y - 12;
            int i1 = 8;
            if (list.size() > 1) {
                i1 += 2 + (list.size() - 1) * 10;
            }
            if (adjX + k > this.width) {
                adjX -= 28 + k;
            }
            if (adjY + i1 + 6 > this.height) {
                adjY = this.height - i1 - 6;
            }
            int j1 = -267386864;
            this.drawGradientRect(adjX - 3, adjY - 4, adjX + k + 3, adjY - 3, j1, j1);
            this.drawGradientRect(adjX - 3, adjY + i1 + 3, adjX + k + 3, adjY + i1 + 4, j1, j1);
            this.drawGradientRect(adjX - 3, adjY - 3, adjX + k + 3, adjY + i1 + 3, j1, j1);
            this.drawGradientRect(adjX - 4, adjY - 3, adjX - 3, adjY + i1 + 3, j1, j1);
            this.drawGradientRect(adjX + k + 3, adjY - 3, adjX + k + 4, adjY + i1 + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(adjX - 3, adjY - 3 + 1, adjX - 3 + 1, adjY + i1 + 3 - 1, k1, l1);
            this.drawGradientRect(adjX + k + 2, adjY - 3 + 1, adjX + k + 3, adjY + i1 + 3 - 1, k1, l1);
            this.drawGradientRect(adjX - 3, adjY - 3, adjX + k + 3, adjY - 3 + 1, k1, k1);
            this.drawGradientRect(adjX - 3, adjY + i1 + 2, adjX + k + 3, adjY + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String s1 = (String)list.get(i2);
                font.func_78261_a(s1, adjX, adjY, -1);
                if (i2 == 0) {
                    adjY += 2;
                }
                adjY += 10;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
        }
    }

    protected void drawGradientRect(int x1, int y1, int x2, int y2, int colour1, int colour2) {
        float f = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colour1 & 0xFF) / 255.0f;
        float f4 = (float)(colour2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colour2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)x2, (double)y1, 300.0);
        tessellator.func_78377_a((double)x1, (double)y1, 300.0);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)x1, (double)y2, 300.0);
        tessellator.func_78377_a((double)x2, (double)y2, 300.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

