/*
 * Decompiled with CFR 0.152.
 */
package hats.common.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hats.client.gui.GuiTradeWindow;
import ichun.common.core.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class PacketTradeReadyInfo
extends AbstractPacket {
    public String trader1Name;
    public boolean trader1Ready;
    public String trader2Name;
    public boolean trader2Ready;

    public PacketTradeReadyInfo() {
    }

    public PacketTradeReadyInfo(String t1Name, boolean t1Ready, String t2Name, boolean t2Ready) {
        this.trader1Name = t1Name;
        this.trader1Ready = t1Ready;
        this.trader2Name = t2Name;
        this.trader2Ready = t2Ready;
    }

    public void writeTo(ByteBuf buffer, Side side) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.trader1Name);
        buffer.writeBoolean(this.trader1Ready);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.trader2Name);
        buffer.writeBoolean(this.trader2Ready);
    }

    public void readFrom(ByteBuf buffer, Side side) {
        this.trader1Name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.trader1Ready = buffer.readBoolean();
        this.trader2Name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.trader2Ready = buffer.readBoolean();
    }

    public void execute(Side side, EntityPlayer player) {
        if (side.isClient()) {
            this.handleClient(side, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient(Side side, EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiTradeWindow) {
            GuiTradeWindow trade = (GuiTradeWindow)Minecraft.func_71410_x().field_71462_r;
            if (this.trader1Name.equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                if (trade.selfReady && !this.trader1Ready) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                }
                trade.selfReady = this.trader1Ready;
                trade.theirReady = this.trader2Ready;
            } else {
                if (trade.selfReady && !this.trader2Ready) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                }
                trade.selfReady = this.trader2Ready;
                trade.theirReady = this.trader1Ready;
            }
            if (!trade.theirReady) {
                trade.pointOfNoReturn = false;
                trade.clickedMakeTrade = false;
            }
        }
    }
}

