/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.core.features.ActivityState;
import appeng.util.Platform;
import com.google.common.base.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class ItemDefinition
implements IItemDefinition {
    private final Item item;
    private final boolean enabled;

    public ItemDefinition(Item item, ActivityState state) {
        assert (item != null);
        this.item = item;
        this.enabled = state == ActivityState.Enabled;
    }

    @Override
    public final Optional<Item> maybeItem() {
        return Optional.of((Object)this.item);
    }

    @Override
    public Optional<ItemStack> maybeStack(int stackSize) {
        if (this.enabled) {
            return Optional.of((Object)new ItemStack(this.item));
        }
        return Optional.absent();
    }

    @Override
    public final boolean isSameAs(ItemStack comparableStack) {
        return this.enabled && Platform.isSameItemType(comparableStack, (ItemStack)this.maybeStack(1).get());
    }

    @Override
    public boolean isSameAs(IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

