/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world;

import java.util.List;
import java.util.Random;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.world.GenLayerCheckerboard;
import mcjty.rftools.dimension.world.GenLayerFiltered;
import mcjty.rftools.dimension.world.types.ControllerType;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;

public class GenericWorldChunkManager
extends WorldChunkManager {
    private DimensionInformation dimensionInformation = null;
    public static DimensionInformation hackyDimensionInformation;

    public DimensionInformation getDimensionInformation() {
        return this.dimensionInformation;
    }

    public GenericWorldChunkManager(long seed, WorldType worldType, DimensionInformation dimensionInformation) {
        super(seed, worldType);
        this.dimensionInformation = dimensionInformation;
    }

    public List func_76932_a() {
        return super.func_76932_a();
    }

    public BiomeGenBase func_76935_a(int x, int z) {
        return super.func_76935_a(x, z);
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] p_76937_1_, int p_76937_2_, int p_76937_3_, int p_76937_4_, int p_76937_5_) {
        return super.func_76937_a(p_76937_1_, p_76937_2_, p_76937_3_, p_76937_4_, p_76937_5_);
    }

    public float[] func_76936_a(float[] p_76936_1_, int p_76936_2_, int p_76936_3_, int p_76936_4_, int p_76936_5_) {
        return super.func_76936_a(p_76936_1_, p_76936_2_, p_76936_3_, p_76936_4_, p_76936_5_);
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] p_76933_1_, int p_76933_2_, int p_76933_3_, int p_76933_4_, int p_76933_5_) {
        return super.func_76933_b(p_76933_1_, p_76933_2_, p_76933_3_, p_76933_4_, p_76933_5_);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] p_76931_1_, int p_76931_2_, int p_76931_3_, int p_76931_4_, int p_76931_5_, boolean p_76931_6_) {
        return super.func_76931_a(p_76931_1_, p_76931_2_, p_76931_3_, p_76931_4_, p_76931_5_, p_76931_6_);
    }

    public boolean func_76940_a(int p_76940_1_, int p_76940_2_, int p_76940_3_, List p_76940_4_) {
        return super.func_76940_a(p_76940_1_, p_76940_2_, p_76940_3_, p_76940_4_);
    }

    public ChunkPosition func_150795_a(int p_150795_1_, int p_150795_2_, int p_150795_3_, List p_150795_4_, Random p_150795_5_) {
        return super.func_150795_a(p_150795_1_, p_150795_2_, p_150795_3_, p_150795_4_, p_150795_5_);
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        if (this.dimensionInformation == null) {
            this.dimensionInformation = hackyDimensionInformation;
        }
        GenLayer[] layer = super.getModdedBiomeGenerators(worldType, seed, original);
        GenLayer rflayer = null;
        DimensionInformation di = this.dimensionInformation;
        if (di == null) {
            di = hackyDimensionInformation;
        }
        ControllerType type = di.getControllerType();
        switch (type) {
            case CONTROLLER_DEFAULT: 
            case CONTROLLER_SINGLE: {
                break;
            }
            case CONTROLLER_CHECKERBOARD: {
                rflayer = new GenLayerCheckerboard(this, seed, layer[0]);
                break;
            }
            case CONTROLLER_COLD: 
            case CONTROLLER_WARM: 
            case CONTROLLER_MEDIUM: 
            case CONTROLLER_DRY: 
            case CONTROLLER_WET: 
            case CONTROLLER_FIELDS: 
            case CONTROLLER_MOUNTAINS: 
            case CONTROLLER_MAGICAL: 
            case CONTROLLER_FOREST: 
            case CONTROLLER_FILTERED: {
                rflayer = new GenLayerFiltered(this, seed, layer[0], type);
            }
        }
        GenLayerVoronoiZoom zoomLayer = new GenLayerVoronoiZoom(10L, rflayer);
        zoomLayer.func_75905_a(seed);
        return new GenLayer[]{rflayer, zoomLayer, rflayer};
    }
}

