/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.PlayerExtendedProperties;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.teleporter.GuiDialingDevice;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.blocks.teleporter.TeleporterSetup;
import mcjty.rftools.blocks.teleporter.TransmitterInfo;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.network.Argument;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class DialingDeviceTileEntity
extends GenericEnergyReceiverTileEntity
implements SimpleComponent,
IPeripheral {
    public static final String CMD_TELEPORT = "tp";
    public static final String CMD_GETRECEIVERS = "getReceivers";
    public static final String CLIENTCMD_GETRECEIVERS = "getReceivers";
    public static final String CMD_DIAL = "dial";
    public static final String CMD_DIALONCE = "dialOnce";
    public static final String CMD_FAVORITE = "favorite";
    public static final String CMD_SHOWFAVORITE = "showFavorite";
    public static final String CLIENTCMD_DIAL = "dialResult";
    public static final String CMD_GETTRANSMITTERS = "getTransmitters";
    public static final String CLIENTCMD_GETTRANSMITTERS = "getTransmitters";
    public static final String CMD_CHECKSTATUS = "checkStatus";
    public static final String CLIENTCMD_STATUS = "status";
    public static final int DIAL_RECEIVER_BLOCKED_MASK = 1;
    public static final int DIAL_TRANSMITTER_BLOCKED_MASK = 2;
    public static final int DIAL_INVALID_DESTINATION_MASK = 4;
    public static final int DIAL_DIALER_POWER_LOW_MASK = 8;
    public static final int DIAL_RECEIVER_POWER_LOW_MASK = 16;
    public static final int DIAL_TRANSMITTER_NOACCESS = 32;
    public static final int DIAL_RECEIVER_NOACCESS = 64;
    public static final int DIAL_INTERRUPTED = 128;
    public static final int DIAL_INVALID_SOURCE_MASK = 256;
    public static final int DIAL_DIMENSION_POWER_LOW_MASK = 512;
    public static final int DIAL_OK = 0;
    public static final String COMPONENT_NAME = "dialing_device";
    private boolean showOnlyFavorites = false;

    public DialingDeviceTileEntity() {
        super(TeleportConfiguration.DIALER_MAXENERGY, TeleportConfiguration.DIALER_RECEIVEPERTICK);
    }

    public static String calculateDistance(World world, TransmitterInfo transmitterInfo, TeleportDestination teleportDestination) {
        if (world.field_73011_w.field_76574_g != teleportDestination.getDimension()) {
            return "dimension warp";
        }
        Coordinate c1 = transmitterInfo.getCoordinate();
        Coordinate c2 = teleportDestination.getCoordinate();
        double dist = Vec3.func_72443_a((double)c1.getX(), (double)c1.getY(), (double)c1.getZ()).func_72438_d(Vec3.func_72443_a((double)c2.getX(), (double)c2.getY(), (double)c2.getZ()));
        return Integer.toString((int)dist);
    }

    public static boolean isMatterBoosterAvailable(World world, int x, int y, int z) {
        if (((Object)((Object)TeleporterSetup.matterBoosterBlock)).equals(world.func_147439_a(x + 1, y, z))) {
            return true;
        }
        if (((Object)((Object)TeleporterSetup.matterBoosterBlock)).equals(world.func_147439_a(x - 1, y, z))) {
            return true;
        }
        if (((Object)((Object)TeleporterSetup.matterBoosterBlock)).equals(world.func_147439_a(x, y + 1, z))) {
            return true;
        }
        if (((Object)((Object)TeleporterSetup.matterBoosterBlock)).equals(world.func_147439_a(x, y - 1, z))) {
            return true;
        }
        if (((Object)((Object)TeleporterSetup.matterBoosterBlock)).equals(world.func_147439_a(x, y, z + 1))) {
            return true;
        }
        return ((Object)((Object)TeleporterSetup.matterBoosterBlock)).equals(world.func_147439_a(x, y, z - 1));
    }

    public static boolean isDestinationAnalyzerAvailable(World world, int x, int y, int z) {
        if (((Object)((Object)TeleporterSetup.destinationAnalyzerBlock)).equals(world.func_147439_a(x + 1, y, z))) {
            return true;
        }
        if (((Object)((Object)TeleporterSetup.destinationAnalyzerBlock)).equals(world.func_147439_a(x - 1, y, z))) {
            return true;
        }
        if (((Object)((Object)TeleporterSetup.destinationAnalyzerBlock)).equals(world.func_147439_a(x, y + 1, z))) {
            return true;
        }
        if (((Object)((Object)TeleporterSetup.destinationAnalyzerBlock)).equals(world.func_147439_a(x, y - 1, z))) {
            return true;
        }
        if (((Object)((Object)TeleporterSetup.destinationAnalyzerBlock)).equals(world.func_147439_a(x, y, z + 1))) {
            return true;
        }
        return ((Object)((Object)TeleporterSetup.destinationAnalyzerBlock)).equals(world.func_147439_a(x, y, z - 1));
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return COMPONENT_NAME;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getTransmitterCount", "getTransmitter", "getReceiverCount", "getReceiver", "getReceiverName", "getTransmitterName", CMD_DIAL, CMD_DIALONCE, "interrupt", "getDialed"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                List<TransmitterInfo> transmitterInfos = this.searchTransmitters();
                return new Object[]{transmitterInfos.size()};
            }
            case 1: {
                List<TransmitterInfo> transmitterInfos = this.searchTransmitters();
                int idx = ((Double)arguments[0]).intValue();
                TransmitterInfo ti = transmitterInfos.get(idx);
                return new Object[]{ti.getCoordinate().getX(), ti.getCoordinate().getY(), ti.getCoordinate().getZ()};
            }
            case 2: {
                List<TeleportDestinationClientInfo> receivers = this.searchReceivers(null);
                return new Object[]{receivers.size()};
            }
            case 3: {
                List<TeleportDestinationClientInfo> receivers = this.searchReceivers(null);
                int idx = ((Double)arguments[0]).intValue();
                TeleportDestinationClientInfo ti = receivers.get(idx);
                return new Object[]{ti.getDimension(), ti.getCoordinate().getX(), ti.getCoordinate().getY(), ti.getCoordinate().getZ()};
            }
            case 4: {
                List<TeleportDestinationClientInfo> receivers = this.searchReceivers(null);
                int idx = ((Double)arguments[0]).intValue();
                TeleportDestinationClientInfo ti = receivers.get(idx);
                TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
                TeleportDestination destination = destinations.getDestination(ti.getCoordinate(), ti.getDimension());
                if (destination == null) {
                    return null;
                }
                return new Object[]{destination.getName()};
            }
            case 5: {
                List<TransmitterInfo> transmitterInfos = this.searchTransmitters();
                int idx = ((Double)arguments[0]).intValue();
                TransmitterInfo ti = transmitterInfos.get(idx);
                return new Object[]{ti.getName()};
            }
            case 6: {
                List<TransmitterInfo> transmitterInfos = this.searchTransmitters();
                List<TeleportDestinationClientInfo> receivers = this.searchReceivers(null);
                int transIdx = ((Double)arguments[0]).intValue();
                int recIdx = ((Double)arguments[1]).intValue();
                TransmitterInfo trans = transmitterInfos.get(transIdx);
                TeleportDestinationClientInfo rec = receivers.get(recIdx);
                int transDim = this.field_145850_b.field_73011_w.field_76574_g;
                int result = this.dial(null, trans.getCoordinate(), transDim, rec.getCoordinate(), rec.getDimension(), false);
                return new Object[]{result};
            }
            case 7: {
                List<TransmitterInfo> transmitterInfos = this.searchTransmitters();
                List<TeleportDestinationClientInfo> receivers = this.searchReceivers(null);
                int transIdx = ((Double)arguments[0]).intValue();
                int recIdx = ((Double)arguments[1]).intValue();
                TransmitterInfo trans = transmitterInfos.get(transIdx);
                TeleportDestinationClientInfo rec = receivers.get(recIdx);
                int transDim = this.field_145850_b.field_73011_w.field_76574_g;
                int result = this.dial(null, trans.getCoordinate(), transDim, rec.getCoordinate(), rec.getDimension(), true);
                return new Object[]{result};
            }
            case 8: {
                List<TransmitterInfo> transmitterInfos = this.searchTransmitters();
                int transIdx = ((Double)arguments[0]).intValue();
                TransmitterInfo trans = transmitterInfos.get(transIdx);
                int transDim = this.field_145850_b.field_73011_w.field_76574_g;
                int result = this.dial(null, trans.getCoordinate(), transDim, null, -1, false);
                if (result == 4) {
                    result = 0;
                }
                return new Object[]{result};
            }
            case 9: {
                List<TransmitterInfo> transmitterInfos = this.searchTransmitters();
                int transIdx = ((Double)arguments[0]).intValue();
                TransmitterInfo trans = transmitterInfos.get(transIdx);
                TeleportDestination teleportDestination = trans.getTeleportDestination();
                if (teleportDestination == null) {
                    return null;
                }
                Coordinate c = teleportDestination.getCoordinate();
                return new Object[]{teleportDestination.getDimension(), c.getX(), c.getY(), c.getZ()};
            }
        }
        return new Object[0];
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return false;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getTransmitters(Context context, Arguments args) throws Exception {
        List<TransmitterInfo> transmitterInfos = this.searchTransmitters();
        ArrayList result = new ArrayList();
        for (TransmitterInfo info : transmitterInfos) {
            HashMap<String, Integer> coordinate = new HashMap<String, Integer>();
            coordinate.put("x", info.getCoordinate().getX());
            coordinate.put("y", info.getCoordinate().getY());
            coordinate.put("z", info.getCoordinate().getZ());
            result.add(coordinate);
        }
        return new Object[]{result};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getReceivers(Context context, Arguments args) throws Exception {
        List<TeleportDestinationClientInfo> receivers = this.searchReceivers(null);
        ArrayList result = new ArrayList();
        for (TeleportDestinationClientInfo info : receivers) {
            HashMap<String, Integer> coordinate = new HashMap<String, Integer>();
            coordinate.put("dim", info.getDimension());
            coordinate.put("x", info.getCoordinate().getX());
            coordinate.put("y", info.getCoordinate().getY());
            coordinate.put("z", info.getCoordinate().getZ());
            result.add(coordinate);
        }
        return new Object[]{result};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getReceiverName(Context context, Arguments args) throws Exception {
        Map receiver = args.checkTable(0);
        if (!(receiver.containsKey("x") && receiver.containsKey("y") && receiver.containsKey("z"))) {
            throw new IllegalArgumentException("Receiver map doesn't contain the right x,y,z coordinate!");
        }
        if (!receiver.containsKey("dim")) {
            throw new IllegalArgumentException("Receiver map doesn't contain the right dimension!");
        }
        Coordinate recC = new Coordinate(((Double)receiver.get("x")).intValue(), ((Double)receiver.get("y")).intValue(), ((Double)receiver.get("z")).intValue());
        int recDim = ((Double)receiver.get("dim")).intValue();
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
        TeleportDestination destination = destinations.getDestination(recC, recDim);
        if (destination == null) {
            return null;
        }
        return new Object[]{destination.getName()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getTransmitterName(Context context, Arguments args) throws Exception {
        Map transmitter = args.checkTable(0);
        if (!(transmitter.containsKey("x") && transmitter.containsKey("y") && transmitter.containsKey("z"))) {
            throw new IllegalArgumentException("Transmitter map doesn't contain the right x,y,z coordinate!");
        }
        Coordinate transC = new Coordinate(((Double)transmitter.get("x")).intValue(), ((Double)transmitter.get("y")).intValue(), ((Double)transmitter.get("z")).intValue());
        for (TransmitterInfo info : this.searchTransmitters()) {
            if (!transC.equals(info.getCoordinate())) continue;
            return new Object[]{info.getName()};
        }
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] dial(Context context, Arguments args) throws Exception {
        Map transmitter = args.checkTable(0);
        Map receiver = args.checkTable(1);
        if (!(transmitter.containsKey("x") && transmitter.containsKey("y") && transmitter.containsKey("z"))) {
            throw new IllegalArgumentException("Transmitter map doesn't contain the right x,y,z coordinate!");
        }
        if (!(receiver.containsKey("x") && receiver.containsKey("y") && receiver.containsKey("z"))) {
            throw new IllegalArgumentException("Receiver map doesn't contain the right x,y,z coordinate!");
        }
        if (!receiver.containsKey("dim")) {
            throw new IllegalArgumentException("Receiver map doesn't contain the right dimension!");
        }
        Coordinate transC = new Coordinate(((Double)transmitter.get("x")).intValue(), ((Double)transmitter.get("y")).intValue(), ((Double)transmitter.get("z")).intValue());
        int transDim = this.field_145850_b.field_73011_w.field_76574_g;
        Coordinate recC = new Coordinate(((Double)receiver.get("x")).intValue(), ((Double)receiver.get("y")).intValue(), ((Double)receiver.get("z")).intValue());
        int recDim = ((Double)receiver.get("dim")).intValue();
        int result = this.dial(null, transC, transDim, recC, recDim, false);
        return new Object[]{result};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] dialOnce(Context context, Arguments args) throws Exception {
        Map transmitter = args.checkTable(0);
        Map receiver = args.checkTable(1);
        if (!(transmitter.containsKey("x") && transmitter.containsKey("y") && transmitter.containsKey("z"))) {
            throw new IllegalArgumentException("Transmitter map doesn't contain the right x,y,z coordinate!");
        }
        if (!(receiver.containsKey("x") && receiver.containsKey("y") && receiver.containsKey("z"))) {
            throw new IllegalArgumentException("Receiver map doesn't contain the right x,y,z coordinate!");
        }
        if (!receiver.containsKey("dim")) {
            throw new IllegalArgumentException("Receiver map doesn't contain the right dimension!");
        }
        Coordinate transC = new Coordinate(((Double)transmitter.get("x")).intValue(), ((Double)transmitter.get("y")).intValue(), ((Double)transmitter.get("z")).intValue());
        int transDim = this.field_145850_b.field_73011_w.field_76574_g;
        Coordinate recC = new Coordinate(((Double)receiver.get("x")).intValue(), ((Double)receiver.get("y")).intValue(), ((Double)receiver.get("z")).intValue());
        int recDim = ((Double)receiver.get("dim")).intValue();
        int result = this.dial(null, transC, transDim, recC, recDim, true);
        return new Object[]{result};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] interrupt(Context context, Arguments args) throws Exception {
        int transDim;
        Map transmitter = args.checkTable(0);
        if (!(transmitter.containsKey("x") && transmitter.containsKey("y") && transmitter.containsKey("z"))) {
            throw new IllegalArgumentException("Transmitter map doesn't contain the right x,y,z coordinate!");
        }
        Coordinate transC = new Coordinate(((Double)transmitter.get("x")).intValue(), ((Double)transmitter.get("y")).intValue(), ((Double)transmitter.get("z")).intValue());
        int result = this.dial(null, transC, transDim = this.field_145850_b.field_73011_w.field_76574_g, null, -1, false);
        if (result == 4) {
            result = 0;
        }
        return new Object[]{result};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getDialed(Context context, Arguments args) throws Exception {
        Map transmitter = args.checkTable(0);
        if (!(transmitter.containsKey("x") && transmitter.containsKey("y") && transmitter.containsKey("z"))) {
            throw new IllegalArgumentException("Transmitter map doesn't contain the right x,y,z coordinate!");
        }
        Coordinate transC = new Coordinate(((Double)transmitter.get("x")).intValue(), ((Double)transmitter.get("y")).intValue(), ((Double)transmitter.get("z")).intValue());
        List<TransmitterInfo> transmitterInfos = this.searchTransmitters();
        for (TransmitterInfo info : transmitterInfos) {
            if (!info.getCoordinate().equals(transC)) continue;
            TeleportDestination teleportDestination = info.getTeleportDestination();
            if (teleportDestination == null) {
                return null;
            }
            HashMap<String, Integer> coordinate = new HashMap<String, Integer>();
            coordinate.put("dim", teleportDestination.getDimension());
            Coordinate c = teleportDestination.getCoordinate();
            coordinate.put("x", c.getX());
            coordinate.put("y", c.getY());
            coordinate.put("z", c.getZ());
            return new Object[]{coordinate};
        }
        return null;
    }

    public boolean isShowOnlyFavorites() {
        return this.showOnlyFavorites;
    }

    public void setShowOnlyFavorites(boolean showOnlyFavorites) {
        this.showOnlyFavorites = showOnlyFavorites;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.showOnlyFavorites = tagCompound.func_74767_n("showFav");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74757_a("showFav", this.showOnlyFavorites);
    }

    private List<TeleportDestinationClientInfo> searchReceivers(String playerName) {
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
        return new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(playerName));
    }

    public List<TransmitterInfo> searchTransmitters() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int hrange = TeleportConfiguration.horizontalDialerRange;
        int vrange = TeleportConfiguration.verticalDialerRange;
        ArrayList<TransmitterInfo> transmitters = new ArrayList<TransmitterInfo>();
        for (int dy = -vrange; dy <= vrange; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= this.field_145850_b.func_72940_L()) continue;
            for (int dz = -hrange; dz <= hrange; ++dz) {
                int zz = z + dz;
                for (int dx = -hrange; dx <= hrange; ++dx) {
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    Coordinate c = new Coordinate(xx, yy, zz);
                    TileEntity tileEntity = this.field_145850_b.func_147438_o(xx, yy, zz);
                    if (tileEntity == null || !(tileEntity instanceof MatterTransmitterTileEntity)) continue;
                    MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)tileEntity;
                    transmitters.add(new TransmitterInfo(c, matterTransmitterTileEntity.getName(), matterTransmitterTileEntity.getTeleportDestination()));
                }
            }
        }
        return transmitters;
    }

    private void changeFavorite(String playerName, Coordinate receiver, int dimension, boolean favorite) {
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (Object p : list) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)p;
            if (!playerName.equals(entityplayermp.getDisplayName())) continue;
            PlayerExtendedProperties properties = PlayerExtendedProperties.getProperties((EntityPlayer)entityplayermp);
            properties.setDestinationFavorite(new GlobalCoordinate(receiver, dimension), favorite);
            return;
        }
    }

    private int dial(String player, Coordinate transmitter, int transDim, Coordinate coordinate, int dimension, boolean once) {
        return TeleportationTools.dial(this.field_145850_b, this, player, transmitter, transDim, coordinate, dimension, once);
    }

    private int checkStatus(Coordinate c, int dim) {
        DimensionStorage dimensionStorage;
        int energyLevel;
        int cost = TeleportConfiguration.rfPerCheck;
        cost = (int)((float)cost * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getEnergyStored(ForgeDirection.DOWN) < cost) {
            return 8;
        }
        this.consumeEnergy(cost);
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(this.field_145850_b);
        World w = RfToolsDimensionManager.getWorldForDimension(dim);
        if (w == null) {
            return 4;
        }
        TileEntity tileEntity = w.func_147438_o(c.getX(), c.getY(), c.getZ());
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            return 4;
        }
        if (dimensionManager.getDimensionInformation(dim) != null && (energyLevel = (dimensionStorage = DimensionStorage.getDimensionStorage(w)).getEnergyLevel(dim)) < DimletConfiguration.DIMPOWER_WARN_TP) {
            return 512;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        return matterReceiverTileEntity.checkStatus();
    }

    @Override
    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getReceivers".equals(command)) {
            String playerName = args.get("player").getString();
            return this.searchReceivers(playerName);
        }
        if ("getTransmitters".equals(command)) {
            return this.searchTransmitters();
        }
        return null;
    }

    @Override
    public boolean execute(String command, Map<String, Argument> args) {
        boolean rc = super.execute(command, args);
        if (rc) {
            return rc;
        }
        if (CMD_FAVORITE.equals(command)) {
            String player = args.get("player").getString();
            Coordinate receiver = args.get("receiver").getCoordinate();
            int dimension = args.get("dimension").getInteger();
            boolean favorite = args.get(CMD_FAVORITE).getBoolean();
            this.changeFavorite(player, receiver, dimension, favorite);
            return true;
        }
        if (CMD_SHOWFAVORITE.equals(command)) {
            boolean favorite = args.get(CMD_FAVORITE).getBoolean();
            this.setShowOnlyFavorites(favorite);
            return true;
        }
        return false;
    }

    @Override
    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_CHECKSTATUS.equals(command)) {
            Coordinate c = args.get("c").getCoordinate();
            int dim = args.get("dim").getInteger();
            return this.checkStatus(c, dim);
        }
        if (CMD_DIAL.equals(command)) {
            String player = args.get("player").getString();
            Coordinate transmitter = args.get("trans").getCoordinate();
            int transDim = args.get("transDim").getInteger();
            Coordinate c = args.get("c").getCoordinate();
            int dim = args.get("dim").getInteger();
            return this.dial(player, transmitter, transDim, c, dim, false);
        }
        if (CMD_DIALONCE.equals(command)) {
            String player = args.get("player").getString();
            Coordinate transmitter = args.get("trans").getCoordinate();
            int transDim = args.get("transDim").getInteger();
            Coordinate c = args.get("c").getCoordinate();
            int dim = args.get("dim").getInteger();
            return this.dial(player, transmitter, transDim, c, dim, true);
        }
        return null;
    }

    @Override
    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if ("getReceivers".equals(command)) {
            GuiDialingDevice.fromServer_receivers = new ArrayList<TeleportDestinationClientInfo>(list);
            return true;
        }
        if ("getTransmitters".equals(command)) {
            GuiDialingDevice.fromServer_transmitters = new ArrayList<TransmitterInfo>(list);
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_STATUS.equals(command)) {
            GuiDialingDevice.fromServer_receiverStatus = result;
            return true;
        }
        if (CLIENTCMD_DIAL.equals(command)) {
            GuiDialingDevice.fromServer_dialResult = result;
            return true;
        }
        return false;
    }
}

