/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.PacketCurrentTaskProgress;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPowerReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractPoweredTaskEntity
extends AbstractPowerConsumerEntity
implements IInternalPowerReceiver {
    protected IPoweredTask currentTask = null;
    protected IMachineRecipe lastCompletedRecipe;
    protected final Random random = new Random();
    protected int ticksSinceCheckedRecipe = 0;
    protected boolean startFailed = false;
    protected int lastProgressScaled = -1;
    protected int ticksSinceLastProgressUpdate;

    public AbstractPoweredTaskEntity(SlotDefinition slotDefinition) {
        super(slotDefinition);
    }

    @Override
    public int[] func_94128_d(int var1) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)var1);
        IoMode mode = this.getIoMode(dir);
        if (mode == IoMode.DISABLED) {
            return new int[0];
        }
        int[] res = new int[this.inventory.length - this.slotDefinition.getNumUpgradeSlots()];
        int index = 0;
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.slotDefinition.isUpgradeSlot(i)) continue;
            res[index] = i;
            ++index;
        }
        return res;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (!super.func_102007_a(i, itemstack, j)) {
            return false;
        }
        if (!this.func_94041_b(i, itemstack)) {
            return false;
        }
        if (this.inventory[i] == null) {
            return true;
        }
        return this.inventory[i].func_77969_a(itemstack);
    }

    @Override
    public boolean isActive() {
        return this.currentTask == null ? false : this.currentTask.getProgress() >= 0.0f && this.hasPower() && this.redstoneCheckPassed;
    }

    @Override
    public float getProgress() {
        return this.currentTask == null ? 0.0f : this.currentTask.getProgress();
    }

    public IPoweredTask getCurrentTask() {
        return this.currentTask;
    }

    public float getExperienceForOutput(ItemStack output) {
        if (this.lastCompletedRecipe == null) {
            return 0.0f;
        }
        return this.lastCompletedRecipe.getExperienceForOutput(output);
    }

    public boolean getRedstoneChecksPassed() {
        return this.redstoneCheckPassed;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        if (!redstoneChecksPassed) {
            return false;
        }
        boolean requiresClientSync = false;
        requiresClientSync |= this.checkProgress(redstoneChecksPassed);
        if (this.currentTask != null || !this.hasPower() || !this.hasInputStacks()) {
            return requiresClientSync;
        }
        if (this.startFailed) {
            ++this.ticksSinceCheckedRecipe;
            if (this.ticksSinceCheckedRecipe < 20) {
                return false;
            }
        }
        this.ticksSinceCheckedRecipe = 0;
        float chance = this.random.nextFloat();
        IMachineRecipe nextRecipe = this.canStartNextTask(chance);
        if (nextRecipe != null) {
            boolean started = this.startNextTask(nextRecipe, chance);
            this.sendTaskProgressPacket();
            this.startFailed = !started;
        } else {
            this.startFailed = true;
        }
        return requiresClientSync;
    }

    protected void sendTaskProgressPacket() {
        PacketHandler.sendToAllAround(new PacketCurrentTaskProgress(this), this);
        this.ticksSinceLastProgressUpdate = 0;
    }

    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.currentTask == null || !this.hasPower()) {
            return false;
        }
        if (redstoneChecksPassed) {
            this.usePower();
        }
        if (this.currentTask.isComplete()) {
            this.taskComplete();
            return false;
        }
        int curScaled = this.getProgressScaled(16);
        if (++this.ticksSinceLastProgressUpdate >= 20 || curScaled != this.lastProgressScaled) {
            this.sendTaskProgressPacket();
            this.lastProgressScaled = curScaled;
        }
        return false;
    }

    protected double usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    public int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        if (this.currentTask != null) {
            this.currentTask.update(used);
        }
        return used;
    }

    protected void taskComplete() {
        if (this.currentTask != null) {
            this.lastCompletedRecipe = this.currentTask.getRecipe();
            IMachineRecipe.ResultStack[] output = this.currentTask.getCompletedResult();
            if (output != null && output.length > 0) {
                IMachineRecipe.ResultStack[] results = this.currentTask.getCompletedResult();
                this.mergeResults(results);
            }
        }
        this.func_70296_d();
        this.currentTask = null;
        this.lastProgressScaled = 0;
        this.sendTaskProgressPacket();
    }

    protected void mergeResults(IMachineRecipe.ResultStack[] results) {
        ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>(this.slotDefinition.getNumOutputSlots());
        if (this.slotDefinition.getNumOutputSlots() > 0) {
            for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
                ItemStack it = this.inventory[i];
                if (it != null) {
                    it = it.func_77946_l();
                }
                outputStacks.add(it);
            }
        }
        for (IMachineRecipe.ResultStack result : results) {
            if (result.item != null) {
                int numMerged = this.mergeItemResult(result.item, outputStacks);
                if (numMerged <= 0) continue;
                result.item.field_77994_a -= numMerged;
                continue;
            }
            if (result.fluid == null) continue;
            this.mergeFluidResult(result);
        }
        if (this.slotDefinition.getNumOutputSlots() > 0) {
            int listIndex = 0;
            for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
                ItemStack st = (ItemStack)outputStacks.get(listIndex);
                if (st != null) {
                    st = st.func_77946_l();
                }
                this.inventory[i] = st;
                ++listIndex;
            }
        }
    }

    protected void mergeFluidResult(IMachineRecipe.ResultStack result) {
    }

    protected void drainInputFluid(MachineRecipeInput fluid) {
    }

    protected boolean canInsertResultFluid(IMachineRecipe.ResultStack fluid) {
        return false;
    }

    protected int mergeItemResult(ItemStack item, List<ItemStack> outputStacks) {
        int res = 0;
        ItemStack copy = item.func_77946_l();
        for (ItemStack outStack : outputStacks) {
            if (outStack == null || copy == null) continue;
            int num = this.getNumCanMerge(outStack, copy);
            outStack.field_77994_a += num;
            res += num;
            copy.field_77994_a -= num;
            if (copy.field_77994_a > 0) continue;
            return item.field_77994_a;
        }
        for (int i = 0; i < outputStacks.size(); ++i) {
            ItemStack outStack;
            outStack = outputStacks.get(i);
            if (outStack != null) continue;
            outputStacks.set(i, copy);
            return item.field_77994_a;
        }
        return 0;
    }

    protected MachineRecipeInput[] getRecipeInputs() {
        MachineRecipeInput[] res = new MachineRecipeInput[this.slotDefinition.getNumInputSlots()];
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < res.length; ++i) {
            res[i] = new MachineRecipeInput(fromSlot, this.inventory[fromSlot]);
            ++fromSlot;
        }
        return res;
    }

    protected IMachineRecipe canStartNextTask(float chance) {
        IMachineRecipe nextRecipe = MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), this.getRecipeInputs());
        if (nextRecipe == null) {
            return null;
        }
        return this.canInsertResult(chance, nextRecipe) ? nextRecipe : null;
    }

    protected boolean canInsertResult(float chance, IMachineRecipe nextRecipe) {
        IMachineRecipe.ResultStack[] nextResults = nextRecipe.getCompletedResult(chance, this.getRecipeInputs());
        ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>(this.slotDefinition.getNumOutputSlots());
        if (this.slotDefinition.getNumOutputSlots() > 0) {
            boolean allFull = true;
            for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
                ItemStack st = this.inventory[i];
                if (st != null) {
                    st = st.func_77946_l();
                    if (allFull && st.field_77994_a < st.func_77976_d()) {
                        allFull = false;
                    }
                } else {
                    allFull = false;
                }
                outputStacks.add(st);
            }
            if (allFull) {
                return false;
            }
        }
        for (IMachineRecipe.ResultStack result : nextResults) {
            if (!(result.item != null ? this.mergeItemResult(result.item, outputStacks) == 0 : result.fluid != null && !this.canInsertResultFluid(result))) continue;
            return false;
        }
        return true;
    }

    protected boolean hasInputStacks() {
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < this.slotDefinition.getNumInputSlots(); ++i) {
            if (this.inventory[fromSlot] != null) {
                return true;
            }
            ++fromSlot;
        }
        return false;
    }

    protected int getNumCanMerge(ItemStack itemStack, ItemStack result) {
        if (!itemStack.func_77969_a(result)) {
            return 0;
        }
        return Math.min(itemStack.func_77976_d() - itemStack.field_77994_a, result.field_77994_a);
    }

    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        if (this.hasPower() && nextRecipe.isRecipe(this.getRecipeInputs())) {
            this.currentTask = this.createTask(nextRecipe, chance);
            List<MachineRecipeInput> consumed = nextRecipe.getQuantitiesConsumed(this.getRecipeInputs());
            for (MachineRecipeInput item : consumed) {
                if (item == null) continue;
                if (item.item != null && item.item.field_77994_a > 0) {
                    this.func_70298_a(item.slotNumber, item.item.field_77994_a);
                    continue;
                }
                if (item.fluid == null) continue;
                this.drainInputFluid(item);
            }
            return true;
        }
        return false;
    }

    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        return new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.currentTask = PoweredTask.readFromNBT(nbtRoot.func_74775_l("currentTask"));
        String uid = nbtRoot.func_74779_i("lastCompletedRecipe");
        this.lastCompletedRecipe = MachineRecipeRegistry.instance.getRecipeForUid(uid);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        if (this.currentTask != null) {
            NBTTagCompound currentTaskNBT = new NBTTagCompound();
            this.currentTask.writeToNBT(currentTaskNBT);
            nbtRoot.func_74782_a("currentTask", (NBTBase)currentTaskNBT);
        }
        if (this.lastCompletedRecipe != null) {
            nbtRoot.func_74778_a("lastCompletedRecipe", this.lastCompletedRecipe.getUid());
        }
    }
}

