/*
 * Decompiled with CFR 0.152.
 */
package sync.common.tileentity;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import sync.common.Sync;
import sync.common.tileentity.TileEntityDualVertical;

@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHCore")
public class TileEntityTreadmill
extends TileEntity
implements IEnergyHandler {
    public TileEntityTreadmill pair = null;
    public boolean back = false;
    public int face = 0;
    public EntityLiving latchedEnt = null;
    public int latchedEntId;
    public float latchedHealth;
    public int timeRunning;
    public boolean resync = false;

    public void func_145845_h() {
        block38: {
            List list;
            AxisAlignedBB aabb;
            block39: {
                Entity ent;
                if (this.resync) {
                    TileEntity te = this.field_145850_b.func_147438_o(this.back ? (this.face == 1 ? this.field_145851_c + 1 : (this.face == 3 ? this.field_145851_c - 1 : this.field_145851_c)) : (this.face == 1 ? this.field_145851_c - 1 : (this.face == 3 ? this.field_145851_c + 1 : this.field_145851_c)), this.field_145848_d, this.back ? (this.face == 0 ? this.field_145849_e - 1 : (this.face == 2 ? this.field_145849_e + 1 : this.field_145849_e)) : (this.face == 0 ? this.field_145849_e + 1 : (this.face == 2 ? this.field_145849_e - 1 : this.field_145849_e)));
                    if (te != null && te.getClass() == ((Object)((Object)this)).getClass()) {
                        TileEntityTreadmill sc = (TileEntityTreadmill)te;
                        sc.pair = this;
                        this.pair = sc;
                    }
                    if (this.latchedEntId != -1) {
                        if (this.field_145850_b.field_72995_K) {
                            Entity ent2 = this.field_145850_b.func_73045_a(this.latchedEntId);
                            if (ent2 != null && ent2.func_70011_f(this.getMidCoord(0), (double)this.field_145848_d + 0.175, this.getMidCoord(1)) < 7.0) {
                                this.latchedEnt = (EntityLiving)ent2;
                                this.latchedHealth = this.latchedEnt.func_110143_aJ();
                            }
                        } else {
                            AxisAlignedBB aabb2 = AxisAlignedBB.func_72330_a((double)this.getMidCoord(0), (double)((double)this.field_145848_d + 0.175), (double)this.getMidCoord(1), (double)this.getMidCoord(0), (double)((double)this.field_145848_d + 0.175), (double)this.getMidCoord(1)).func_72314_b(0.4, 0.4, 0.4);
                            List list2 = this.field_145850_b.func_72872_a(Entity.class, aabb2);
                            for (Object aList : list2) {
                                ent = (Entity)aList;
                                if (!TileEntityTreadmill.isEntityValidForTreadmill(ent) || !(ent.field_70165_t > aabb2.field_72340_a) || !(ent.field_70165_t < aabb2.field_72336_d) || !(ent.field_70163_u > aabb2.field_72338_b) || !(ent.field_70163_u < aabb2.field_72337_e) || !(ent.field_70161_v > aabb2.field_72339_c) || !(ent.field_70161_v < aabb2.field_72334_f)) continue;
                                this.latchedEnt = (EntityLiving)ent;
                                this.latchedHealth = this.latchedEnt.func_110143_aJ();
                                this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_145848_d + 0.175, this.getMidCoord(1), (float)(this.face - 2) * 90.0f, 0.0f);
                                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                                break;
                            }
                        }
                    } else if (this.latchedEnt != null) {
                        this.latchedEnt = null;
                        this.timeRunning = 0;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
                this.resync = false;
                if (this.field_145850_b.field_72995_K && !this.back) {
                    Entity ent3;
                    if (this.latchedEnt == null && this.latchedEntId != -1 && this.field_145850_b.func_72820_D() % 27L == 0L && (ent3 = this.field_145850_b.func_73045_a(this.latchedEntId)) != null && ent3.func_70011_f(this.getMidCoord(0), (double)this.field_145848_d + 0.175, this.getMidCoord(1)) < 3.0) {
                        this.latchedEnt = (EntityLiving)ent3;
                        this.latchedHealth = this.latchedEnt.func_110143_aJ();
                    }
                    if (this.latchedEnt != null && this.latchedEnt.field_70128_L && (ent3 = this.field_145850_b.func_73045_a(this.latchedEntId)) != null && ent3.func_70011_f(this.getMidCoord(0), (double)this.field_145848_d + 0.175, this.getMidCoord(1)) < 7.0) {
                        this.latchedEnt = (EntityLiving)ent3;
                        this.latchedHealth = this.latchedEnt.func_110143_aJ();
                    }
                    if (this.latchedEnt != null) {
                        this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_145848_d + 0.175, this.getMidCoord(1), (float)(this.face - 2) * 90.0f, 0.0f);
                        ++this.timeRunning;
                        if (this.timeRunning > 12000) {
                            this.timeRunning = 12000;
                        }
                        if (0.3f + MathHelper.func_76131_a((float)((float)this.timeRunning / 12000.0f), (float)0.0f, (float)1.0f) * 0.7f > this.field_145850_b.field_73012_v.nextFloat()) {
                            this.spawnParticles();
                        }
                    }
                }
                if (this.field_145850_b.field_72995_K || this.back) break block38;
                aabb = this.latchedEnt != null ? this.latchedEnt.field_70121_D.func_72331_e(0.1, 0.1, 0.1) : AxisAlignedBB.func_72330_a((double)this.getMidCoord(0), (double)((double)this.field_145848_d + 0.175), (double)this.getMidCoord(1), (double)this.getMidCoord(0), (double)((double)this.field_145848_d + 0.175), (double)this.getMidCoord(1)).func_72314_b(0.15, 0.005, 0.15);
                list = this.field_145850_b.func_72872_a(Entity.class, aabb);
                if (this.latchedEnt == null) break block39;
                boolean remove = false;
                if (this.latchedEnt instanceof EntityTameable) {
                    EntityTameable entityTameable = (EntityTameable)this.latchedEnt;
                    if (entityTameable.func_70906_o()) {
                        this.timeRunning = 0;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        remove = true;
                    }
                    if (entityTameable.func_70909_n()) {
                        this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_145848_d + 0.175, this.getMidCoord(1), (float)(this.face - 2) * 90.0f, 0.0f);
                        aabb = this.latchedEnt.field_70121_D.func_72331_e(0.1, 0.1, 0.1);
                        list = this.field_145850_b.func_72872_a(EntityLivingBase.class, aabb);
                    } else {
                        entityTameable.field_70173_aa = 1200;
                    }
                }
                for (Object aList : list) {
                    ent = (Entity)aList;
                    if (ent == this.latchedEnt || !(ent instanceof EntityLivingBase) || ent instanceof EntityPlayer) continue;
                    double velo = 0.9;
                    switch (this.face) {
                        case 0: {
                            ent.field_70179_y = velo;
                            break;
                        }
                        case 1: {
                            ent.field_70159_w = -velo;
                            break;
                        }
                        case 2: {
                            ent.field_70179_y = -velo;
                            break;
                        }
                        case 3: {
                            ent.field_70159_w = velo;
                        }
                    }
                    remove = true;
                }
                if (this.latchedEnt != null && (!list.contains(this.latchedEnt) || remove || this.latchedHealth > this.latchedEnt.func_110143_aJ())) {
                    if (this.latchedHealth <= this.latchedEnt.func_110143_aJ()) {
                        double velo = 1.3;
                        switch (this.face) {
                            case 0: {
                                this.latchedEnt.field_70179_y = velo;
                                break;
                            }
                            case 1: {
                                this.latchedEnt.field_70159_w = -velo;
                                break;
                            }
                            case 2: {
                                this.latchedEnt.field_70179_y = -velo;
                                break;
                            }
                            case 3: {
                                this.latchedEnt.field_70159_w = velo;
                            }
                        }
                    }
                    this.latchedEnt = null;
                    this.timeRunning = 0;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.latchedEnt == null) break block38;
                this.latchedHealth = this.latchedEnt.func_110143_aJ();
                this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_145848_d + 0.175, this.getMidCoord(1), (float)(this.face - 2) * 90.0f, 0.0f);
                this.latchedEnt.func_70661_as().func_75499_g();
                if (this.timeRunning < 12000) {
                    ++this.timeRunning;
                }
                if (Sync.hasCoFHCore) {
                    this.sendRFEnergyToNearbyDevices();
                }
                break block38;
            }
            for (Object aList : list) {
                Entity ent = (Entity)aList;
                if (!TileEntityTreadmill.isEntityValidForTreadmill(ent) || !(ent.field_70165_t > aabb.field_72340_a) || !(ent.field_70165_t < aabb.field_72336_d) || !(ent.field_70163_u > aabb.field_72338_b) || !(ent.field_70163_u < aabb.field_72337_e) || !(ent.field_70161_v > aabb.field_72339_c) || !(ent.field_70161_v < aabb.field_72334_f)) continue;
                this.latchedEnt = (EntityLiving)ent;
                this.latchedHealth = this.latchedEnt.func_110143_aJ();
                this.timeRunning = 0;
                this.latchedEnt.func_70012_b(this.getMidCoord(0), (double)this.field_145848_d + 0.175, this.getMidCoord(1), (float)(this.face - 2) * 90.0f, 0.0f);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
        }
    }

    @Optional.Method(modid="CoFHCore")
    private void sendRFEnergyToNearbyDevices() {
        float power = this.powerOutput() / (float)Sync.config.getInt("ratioRF");
        int handlerCount = 0;
        IEnergyHandler[] handlers = new IEnergyHandler[ForgeDirection.VALID_DIRECTIONS.length];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyHandler energy;
            TileEntity te;
            if (dir == ForgeDirection.UP || !((te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) instanceof IEnergyHandler) || te instanceof TileEntityDualVertical || !(energy = (IEnergyHandler)te).canConnectEnergy(dir.getOpposite())) continue;
            ++handlerCount;
            if (energy.receiveEnergy(dir.getOpposite(), (int)power, true) <= 0) continue;
            handlers[dir.getOpposite().ordinal()] = energy;
        }
        for (int i = 0; i < handlers.length; ++i) {
            IEnergyHandler handler = handlers[i];
            if (handler == null) continue;
            handler.receiveEnergy(ForgeDirection.getOrientation((int)i), Math.max(Math.round(power / (float)handlerCount), 1), false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        if (this.latchedEnt != null && this.pair != null) {
            double zVelo;
            double xVelo;
            double d = this.face == 1 ? -30.0 : (xVelo = this.face == 3 ? 30.0 : 0.0);
            double d2 = this.face == 0 ? 30.0 : (zVelo = this.face == 2 ? -30.0 : 0.0);
            if (this.field_145850_b.field_73012_v.nextFloat() < 0.5f) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityDiggingFX(this.field_145850_b, (double)((float)this.pair.field_145851_c + this.field_145850_b.field_73012_v.nextFloat()), (double)this.pair.field_145848_d + 0.4, (double)((float)this.pair.field_145849_e + this.field_145850_b.field_73012_v.nextFloat()), xVelo, 0.0, zVelo, Sync.blockDualVertical, 2).func_90019_g(2));
            } else {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityDiggingFX(this.field_145850_b, (double)((float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat()), (double)this.field_145848_d + 0.4, (double)((float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat()), xVelo, 0.0, zVelo, Sync.blockDualVertical, 2).func_90019_g(2));
            }
            if (this.timeRunning == 12000 && this.field_145850_b.field_73012_v.nextFloat() < 0.2f) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntitySmokeFX(this.field_145850_b, (double)((float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat()), (double)this.field_145848_d + 0.4, (double)((float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat()), xVelo *= 0.01, 0.0, zVelo *= 0.01));
            }
        }
    }

    public double getMidCoord(int i) {
        if (this.back && this.pair != null) {
            return this.pair.getMidCoord(i);
        }
        if (i == 0) {
            return this.face == 1 ? (double)this.field_145851_c : (this.face == 3 ? (double)(this.field_145851_c + 1) : (double)this.field_145851_c + 0.5);
        }
        return this.face == 0 ? (double)(this.field_145849_e + 1) : (this.face == 2 ? (double)this.field_145849_e : (double)this.field_145849_e + 0.5);
    }

    public float powerOutput() {
        if (this.back && this.pair != null) {
            return this.pair.powerOutput();
        }
        float power = 0.0f;
        if (this.latchedEnt != null) {
            power = Sync.treadmillEntityHashMap.get(this.latchedEnt.getClass()).intValue();
            if (this.latchedEnt instanceof EntityTameable && ((EntityTameable)this.latchedEnt).func_70909_n()) {
                power = power / 2.0f + power / 4.0f;
            }
            power += MathHelper.func_76131_a((float)((float)this.timeRunning / 12000.0f), (float)0.0f, (float)1.0f) * 2.0f;
        }
        return power;
    }

    public void setup(TileEntityTreadmill sc, boolean b, int face2) {
        this.pair = sc;
        this.back = b;
        this.face = face2;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("back", this.back);
        tag.func_74768_a("face", this.face);
        tag.func_74768_a("latchedID", this.latchedEnt != null ? this.latchedEnt.func_145782_y() : -1);
        tag.func_74768_a("timeRunning", this.timeRunning);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.back = tag.func_74767_n("back");
        this.face = tag.func_74762_e("face");
        this.latchedEntId = tag.func_74762_e("latchedID");
        this.timeRunning = tag.func_74762_e("timeRunning");
        this.resync = true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
    }

    public Block func_145838_q() {
        return Sync.blockDualVertical;
    }

    public static boolean isEntityValidForTreadmill(Entity entity) {
        return Sync.treadmillEntityHashMap.containsKey(entity.getClass()) && !((EntityLiving)entity).func_70631_g_() && (!(entity instanceof EntityTameable) || !((EntityTameable)entity).func_70906_o());
    }

    @Optional.Method(modid="CoFHCore")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean doExtract) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public boolean canConnectEnergy(ForgeDirection from) {
        return !this.back;
    }

    @Optional.Method(modid="CoFHCore")
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }
}

