/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import extracells.api.IFluidStorageCell;
import extracells.inventory.HandlerItemPlayerStorageFluid;
import extracells.inventory.HandlerItemStorageFluid;
import extracells.network.GuiHandler;
import extracells.render.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class FluidCellHandler
implements ICellHandler {
    public double cellIdleDrain(ItemStack is, IMEInventory handler) {
        return 0.0;
    }

    public IMEInventoryHandler getCellInventory(ItemStack itemStack, ISaveProvider saveProvider, StorageChannel channel) {
        if (channel == StorageChannel.ITEMS || !(itemStack.func_77973_b() instanceof IFluidStorageCell)) {
            return null;
        }
        return new HandlerItemStorageFluid(itemStack, saveProvider, ((IFluidStorageCell)itemStack.func_77973_b()).getFilter(itemStack));
    }

    public IMEInventoryHandler getCellInventoryPlayer(ItemStack itemStack, EntityPlayer player) {
        return new HandlerItemPlayerStorageFluid(itemStack, null, ((IFluidStorageCell)itemStack.func_77973_b()).getFilter(itemStack), player);
    }

    public int getStatusForCell(ItemStack is, IMEInventory handler) {
        if (handler == null) {
            return 0;
        }
        HandlerItemStorageFluid inventory = (HandlerItemStorageFluid)handler;
        if (inventory.freeBytes() == 0) {
            return 3;
        }
        if (inventory.isFormatted() || inventory.usedTypes() == inventory.totalBytes()) {
            return 2;
        }
        return 1;
    }

    public IIcon getTopTexture_Dark() {
        return TextureManager.TERMINAL_FRONT.getTextures()[0];
    }

    public IIcon getTopTexture_Light() {
        return TextureManager.TERMINAL_FRONT.getTextures()[2];
    }

    public IIcon getTopTexture_Medium() {
        return TextureManager.TERMINAL_FRONT.getTextures()[1];
    }

    public boolean isCell(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (is.func_77973_b() == null) {
            return false;
        }
        return is.func_77973_b() instanceof IFluidStorageCell;
    }

    public void openChestGui(EntityPlayer player, IChestOrDrive chest, ICellHandler cellHandler, IMEInventoryHandler inv, ItemStack is, StorageChannel chan) {
        if (chan != StorageChannel.FLUIDS) {
            return;
        }
        IStorageMonitorable monitorable = null;
        if (chest != null) {
            monitorable = ((IMEChest)chest).getMonitorable(ForgeDirection.UNKNOWN, (BaseActionSource)new PlayerSource(player, (IActionHost)chest));
        }
        if (monitorable != null) {
            GuiHandler.launchGui(GuiHandler.getGuiId(0), player, new Object[]{monitorable.getFluidInventory()});
        }
    }
}

