/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import toast.utilityMobs.BuildHelper;
import toast.utilityMobs.CommonProxy;
import toast.utilityMobs.EntityGolemFishHook;
import toast.utilityMobs.EventHandler;
import toast.utilityMobs.ManualHelper;
import toast.utilityMobs.Properties;
import toast.utilityMobs.RecipeSavePermissions;
import toast.utilityMobs.TargetHelper;
import toast.utilityMobs.TickHandler;
import toast.utilityMobs.golem.EntityUtilityGolem;
import toast.utilityMobs.network.GuiHelper;
import toast.utilityMobs.network.MessageExplosion;
import toast.utilityMobs.network.MessageFetchTargetHelper;
import toast.utilityMobs.network.MessageTargetHelper;
import toast.utilityMobs.network.MessageUseGolem;

@Mod(modid="UtilityMobs", name="Utility Mobs", version="3.1.1")
public class _UtilityMobs {
    public static final String MODID = "UtilityMobs";
    public static final String VERSION = "3.1.1";
    public static final boolean debug = false;
    @SidedProxy(clientSide="toast.utilityMobs.client.ClientProxy", serverSide="toast.utilityMobs.CommonProxy")
    public static CommonProxy proxy;
    public static final Random random;
    public static SimpleNetworkWrapper CHANNEL;
    public static final String TEXTURE = "UtilityMobs:textures/models/";
    public static final String[] UTILITY_TYPES;
    public static final String[][] UTILITY_NAMES;

    private void registerMobs() {
        int id = 0;
        EntityRegistry.registerModEntity(EntityUtilityGolem.class, (String)"GenericGolem", (int)id++, (Object)this, (int)80, (int)3, (boolean)true);
        for (int i = 0; i < UTILITY_NAMES.length; ++i) {
            String path = "toast.utilityMobs." + _UtilityMobs.decap(UTILITY_TYPES[i]) + ".Entity";
            for (int j = 0; j < UTILITY_NAMES[i].length; ++j) {
                try {
                    EntityRegistry.registerModEntity(Class.forName(path + UTILITY_NAMES[i][j]), (String)UTILITY_NAMES[i][j], (int)id++, (Object)this, (int)80, (int)3, (boolean)true);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    _UtilityMobs.debugException("@Entity" + UTILITY_NAMES[i][j] + ": class not found!");
                }
            }
        }
        EntityRegistry.registerModEntity(EntityGolemFishHook.class, (String)"UMFishHook", (int)id++, (Object)this, (int)64, (int)5, (boolean)true);
    }

    private static void addRecipes() {
        Item book = Properties.getBoolean("_general", "alternate_manuals") ? Items.field_151099_bA : Items.field_151122_aG;
        ItemStack[] items = new ItemStack[]{new ItemStack(Items.field_151144_bL, 1, 0), new ItemStack(Blocks.field_150423_aK), new ItemStack(Items.field_151144_bL, 1, 1), new ItemStack(Blocks.field_150367_z, 1, 0), new ItemStack(Items.field_151144_bL, 1, 4)};
        int i = items.length;
        while (i-- > 0) {
            GameRegistry.addShapelessRecipe((ItemStack)ManualHelper.manual(i), (Object[])new Object[]{book, items[i]});
        }
        GameRegistry.addShapelessRecipe((ItemStack)ManualHelper.upgradeManual(), (Object[])new Object[]{book, Items.field_151079_bi});
        GameRegistry.addShapelessRecipe((ItemStack)TargetHelper.book(0), (Object[])new Object[]{book, Items.field_151103_aS});
        GameRegistry.addShapelessRecipe((ItemStack)TargetHelper.book(1), (Object[])new Object[]{book, Items.field_151078_bh});
        GameRegistry.addRecipe((IRecipe)new RecipeSavePermissions());
        if (Properties.getBoolean("_general", "wither_conversion")) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151144_bL), (Object[])new Object[]{"&&&", "&@&", "&&&", Character.valueOf('@'), new ItemStack(Items.field_151144_bL, 1, 1), Character.valueOf('&'), Items.field_151060_bw});
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        _UtilityMobs.debugConsole("Loading in debug mode!");
        Properties.init(new Configuration(event.getSuggestedConfigurationFile()));
        TargetHelper.SAVE_DIRECTORY = new File(event.getModConfigurationDirectory(), MODID);
        CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("UM|Info");
        int id = 0;
        CHANNEL.registerMessage(MessageUseGolem.Handler.class, MessageUseGolem.class, id++, Side.SERVER);
        CHANNEL.registerMessage(MessageTargetHelper.Handler.class, MessageTargetHelper.class, id, Side.SERVER);
        if (event.getSide() == Side.CLIENT) {
            CHANNEL.registerMessage(MessageTargetHelper.Handler.class, MessageTargetHelper.class, id++, Side.CLIENT);
            CHANNEL.registerMessage(MessageFetchTargetHelper.Handler.class, MessageFetchTargetHelper.class, id++, Side.CLIENT);
            CHANNEL.registerMessage(MessageExplosion.Handler.class, MessageExplosion.class, id++, Side.CLIENT);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerMobs();
        _UtilityMobs.addRecipes();
        proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHelper());
        new BuildHelper();
        new TickHandler();
        new EventHandler();
    }

    public static String parseName(String name) {
        if (name.length() > 1) {
            for (int i = 1; i < name.length(); ++i) {
                if (!Character.isUpperCase(name.charAt(i))) continue;
                return name.substring(0, i) + " " + _UtilityMobs.parseName(name.substring(i));
            }
        }
        return name;
    }

    public static String cap(String string) {
        if (string.length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public static String decap(String string) {
        if (string.length() > 0) {
            return string.substring(0, 1).toLowerCase() + string.substring(1);
        }
        return string;
    }

    public static void console(String ... messages) {
        String message = "[UtilityMobs] [" + FMLCommonHandler.instance().getSide().name() + "] ";
        for (String part : messages) {
            message = message + part;
        }
        System.out.println(message);
    }

    public static void debugConsole(String ... messages) {
    }

    public static void debugException(String ... messages) {
        if (messages.length > 0) {
            messages[0] = "[ERROR] " + messages[0];
        }
        _UtilityMobs.console(messages);
    }

    static {
        random = new Random();
        UTILITY_TYPES = new String[]{"Block", "Golem", "Hostile", "Turret", "Colossal"};
        UTILITY_NAMES = new String[][]{{"AnvilGolem", "ChestEnderGolem", "ChestGolem", "ChestTrappedGolem", "FurnaceGolem", "JukeboxGolem", "LanternGolem", "WorkbenchGolem"}, {"ArmorGolem", "BoundSoul", "GildedGolem", "MelonGolem", "ObsidianGolem", "Scarecrow", "SteamGolem", "StoneGolem", "StoneLargeGolem", "UMIronGolem", "UMSnowGolem"}, new String[0], {"BrickTurret", "FireballTurret", "FireTurret", "GatlingTurret", "GhastTurret", "KillerTurret", "ObsidianTurret", "ShotgunTurret", "SniperTurret", "SnowTurret", "StoneTurret", "VolleyTurret"}, {"ArmorColossus", "ObsidianColossus", "StoneColossus"}};
        int length = 0;
        for (int i = 0; i < UTILITY_NAMES.length; ++i) {
            for (int j = 0; j < UTILITY_NAMES[i].length; ++j) {
                ++length;
            }
        }
    }
}

