/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.player;

import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import tconstruct.api.IPlayerExtendedInventoryWrapper;
import tconstruct.armor.player.ArmorExtended;
import tconstruct.armor.player.KnapsackInventory;

public class TPlayerStats
implements IExtendedEntityProperties,
IPlayerExtendedInventoryWrapper {
    public static final String PROP_NAME = "TConstruct";
    public WeakReference<EntityPlayer> player;
    public int level;
    public int bonusHealth;
    public int damage;
    public int hunger;
    public int previousDimension;
    public boolean climbWalls;
    public boolean activeGoggles = false;
    public boolean beginnerManual;
    public boolean materialManual;
    public boolean smelteryManual;
    public boolean weaponryManual;
    public boolean battlesignBonus;
    public int derpLevel;
    public ArmorExtended armor;
    public KnapsackInventory knapsack;

    public TPlayerStats() {
    }

    public TPlayerStats(EntityPlayer entityplayer) {
        this.player = new WeakReference<EntityPlayer>(entityplayer);
        this.armor = new ArmorExtended();
        this.armor.init(entityplayer);
        this.knapsack = new KnapsackInventory();
        this.knapsack.init(entityplayer);
        this.derpLevel = 1;
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tTag = new NBTTagCompound();
        this.armor.saveToNBT(tTag);
        this.knapsack.saveToNBT(tTag);
        tTag.func_74757_a("beginnerManual", this.beginnerManual);
        tTag.func_74757_a("materialManual", this.materialManual);
        tTag.func_74757_a("smelteryManual", this.smelteryManual);
        tTag.func_74757_a("weaponryManual", this.weaponryManual);
        tTag.func_74757_a("battlesignBonus", this.battlesignBonus);
        tTag.func_74768_a("derpLevel", this.derpLevel);
        compound.func_74782_a(PROP_NAME, (NBTBase)tTag);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(PROP_NAME);
        this.armor.readFromNBT(properties);
        this.knapsack.readFromNBT(properties);
        this.beginnerManual = properties.func_74767_n("beginnerManual");
        this.materialManual = properties.func_74767_n("materialManual");
        this.smelteryManual = properties.func_74767_n("smelteryManual");
        this.weaponryManual = properties.func_74767_n("weaponryManual");
        this.battlesignBonus = properties.func_74767_n("battlesignBonus");
        this.derpLevel = properties.func_74762_e("derpLevel");
    }

    public void init(Entity entity, World world) {
        this.player = new WeakReference<EntityPlayer>((EntityPlayer)entity);
        this.armor.init((EntityPlayer)entity);
        this.knapsack.init((EntityPlayer)entity);
    }

    public void copyFrom(TPlayerStats stats, boolean copyCalc) {
        this.armor = stats.armor;
        this.knapsack = stats.knapsack;
        this.beginnerManual = stats.beginnerManual;
        this.materialManual = stats.materialManual;
        this.smelteryManual = stats.smelteryManual;
        this.weaponryManual = stats.weaponryManual;
        this.battlesignBonus = stats.battlesignBonus;
        this.derpLevel = stats.derpLevel;
        if (copyCalc) {
            this.bonusHealth = stats.bonusHealth;
            this.hunger = stats.hunger;
            this.level = stats.level;
        }
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(PROP_NAME, (IExtendedEntityProperties)new TPlayerStats(player));
    }

    public static final TPlayerStats get(EntityPlayer player) {
        return (TPlayerStats)player.getExtendedProperties(PROP_NAME);
    }

    @Override
    public IInventory getKnapsackInventory(EntityPlayer player) {
        return this.knapsack;
    }

    @Override
    public IInventory getAccessoryInventory(EntityPlayer player) {
        return this.armor;
    }
}

