/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.network.PacketHandler;
import tuhljin.automagy.tiles.IInventariumBook;
import tuhljin.automagy.tiles.TileEntityInventarium;

public class MessageGUIInventariumRequest
implements IMessage,
IMessageHandler<MessageGUIInventariumRequest, IMessage> {
    protected int dim;
    protected int x;
    protected int y;
    protected int z;
    protected ItemStack stack;
    protected boolean rearrange;

    public MessageGUIInventariumRequest() {
    }

    public MessageGUIInventariumRequest(int dim, int x, int y, int z, ItemStack stack, boolean rearrange) {
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.stack = stack;
        this.rearrange = rearrange;
    }

    public MessageGUIInventariumRequest(World world, int x, int y, int z, ItemStack stack, boolean rearrange) {
        this(world.field_73011_w.field_76574_g, x, y, z, stack, rearrange);
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.stack = TjUtil.itemStackFromBytes(buf);
        this.rearrange = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        TjUtil.itemStackToBytes(buf, this.stack);
        buf.writeBoolean(this.rearrange);
    }

    public IMessage onMessage(MessageGUIInventariumRequest message, MessageContext ctx) {
        TileEntity te;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player != null && player.field_70170_p.field_73011_w.field_76574_g == message.dim && (te = player.field_70170_p.func_147438_o(message.x, message.y, message.z)) instanceof TileEntityInventarium) {
            ((TileEntityInventarium)te).receiveRequestFromClient(message.stack, message.rearrange);
        }
        return null;
    }

    public static void sendToServer(IInventariumBook book, ItemStack stack, boolean rearrange) {
        WorldSpecificCoordinates coord = book.getLinkCoord();
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGUIInventariumRequest(coord.dim, coord.x, coord.y, coord.z, stack, rearrange));
    }
}

