/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import cpw.mods.fml.common.registry.GameRegistry;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.RecipeSorter;
import xreliquary.Reliquary;
import xreliquary.items.alkahestry.AlkahestryCraftingRecipe;
import xreliquary.items.alkahestry.AlkahestryDrainRecipe;
import xreliquary.items.alkahestry.AlkahestryRedstoneRecipe;

public class XRRecipes {
    public static Item getItem(String name) {
        return Reliquary.CONTENT.getItem(name);
    }

    public static ItemStack emptyVoidTear() {
        return new ItemStack(XRRecipes.getItem("void_tear_empty"), 1, 0);
    }

    public static ItemStack witherSkull() {
        return new ItemStack(Items.field_151144_bL, 1, 1);
    }

    public static ItemStack roseBush() {
        return new ItemStack((Block)Blocks.field_150398_cm, 1, 4);
    }

    public static ItemStack blackWool() {
        return new ItemStack(Blocks.field_150325_L, 1, 15);
    }

    public static ItemStack lapis() {
        return new ItemStack(Items.field_151100_aR, 1, 4);
    }

    public static ItemStack gunPart(int i, int m) {
        return new ItemStack(XRRecipes.getItem("gun_part"), i, m);
    }

    public static ItemStack magazine(int m) {
        return XRRecipes.magazine(1, m);
    }

    public static ItemStack magazine(int i, int m) {
        return new ItemStack(XRRecipes.getItem("magazine"), i, m);
    }

    public static ItemStack bullet(int m) {
        return XRRecipes.bullet(1, m);
    }

    public static ItemStack bullet(int i, int m) {
        return new ItemStack(XRRecipes.getItem("bullet"), i, m);
    }

    public static ItemStack ingredient(int m) {
        return new ItemStack(XRRecipes.getItem("mob_ingredient"), 1, m);
    }

    public static ItemStack enderHeart() {
        return XRRecipes.ingredient(11);
    }

    public static ItemStack creeperGland() {
        return XRRecipes.ingredient(3);
    }

    public static ItemStack slimePearl() {
        return XRRecipes.ingredient(4);
    }

    public static ItemStack batWing() {
        return XRRecipes.ingredient(5);
    }

    public static ItemStack ribBone() {
        return XRRecipes.ingredient(0);
    }

    public static ItemStack witherRib() {
        return XRRecipes.ingredient(1);
    }

    public static ItemStack stormEye() {
        return XRRecipes.ingredient(8);
    }

    public static ItemStack fertileEssence() {
        return XRRecipes.ingredient(9);
    }

    public static ItemStack frozenCore() {
        return XRRecipes.ingredient(10);
    }

    public static ItemStack moltenCore() {
        return XRRecipes.ingredient(7);
    }

    public static ItemStack zombieHeart() {
        return XRRecipes.ingredient(6);
    }

    public static ItemStack infernalClaw() {
        return XRRecipes.ingredient(13);
    }

    public static ItemStack shellFragment() {
        return XRRecipes.ingredient(14);
    }

    public static ItemStack squidBeak() {
        return XRRecipes.ingredient(12);
    }

    public static ItemStack spiderFangs() {
        return XRRecipes.ingredient(2);
    }

    public static ItemStack heartPearl(int m) {
        return new ItemStack(XRRecipes.getItem("heart_pearl"), 1, m);
    }

    public static ItemStack nianZhu(int m) {
        return new ItemStack(XRRecipes.getItem("heart_zhu"), 1, m);
    }

    public static void addRecipe(boolean isShapeless, boolean overrideDisabler, ItemStack result, Object ... params) {
        if (!overrideDisabler) {
            boolean enabled;
            boolean bl = enabled = Reliquary.CONFIG.getGroup("recipe_enabled").containsKey(ContentHelper.getIdent(result.func_77973_b()).replace(':', '_')) && Reliquary.CONFIG.getBool("recipe_enabled", ContentHelper.getIdent(result.func_77973_b()).replace(':', '_'));
            if (!enabled) {
                return;
            }
            for (Object obj : params) {
                String unlocalizedName = null;
                if (obj instanceof Block) {
                    unlocalizedName = ContentHelper.getIdent((Block)obj);
                } else if (obj instanceof Item) {
                    unlocalizedName = ContentHelper.getIdent((Item)obj);
                } else if (obj instanceof ItemStack) {
                    unlocalizedName = ContentHelper.getIdent(((ItemStack)obj).func_77973_b());
                }
                if (unlocalizedName == null || !Reliquary.CONFIG.getKeys("recipe_enabled").contains(unlocalizedName.replace("xreliquary_", "xreliquary:"))) continue;
                enabled = enabled && Reliquary.CONFIG.getBool("recipe_enabled", unlocalizedName);
            }
            if (!enabled) {
                return;
            }
        }
        if (!isShapeless) {
            GameRegistry.addRecipe((ItemStack)result, (Object[])params);
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])params);
        }
    }

    private static boolean isEasyMode(String s) {
        return Reliquary.CONFIG.getBool("easy_mode_recipes", s);
    }

    public static void init() {
        GameRegistry.addRecipe((IRecipe)new AlkahestryDrainRecipe());
        GameRegistry.addRecipe((IRecipe)new AlkahestryRedstoneRecipe());
        GameRegistry.addRecipe((IRecipe)new AlkahestryCraftingRecipe());
        RecipeSorter.register((String)"xreliquary:alkahest_crafting", AlkahestryCraftingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shaped");
        RecipeSorter.register((String)"xreliquary:alkahest_redstone", AlkahestryRedstoneRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:xreliquary:alkahest_crafting");
        RecipeSorter.register((String)"xreliquary:alkahest_drain", AlkahestryDrainRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:xreliquary:alkahest_redstone");
        XRRecipes.addRecipe(true, true, new ItemStack(Blocks.field_150403_cj, 1, 0), Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, XRRecipes.frozenCore());
        XRRecipes.addRecipe(false, false, new ItemStack(Reliquary.CONTENT.getBlock("apothecary_mortar"), 1, 0), "gng", "ngn", "nnn", Character.valueOf('n'), Blocks.field_150371_ca, Character.valueOf('g'), XRRecipes.creeperGland());
        XRRecipes.addRecipe(false, false, new ItemStack(Reliquary.CONTENT.getBlock("apothecary_cauldron"), 1, 0), "gng", "ici", "nmn", Character.valueOf('g'), XRRecipes.creeperGland(), Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('i'), XRRecipes.infernalClaw(), Character.valueOf('c'), Items.field_151066_bu, Character.valueOf('m'), XRRecipes.moltenCore());
        if (XRRecipes.isEasyMode("alkahest_tome")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("alkahest_tome"), 1, 0), Items.field_151122_aG, XRRecipes.getItem("witch_hat"), XRRecipes.moltenCore(), XRRecipes.witherSkull());
        } else {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("alkahest_tome"), 1, 0), XRRecipes.moltenCore(), XRRecipes.getItem("witch_hat"), XRRecipes.stormEye(), XRRecipes.creeperGland(), Items.field_151122_aG, XRRecipes.slimePearl(), XRRecipes.spiderFangs(), XRRecipes.witherSkull(), XRRecipes.enderHeart());
        }
        if (XRRecipes.isEasyMode("altar")) {
            XRRecipes.addRecipe(true, false, new ItemStack(Reliquary.CONTENT.getBlock("altar_idle"), 1), Blocks.field_150343_Z, Blocks.field_150379_bu, XRRecipes.enderHeart(), XRRecipes.creeperGland());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(Reliquary.CONTENT.getBlock("altar_idle"), 1), "dnd", "olo", "dgd", Character.valueOf('d'), Items.field_151114_aO, Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('l'), Blocks.field_150379_bu, Character.valueOf('g'), XRRecipes.creeperGland());
        }
        XRRecipes.addRecipe(true, false, new ItemStack(Reliquary.CONTENT.getBlock("lilypad"), 1), XRRecipes.fertileEssence(), XRRecipes.fertileEssence(), XRRecipes.fertileEssence(), Blocks.field_150392_bi);
        XRRecipes.addRecipe(true, false, new ItemStack(Reliquary.CONTENT.getBlock("wraith_node"), 1), XRRecipes.enderHeart(), Items.field_151166_bC);
        if (XRRecipes.isEasyMode("interdiction_torch")) {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("interdiction_torch"), 4, 0), "bm", "nr", Character.valueOf('b'), XRRecipes.batWing(), Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('r'), Items.field_151072_bj);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("interdiction_torch"), 4, 0), " n ", "mdm", "bwb", Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('d'), Items.field_151045_i, Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('w'), XRRecipes.batWing());
        }
        XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("glowing_bread"), 3), Items.field_151025_P, Items.field_151025_P, Items.field_151025_P, XRRecipes.getItem("glowing_water"));
        if (XRRecipes.isEasyMode("fertile_essence")) {
            XRRecipes.addRecipe(true, false, XRRecipes.fertileEssence(), XRRecipes.ribBone(), XRRecipes.creeperGland(), new ItemStack(Items.field_151100_aR, 1, 2), XRRecipes.slimePearl());
        } else {
            XRRecipes.addRecipe(false, false, XRRecipes.fertileEssence(), "gbg", "scs", "gbg", Character.valueOf('g'), XRRecipes.creeperGland(), Character.valueOf('b'), XRRecipes.ribBone(), Character.valueOf('s'), XRRecipes.slimePearl(), Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 2));
        }
        XRRecipes.addRecipe(true, true, new ItemStack(Items.field_151074_bl, 1), XRRecipes.bullet(1, 0), XRRecipes.bullet(1, 0), XRRecipes.bullet(1, 0), XRRecipes.bullet(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 1), Items.field_151145_ak, Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 2), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.zombieHeart());
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 3), Items.field_151065_br, Items.field_151072_bj, Items.field_151074_bl, Items.field_151074_bl);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 4), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.enderHeart());
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 5), Items.field_151123_aH, Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 6), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.creeperGland());
        if (XRRecipes.isEasyMode("seeker_shot")) {
            XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 7), XRRecipes.lapis(), Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        } else {
            XRRecipes.addRecipe(true, false, XRRecipes.bullet(4, 7), XRRecipes.lapis(), XRRecipes.slimePearl(), Items.field_151074_bl, Items.field_151016_H);
        }
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 8), Blocks.field_150322_A, Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 9), XRRecipes.stormEye(), Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        XRRecipes.addRecipe(false, false, XRRecipes.magazine(5, 0), "i i", "igi", "sis", Character.valueOf('s'), Blocks.field_150348_b, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('g'), Blocks.field_150359_w);
        XRRecipes.addRecipe(true, false, XRRecipes.magazine(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.magazine(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.magazine(1, 2), XRRecipes.bullet(1, 2), XRRecipes.bullet(1, 2), XRRecipes.bullet(1, 2), XRRecipes.bullet(1, 2), XRRecipes.bullet(1, 2), XRRecipes.bullet(1, 2), XRRecipes.bullet(1, 2), XRRecipes.bullet(1, 2), XRRecipes.magazine(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.magazine(1, 3), XRRecipes.bullet(1, 3), XRRecipes.bullet(1, 3), XRRecipes.bullet(1, 3), XRRecipes.bullet(1, 3), XRRecipes.bullet(1, 3), XRRecipes.bullet(1, 3), XRRecipes.bullet(1, 3), XRRecipes.bullet(1, 3), XRRecipes.magazine(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.magazine(1, 4), XRRecipes.bullet(1, 4), XRRecipes.bullet(1, 4), XRRecipes.bullet(1, 4), XRRecipes.bullet(1, 4), XRRecipes.bullet(1, 4), XRRecipes.bullet(1, 4), XRRecipes.bullet(1, 4), XRRecipes.bullet(1, 4), XRRecipes.magazine(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.magazine(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.magazine(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.magazine(1, 6), XRRecipes.bullet(1, 6), XRRecipes.bullet(1, 6), XRRecipes.bullet(1, 6), XRRecipes.bullet(1, 6), XRRecipes.bullet(1, 6), XRRecipes.bullet(1, 6), XRRecipes.bullet(1, 6), XRRecipes.bullet(1, 6), XRRecipes.magazine(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.magazine(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.magazine(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.magazine(1, 8), XRRecipes.bullet(1, 8), XRRecipes.bullet(1, 8), XRRecipes.bullet(1, 8), XRRecipes.bullet(1, 8), XRRecipes.bullet(1, 8), XRRecipes.bullet(1, 8), XRRecipes.bullet(1, 8), XRRecipes.bullet(1, 8), XRRecipes.magazine(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.magazine(1, 9), XRRecipes.bullet(1, 9), XRRecipes.bullet(1, 9), XRRecipes.bullet(1, 9), XRRecipes.bullet(1, 9), XRRecipes.bullet(1, 9), XRRecipes.bullet(1, 9), XRRecipes.bullet(1, 9), XRRecipes.bullet(1, 9), XRRecipes.magazine(1, 0));
        XRRecipes.addRecipe(false, false, XRRecipes.gunPart(1, 0), "iii", "imi", "ici", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('c'), XRRecipes.magazine(1, 0), Character.valueOf('m'), Items.field_151064_bs);
        XRRecipes.addRecipe(false, false, XRRecipes.gunPart(1, 1), "iii", "eme", "iii", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('e'), XRRecipes.enderHeart(), Character.valueOf('m'), Items.field_151064_bs);
        XRRecipes.addRecipe(false, false, XRRecipes.gunPart(1, 2), "iib", "rmi", "iii", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), Blocks.field_150430_aB, Character.valueOf('r'), Items.field_151072_bj, Character.valueOf('m'), XRRecipes.moltenCore());
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("handgun"), 1, 0), "bim", "isi", "igi", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), XRRecipes.gunPart(1, 1), Character.valueOf('m'), XRRecipes.gunPart(1, 2), Character.valueOf('g'), XRRecipes.gunPart(1, 0), Character.valueOf('s'), XRRecipes.slimePearl());
        if (XRRecipes.isEasyMode("fortune_coin")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("fortune_coin"), 1), XRRecipes.enderHeart(), Items.field_151074_bl, XRRecipes.slimePearl(), XRRecipes.batWing());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("fortune_coin"), 1), "ege", "gng", "ege", Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('n'), XRRecipes.enderHeart());
        }
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("mercy_cross"), 1), "wgr", "glg", "sgz", Character.valueOf('w'), XRRecipes.witherRib(), Character.valueOf('g'), Items.field_151043_k, Character.valueOf('r'), XRRecipes.ribBone(), Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('s'), new ItemStack(Items.field_151144_bL, 1, 1), Character.valueOf('z'), XRRecipes.zombieHeart());
        XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("holy_hand_grenade"), 4), XRRecipes.getItem("glowing_water"), Items.field_151074_bl, Blocks.field_150335_W, XRRecipes.creeperGland());
        if (XRRecipes.isEasyMode("sojourner_staff")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("sojourner_staff"), 1), XRRecipes.moltenCore(), Items.field_151043_k, Items.field_151072_bj, XRRecipes.emptyVoidTear());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("sojourner_staff"), 1), "gcm", "itc", "big", Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('c'), Items.field_151064_bs, Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('i'), Items.field_151043_k, Character.valueOf('t'), XRRecipes.getItem("infernal_tear"), Character.valueOf('b'), Items.field_151072_bj);
        }
        if (XRRecipes.isEasyMode("lantern_of_paranoia")) {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("lantern_of_paranoia"), 1), "isi", "gmg", " i ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('s'), XRRecipes.slimePearl(), Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('m'), XRRecipes.moltenCore());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("lantern_of_paranoia"), 1), "imi", "gtg", "ili", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('t'), Reliquary.CONTENT.getBlock("interdiction_torch"), Character.valueOf('l'), XRRecipes.creeperGland());
        }
        XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("midas_touchstone"), 1, 0), Blocks.field_150467_bQ, Blocks.field_150340_R, Blocks.field_150340_R, XRRecipes.moltenCore(), XRRecipes.moltenCore(), XRRecipes.moltenCore(), XRRecipes.creeperGland(), XRRecipes.creeperGland(), XRRecipes.emptyVoidTear());
        if (XRRecipes.isEasyMode("emperor_chalice")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("emperor_chalice"), 1, 0), Items.field_151166_bC, Items.field_151043_k, Items.field_151133_ar, XRRecipes.emptyVoidTear());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("emperor_chalice"), 1, 0), "ses", "ivi", "lbl", Character.valueOf('s'), XRRecipes.slimePearl(), Character.valueOf('e'), Items.field_151166_bC, Character.valueOf('i'), Items.field_151043_k, Character.valueOf('v'), XRRecipes.emptyVoidTear(), Character.valueOf('l'), XRRecipes.lapis(), Character.valueOf('b'), Items.field_151133_ar);
        }
        if (XRRecipes.isEasyMode("infernal_chalice")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("infernal_chalice"), 1), XRRecipes.getItem("infernal_claws"), XRRecipes.getItem("emperor_chalice"), XRRecipes.getItem("infernal_tear"), XRRecipes.moltenCore());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("infernal_chalice"), 1), "imi", "wcw", "mtm", Character.valueOf('i'), XRRecipes.getItem("infernal_claws"), Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('w'), XRRecipes.witherRib(), Character.valueOf('c'), XRRecipes.getItem("emperor_chalice"), Character.valueOf('t'), XRRecipes.getItem("infernal_tear"));
        }
        if (XRRecipes.isEasyMode("salamander_eye")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("salamander_eye"), 1), Items.field_151061_bv, XRRecipes.moltenCore(), XRRecipes.frozenCore(), XRRecipes.enderHeart());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("salamander_eye"), 1), "fnm", "geg", "mnf", Character.valueOf('f'), XRRecipes.frozenCore(), Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('e'), Items.field_151061_bv);
        }
        if (XRRecipes.isEasyMode("ice_magus_rod")) {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("ice_magus_rod"), 1, 0), " df", " vd", "i  ", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('f'), XRRecipes.frozenCore(), Character.valueOf('i'), Items.field_151042_j, Character.valueOf('v'), XRRecipes.emptyVoidTear());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("ice_magus_rod"), 1, 0), "fdf", "ptd", "ipf", Character.valueOf('f'), XRRecipes.frozenCore(), Character.valueOf('d'), Items.field_151045_i, Character.valueOf('p'), Blocks.field_150403_cj, Character.valueOf('t'), XRRecipes.emptyVoidTear(), Character.valueOf('i'), Items.field_151042_j);
        }
        if (XRRecipes.isEasyMode("glacial_staff")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("glacial_staff"), 1, 0), XRRecipes.getItem("ice_magus_rod"), XRRecipes.emptyVoidTear(), XRRecipes.frozenCore(), XRRecipes.getItem("shears_of_winter"));
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("glacial_staff"), 1, 0), "fds", "fvd", "iff", Character.valueOf('f'), XRRecipes.frozenCore(), Character.valueOf('d'), Items.field_151045_i, Character.valueOf('s'), XRRecipes.getItem("shears_of_winter"), Character.valueOf('v'), XRRecipes.emptyVoidTear(), Character.valueOf('i'), XRRecipes.getItem("ice_magus_rod"));
        }
        if (XRRecipes.isEasyMode("ender_staff")) {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("ender_staff"), 1, 0), " be", "nvb", "sn ", Character.valueOf('v'), XRRecipes.getItem("void_tear"), Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('s'), Items.field_151055_y, Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('b'), XRRecipes.batWing());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("ender_staff"), 1, 0), "nbe", "nvb", "rnn", Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('b'), XRRecipes.batWing(), Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('v'), XRRecipes.emptyVoidTear(), Character.valueOf('r'), Items.field_151072_bj);
        }
        if (XRRecipes.isEasyMode("rending_gale")) {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("rending_gale"), 1, 0), " be", "gvb", "sg ", Character.valueOf('b'), XRRecipes.batWing(), Character.valueOf('e'), XRRecipes.stormEye(), Character.valueOf('g'), Items.field_151043_k, Character.valueOf('v'), XRRecipes.emptyVoidTear(), Character.valueOf('s'), Items.field_151055_y);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("rending_gale"), 1, 0), "ebe", "fvb", "rfe", Character.valueOf('e'), XRRecipes.stormEye(), Character.valueOf('b'), XRRecipes.batWing(), Character.valueOf('f'), XRRecipes.getItem("angelic_feather"), Character.valueOf('v'), XRRecipes.emptyVoidTear(), Character.valueOf('r'), Items.field_151072_bj);
        }
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("harvest_rod"), 1, 0), " rf", "vtr", "sv ", Character.valueOf('r'), XRRecipes.roseBush(), Character.valueOf('f'), XRRecipes.fertileEssence(), Character.valueOf('v'), Blocks.field_150395_bd, Character.valueOf('t'), XRRecipes.emptyVoidTear(), Character.valueOf('s'), Items.field_151055_y);
        if (XRRecipes.isEasyMode("pyromancer_staff")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("pyromancer_staff"), 1, 0), XRRecipes.getItem("infernal_claws"), Items.field_151072_bj, XRRecipes.getItem("infernal_tear"), XRRecipes.getItem("salamander_eye"));
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("pyromancer_staff"), 1, 0), "mcs", "mic", "rmm", Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('c'), XRRecipes.getItem("infernal_claws"), Character.valueOf('s'), XRRecipes.getItem("salamander_eye"), Character.valueOf('i'), XRRecipes.getItem("infernal_tear"), Character.valueOf('r'), Items.field_151072_bj);
        }
        if (XRRecipes.isEasyMode("serpent_staff")) {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("serpent_staff"), 1), " ce", " kc", "s  ", Character.valueOf('c'), XRRecipes.spiderFangs(), Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('k'), XRRecipes.shellFragment(), Character.valueOf('b'), Items.field_151055_y);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("serpent_staff"), 1), "coe", "pko", "bpc", Character.valueOf('c'), XRRecipes.spiderFangs(), Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('p'), XRRecipes.slimePearl(), Character.valueOf('k'), XRRecipes.shellFragment(), Character.valueOf('b'), Items.field_151072_bj);
        }
        if (XRRecipes.isEasyMode("rod_of_lyssa")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("rod_of_lyssa"), 1, 0), XRRecipes.infernalClaw(), XRRecipes.batWing(), XRRecipes.enderHeart(), Items.field_151112_aM);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("rod_of_lyssa"), 1, 0), " br", "nms", "r i", Character.valueOf('b'), XRRecipes.batWing(), Character.valueOf('r'), Items.field_151072_bj, Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('s'), Items.field_151007_F, Character.valueOf('i'), XRRecipes.infernalClaw());
        }
        XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("shears_of_winter"), 1, 0), XRRecipes.frozenCore(), Items.field_151097_aZ, Items.field_151045_i, Items.field_151045_i);
        if (XRRecipes.isEasyMode("magicbane")) {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("magicbane"), 1, 0), "ng", "in", Character.valueOf('g'), Items.field_151043_k, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('n'), XRRecipes.enderHeart());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("magicbane"), 1, 0), "een", "nge", "ine", Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('g'), Items.field_151043_k, Character.valueOf('i'), Items.field_151042_j);
        }
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("witherless_rose"), 1), "fnf", "nrn", "fnf", Character.valueOf('f'), XRRecipes.fertileEssence(), Character.valueOf('n'), Items.field_151156_bN, Character.valueOf('r'), XRRecipes.roseBush());
        XRRecipes.addRecipe(true, false, XRRecipes.ingredient(15), new ItemStack(Blocks.field_150325_L, 1, 14), new ItemStack(Blocks.field_150325_L, 1, 15), XRRecipes.enderHeart(), XRRecipes.enderHeart());
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("twilight_cloak"), 1), "ici", "bcb", "bcb", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), XRRecipes.blackWool(), Character.valueOf('c'), XRRecipes.ingredient(15));
        if (XRRecipes.isEasyMode("void_tear")) {
            XRRecipes.addRecipe(true, false, XRRecipes.emptyVoidTear(), Items.field_151073_bk, XRRecipes.enderHeart(), XRRecipes.slimePearl(), XRRecipes.lapis());
        } else {
            XRRecipes.addRecipe(false, false, XRRecipes.emptyVoidTear(), "lel", "pgp", "lnl", Character.valueOf('l'), XRRecipes.lapis(), Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('p'), XRRecipes.slimePearl(), Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('n'), XRRecipes.enderHeart());
        }
        if (XRRecipes.isEasyMode("infernal_tear")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("infernal_tear"), 1, 0), XRRecipes.emptyVoidTear(), XRRecipes.getItem("witch_hat"), XRRecipes.moltenCore(), XRRecipes.infernalClaw());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("infernal_tear"), 1, 0), "php", "mtm", "pcp", Character.valueOf('p'), Items.field_151065_br, Character.valueOf('h'), XRRecipes.getItem("witch_hat"), Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('t'), XRRecipes.emptyVoidTear(), Character.valueOf('c'), XRRecipes.infernalClaw());
        }
        if (XRRecipes.isEasyMode("angelic_feather")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("angelic_feather"), 1), Items.field_151008_G, XRRecipes.enderHeart(), XRRecipes.batWing(), XRRecipes.fertileEssence());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("angelic_feather"), 1), "dgd", "bfb", "ene", Character.valueOf('d'), Items.field_151114_aO, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('b'), XRRecipes.batWing(), Character.valueOf('e'), XRRecipes.fertileEssence(), Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('f'), Items.field_151008_G);
        }
        XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("phoenix_down"), 1), XRRecipes.getItem("angelheart_vial"), XRRecipes.getItem("angelheart_vial"), XRRecipes.getItem("angelheart_vial"), XRRecipes.getItem("angelic_feather"));
        XRRecipes.addRecipe(true, false, XRRecipes.infernalClaw(), Items.field_151116_aA, XRRecipes.moltenCore(), XRRecipes.ribBone(), XRRecipes.slimePearl());
        if (XRRecipes.isEasyMode("infernal_claws")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("infernal_claws"), 1), XRRecipes.infernalClaw(), XRRecipes.infernalClaw(), XRRecipes.infernalClaw(), XRRecipes.slimePearl());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("infernal_claws"), 1), "ccc", "cpc", "mlm", Character.valueOf('c'), XRRecipes.infernalClaw(), Character.valueOf('p'), XRRecipes.slimePearl(), Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('l'), Items.field_151116_aA);
        }
        XRRecipes.addRecipe(true, true, new ItemStack(Items.field_151100_aR, 2, 15), XRRecipes.squidBeak());
        XRRecipes.addRecipe(true, true, new ItemStack(Items.field_151100_aR, 6, 15), XRRecipes.ribBone());
        XRRecipes.addRecipe(true, true, new ItemStack(Items.field_151100_aR, 8, 15), XRRecipes.witherRib());
        XRRecipes.addRecipe(true, false, XRRecipes.shellFragment(), XRRecipes.squidBeak(), XRRecipes.squidBeak(), XRRecipes.squidBeak(), XRRecipes.slimePearl());
        if (XRRecipes.isEasyMode("kraken_shell")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("kraken_shell"), 1, 0), XRRecipes.shellFragment(), XRRecipes.shellFragment(), XRRecipes.shellFragment(), XRRecipes.enderHeart());
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("kraken_shell"), 1, 0), "nfn", "epe", "fnf", Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('f'), XRRecipes.shellFragment(), Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('p'), XRRecipes.slimePearl());
        }
        if (XRRecipes.isEasyMode("hero_medallion")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("hero_medallion"), 1), XRRecipes.enderHeart(), new ItemStack(XRRecipes.getItem("fortune_coin"), 1, -1), XRRecipes.getItem("witch_hat"), XRRecipes.getItem("infernal_tear"));
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("hero_medallion"), 1), "nie", "iti", "fin", Character.valueOf('n'), XRRecipes.enderHeart(), Character.valueOf('i'), Items.field_151042_j, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('t'), XRRecipes.getItem("infernal_tear"), Character.valueOf('f'), new ItemStack(XRRecipes.getItem("fortune_coin"), 1, -1));
        }
        if (XRRecipes.isEasyMode("destruction_catalyst")) {
            XRRecipes.addRecipe(true, false, new ItemStack(XRRecipes.getItem("destruction_catalyst"), 1, 0), Items.field_151033_d, XRRecipes.moltenCore(), XRRecipes.creeperGland(), XRRecipes.getItem("infernal_tear"));
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("destruction_catalyst"), 1, 0), "tmc", "gim", "fgt", Character.valueOf('t'), Blocks.field_150335_W, Character.valueOf('m'), XRRecipes.moltenCore(), Character.valueOf('c'), XRRecipes.creeperGland(), Character.valueOf('g'), Items.field_151043_k, Character.valueOf('i'), XRRecipes.getItem("infernal_tear"), Character.valueOf('f'), Items.field_151033_d);
        }
        XRRecipes.addRecipe(false, false, XRRecipes.heartPearl(0), "ppp", "sts", "ppp", Character.valueOf('p'), XRRecipes.zombieHeart(), Character.valueOf('s'), Items.field_151078_bh, Character.valueOf('t'), Items.field_151103_aS);
        XRRecipes.addRecipe(false, false, XRRecipes.heartPearl(1), "ppp", "sts", "ppp", Character.valueOf('p'), XRRecipes.ribBone(), Character.valueOf('s'), Items.field_151103_aS, Character.valueOf('t'), Items.field_151145_ak);
        XRRecipes.addRecipe(false, false, XRRecipes.heartPearl(2), "ppp", "sts", "ppp", Character.valueOf('p'), XRRecipes.witherRib(), Character.valueOf('s'), Items.field_151103_aS, Character.valueOf('t'), XRRecipes.witherSkull());
        XRRecipes.addRecipe(false, false, XRRecipes.heartPearl(3), "ppp", "sts", "ppp", Character.valueOf('p'), XRRecipes.creeperGland(), Character.valueOf('s'), Items.field_151016_H, Character.valueOf('t'), Items.field_151103_aS);
        XRRecipes.addRecipe(true, false, XRRecipes.nianZhu(0), Items.field_151007_F, XRRecipes.heartPearl(0), XRRecipes.heartPearl(0), XRRecipes.heartPearl(0), XRRecipes.heartPearl(0), XRRecipes.heartPearl(0), XRRecipes.heartPearl(0));
        XRRecipes.addRecipe(true, false, XRRecipes.nianZhu(1), Items.field_151007_F, XRRecipes.heartPearl(1), XRRecipes.heartPearl(1), XRRecipes.heartPearl(1), XRRecipes.heartPearl(1), XRRecipes.heartPearl(1), XRRecipes.heartPearl(1));
        XRRecipes.addRecipe(true, false, XRRecipes.nianZhu(2), Items.field_151007_F, XRRecipes.heartPearl(2), XRRecipes.heartPearl(2), XRRecipes.heartPearl(2), XRRecipes.heartPearl(2), XRRecipes.heartPearl(2), XRRecipes.heartPearl(2));
        XRRecipes.addRecipe(true, false, XRRecipes.nianZhu(3), Items.field_151007_F, XRRecipes.heartPearl(3), XRRecipes.heartPearl(3), XRRecipes.heartPearl(3), XRRecipes.heartPearl(3), XRRecipes.heartPearl(3), XRRecipes.heartPearl(3));
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("potion"), 1, 0), "g g", "g g", " g ", Character.valueOf('g'), Blocks.field_150410_aZ);
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("glowing_water"), 5), "gbg", "gdg", "ngp", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('b'), Items.field_151131_as, Character.valueOf('d'), Items.field_151114_aO, Character.valueOf('p'), Items.field_151016_H, Character.valueOf('n'), Items.field_151075_bm);
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("angelheart_vial"), 5), "gbg", "gcg", "fgf", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('b'), Items.field_151117_aB, Character.valueOf('c'), XRRecipes.infernalClaw(), Character.valueOf('f'), XRRecipes.fertileEssence());
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("attraction_potion"), 5), "gbg", "gfg", "rgc", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('b'), Items.field_151131_as, Character.valueOf('f'), XRRecipes.fertileEssence(), Character.valueOf('r'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 3));
        XRRecipes.addRecipe(false, false, new ItemStack(XRRecipes.getItem("fertile_potion"), 5), "gbg", "gfg", "cgy", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('b'), Items.field_151131_as, Character.valueOf('f'), XRRecipes.fertileEssence(), Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 2), Character.valueOf('y'), new ItemStack(Items.field_151100_aR, 1, 11));
    }
}

