/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.TextField;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.util.EnumChatFormatting;

public class SearchField
extends TextField
implements ItemFilter.ItemFilterProvider {
    public static List<ISearchProvider> searchProviders = new LinkedList<ISearchProvider>();
    long lastclicktime;

    public SearchField(String ident) {
        super(ident);
        API.addItemFilter(this);
        API.addSearchProvider(new DefaultSearchProvider());
    }

    public static boolean searchInventories() {
        return NEIClientConfig.world.nbt.func_74767_n("searchinventories");
    }

    @Override
    public void drawBox() {
        if (SearchField.searchInventories()) {
            GuiDraw.drawGradientRect((int)this.x, (int)this.y, (int)this.w, (int)this.h, (int)-256, (int)-4149248);
        } else {
            GuiDraw.drawRect((int)this.x, (int)this.y, (int)this.w, (int)this.h, (int)-6250336);
        }
        GuiDraw.drawRect((int)(this.x + 1), (int)(this.y + 1), (int)(this.w - 2), (int)(this.h - 2), (int)-16777216);
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (button == 0) {
            if (this.focused() && System.currentTimeMillis() - this.lastclicktime < 500L) {
                NEIClientConfig.world.nbt.func_74757_a("searchinventories", !SearchField.searchInventories());
                NEIClientConfig.world.saveNBT();
            }
            this.lastclicktime = System.currentTimeMillis();
        }
        return super.handleClick(mousex, mousey, button);
    }

    @Override
    public void onTextChange(String oldText) {
        NEIClientConfig.setSearchExpression(this.text());
        ItemList.updateFilter.restart();
    }

    @Override
    public void lastKeyTyped(int keyID, char keyChar) {
        if (keyID == NEIClientConfig.getKeyBinding("gui.search")) {
            this.setFocus(true);
        }
    }

    @Override
    public String filterText(String s) {
        return EnumChatFormatting.func_110646_a((String)s);
    }

    public static Pattern getPattern(String search) {
        switch (NEIClientConfig.getIntSetting("inventory.searchmode")) {
            case 0: {
                search = "\\Q" + search + "\\E";
                break;
            }
            case 1: {
                search = search.replace(".", "").replace("?", ".").replace("*", ".+?");
            }
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(search);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return pattern == null || pattern.toString().length() == 0 ? null : pattern;
    }

    @Override
    public ItemFilter getFilter() {
        String s_filter = this.text().toLowerCase();
        LinkedList<ItemFilter> primary = new LinkedList<ItemFilter>();
        LinkedList<ItemFilter> secondary = new LinkedList<ItemFilter>();
        for (ISearchProvider p : searchProviders) {
            ItemFilter filter = p.getFilter(s_filter);
            if (filter == null) continue;
            (p.isPrimary() ? primary : secondary).add(filter);
        }
        if (!primary.isEmpty()) {
            return new ItemList.AnyMultiItemFilter(primary);
        }
        if (!secondary.isEmpty()) {
            return new ItemList.AnyMultiItemFilter(secondary);
        }
        return new ItemList.EverythingItemFilter();
    }

    private static class DefaultSearchProvider
    implements ISearchProvider {
        private DefaultSearchProvider() {
        }

        @Override
        public boolean isPrimary() {
            return false;
        }

        @Override
        public ItemFilter getFilter(String searchText) {
            Pattern pattern = SearchField.getPattern(searchText);
            return pattern == null ? null : new ItemList.PatternItemFilter(pattern);
        }
    }

    public static interface ISearchProvider {
        public boolean isPrimary();

        public ItemFilter getFilter(String var1);
    }
}

