/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ComparableItemStackSafe
extends ComparableItemStack {
    static final String BLOCK = "block";
    static final String ORE = "ore";
    static final String DUST = "dust";
    static final String INGOT = "ingot";
    static final String NUGGET = "nugget";

    public static boolean safeOreType(String string) {
        return string.startsWith(BLOCK) || string.startsWith(ORE) || string.startsWith(DUST) || string.startsWith(INGOT) || string.startsWith(NUGGET);
    }

    public static int getOreID(ItemStack itemStack) {
        int n = ItemHelper.oreProxy.getOreID(itemStack);
        if (!ComparableItemStackSafe.safeOreType(ItemHelper.oreProxy.getOreName(n))) {
            return -1;
        }
        return n;
    }

    public static int getOreID(String string) {
        if (!ComparableItemStackSafe.safeOreType(string)) {
            return -1;
        }
        return ItemHelper.oreProxy.getOreID(string);
    }

    public ComparableItemStackSafe(ItemStack itemStack) {
        super(itemStack);
        this.oreID = ComparableItemStackSafe.getOreID(itemStack);
    }

    public ComparableItemStackSafe(Item item, int n, int n2) {
        super(item, n, n2);
        this.oreID = ComparableItemStackSafe.getOreID(this.toItemStack());
    }

    @Override
    public ComparableItemStackSafe set(ItemStack itemStack) {
        super.set(itemStack);
        this.oreID = ComparableItemStackSafe.getOreID(itemStack);
        return this;
    }
}

