/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.items;

import appeng.api.config.AccessRestriction;
import appeng.api.config.PowerMultiplier;
import appeng.core.localization.GuiText;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thaumicenergistics.api.IWirelessEssentiaTerminal;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.inventory.HandlerWirelessEssentiaTerminal;
import thaumicenergistics.registries.ThEStrings;

public class ItemWirelessEssentiaTerminal
extends Item
implements IWirelessEssentiaTerminal {
    private static final String NBT_AE_SOURCE_KEY = "SourceKey";
    private static final String NBT_STORED_POWER = "StoredPower";
    private static final int POWER_STORAGE = 1600000;
    public static double GLOBAL_POWER_MULTIPLIER = PowerMultiplier.CONFIG.multiplier;

    public ItemWirelessEssentiaTerminal() {
        this.func_77625_d(1);
        this.func_77656_e(32);
        this.field_77787_bX = false;
    }

    private NBTTagCompound getOrCreateCompoundTag(ItemStack wirelessTerminal) {
        NBTTagCompound dataTag;
        if (!wirelessTerminal.func_77942_o()) {
            dataTag = new NBTTagCompound();
            wirelessTerminal.func_77982_d(dataTag);
        } else {
            dataTag = wirelessTerminal.func_77978_p();
        }
        return dataTag;
    }

    public void func_77624_a(ItemStack wirelessTerminal, EntityPlayer player, List tooltip, boolean advancedItemTooltips) {
        double storedPower = this.getAECurrentPower(wirelessTerminal);
        tooltip.add(String.format("%s %.0f AE - %.1f%%", GuiText.StoredEnergy.getLocal(), storedPower, 100.0 * (storedPower / 1600000.0)));
        if (HandlerWirelessEssentiaTerminal.isTerminalLinked(this, wirelessTerminal)) {
            tooltip.add(GuiText.Linked.getLocal());
        } else {
            tooltip.add(GuiText.Unlinked.getLocal());
        }
    }

    public double extractAEPower(ItemStack wirelessTerminal, double amount) {
        double canExtractAmount;
        double storedPower = this.getAECurrentPower(wirelessTerminal);
        if (storedPower == 0.0) {
            return 0.0;
        }
        if ((storedPower -= (canExtractAmount = Math.min(amount, storedPower))) <= 0.0) {
            this.getOrCreateCompoundTag(wirelessTerminal).func_82580_o(NBT_STORED_POWER);
        } else {
            this.getOrCreateCompoundTag(wirelessTerminal).func_74780_a(NBT_STORED_POWER, storedPower);
        }
        return canExtractAmount;
    }

    public double getAECurrentPower(ItemStack wirelessTerminal) {
        if (GLOBAL_POWER_MULTIPLIER == 0.0) {
            return 1600000.0;
        }
        NBTTagCompound data = this.getOrCreateCompoundTag(wirelessTerminal);
        if (!data.func_74764_b(NBT_STORED_POWER)) {
            return 0.0;
        }
        return data.func_74769_h(NBT_STORED_POWER);
    }

    public double getAEMaxPower(ItemStack wirelessTerminal) {
        return 1600000.0;
    }

    public double getDurabilityForDisplay(ItemStack wirelessTerminal) {
        return 1.0 - this.getAECurrentPower(wirelessTerminal) / 1600000.0;
    }

    public String getEncryptionKey(ItemStack wirelessTerminal) {
        String sourceKey;
        if (wirelessTerminal.func_77942_o() && (sourceKey = wirelessTerminal.func_77978_p().func_74779_i(NBT_AE_SOURCE_KEY)) != null && !sourceKey.isEmpty()) {
            return sourceKey;
        }
        return "";
    }

    public AccessRestriction getPowerFlow(ItemStack wirelessTerminal) {
        return AccessRestriction.READ_WRITE;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        ItemStack unchargedTerm = new ItemStack(item, 1, 0);
        ItemStack chargedTerm = unchargedTerm.func_77946_l();
        this.injectAEPower(chargedTerm, 1600000.0);
        subItems.add(unchargedTerm);
        subItems.add(chargedTerm);
    }

    public String func_77658_a() {
        return ThEStrings.Item_WirelessEssentiaTerminal.getUnlocalized();
    }

    public String func_77667_c(ItemStack itemStack) {
        return ThEStrings.Item_WirelessEssentiaTerminal.getUnlocalized();
    }

    @Override
    public NBTTagCompound getWETerminalTag(ItemStack wirelessTerminal) {
        return this.getOrCreateCompoundTag(wirelessTerminal);
    }

    public double injectAEPower(ItemStack wirelessTerminal, double amount) {
        double storedPower = this.getAECurrentPower(wirelessTerminal);
        double canInjectAmount = Math.min(amount, 1600000.0 - storedPower);
        if (canInjectAmount > 0.0) {
            this.getOrCreateCompoundTag(wirelessTerminal).func_74780_a(NBT_STORED_POWER, storedPower + canInjectAmount);
        }
        return amount - canInjectAmount;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        ThEApi.instance().openWirelessTerminalGui(player, this);
        return itemStack;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("thaumicenergistics:wireless.essentia.terminal");
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public void setEncryptionKey(ItemStack wirelessTerminal, String sourceKey, String name) {
        this.getOrCreateCompoundTag(wirelessTerminal).func_74778_a(NBT_AE_SOURCE_KEY, sourceKey);
    }

    public boolean showDurabilityBar(ItemStack wirelessTerminal) {
        return true;
    }
}

