/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import openeye.Log;
import openeye.logic.Config;
import openeye.logic.CrashId;
import openeye.logic.ModMetaCollector;
import openeye.logic.ModState;
import openeye.logic.ReportBuilders;
import openeye.logic.ReportContext;
import openeye.logic.Storages;
import openeye.logic.ThrowableLogger;
import openeye.net.GenericSender;
import openeye.net.ReportSender;
import openeye.reports.FileSignature;
import openeye.reports.ReportCrash;
import openeye.reports.ReportPing;
import openeye.responses.IResponse;
import openeye.storage.IDataSource;
import openeye.storage.IWorkingStorage;
import openeye.struct.ITypedStruct;
import openeye.struct.TypedCollections;

public class SenderWorker
implements Runnable {
    private static final String URL = "http://openeye.openmods.info/api/v1/data";
    private final Future<ModMetaCollector> collector;
    private final ModState state;
    private final CountDownLatch firstMessageReceived = new CountDownLatch(1);
    private final Set<String> dangerousSignatures = Sets.newHashSet();

    public SenderWorker(Future<ModMetaCollector> collector, ModState state) {
        this.collector = collector;
        this.state = state;
    }

    private static void logException(Throwable throwable, String msg, Object ... args) {
        ThrowableLogger.processThrowable(throwable, "openeye");
        Log.warn(throwable, msg, args);
    }

    private static void store(Object report, String name) {
        try {
            IDataSource<Object> list = Storages.instance().sessionArchive.createNew(name);
            list.store(report);
        }
        catch (Exception e) {
            Log.warn(e, "Failed to store " + name, new Object[0]);
        }
    }

    private static void filterStructs(Collection<? extends ITypedStruct> structs, Set<String> blacklist) {
        Iterator<? extends ITypedStruct> it = structs.iterator();
        while (it.hasNext()) {
            ITypedStruct struct = it.next();
            String type = struct.getType();
            if (!blacklist.contains(type)) continue;
            Log.info("Filtered type %s(%s) from list, since it's on blacklist", type, struct);
            it.remove();
        }
    }

    private TypedCollections.ReportsList executeResponses(ModMetaCollector collector, TypedCollections.ResponseList requests) {
        Preconditions.checkState((!requests.isEmpty() ? 1 : 0) != 0);
        ReportContext context = new ReportContext(collector);
        for (IResponse request : requests) {
            request.execute(context);
        }
        this.dangerousSignatures.addAll(context.dangerousSignatures());
        return context.reports();
    }

    private static Collection<ReportCrash> listPendingCrashes() {
        IWorkingStorage<ReportCrash> pendingCrashes = Storages.instance().pendingCrashes;
        HashMap crashes = Maps.newHashMap();
        for (IDataSource crash : pendingCrashes.listAll()) {
            try {
                ReportCrash prev;
                ReportCrash report = (ReportCrash)crash.retrieve();
                if (report == null || (prev = crashes.put(new CrashId(report.timestamp, report.random), report)) == null) continue;
                Log.warn("Found duplicated crash report %s", crash.getId());
            }
            catch (Exception e) {
                Log.warn(e, "Failed to read crash %s, removing", crash.getId());
                crash.delete();
            }
        }
        return crashes.values();
    }

    private static void removePendingCrashes() {
        IWorkingStorage<ReportCrash> pendingCrashes = Storages.instance().pendingCrashes;
        for (IDataSource crash : pendingCrashes.listAll()) {
            crash.delete();
        }
    }

    protected TypedCollections.ReportsList createInitialReport(ModMetaCollector collector) {
        TypedCollections.ReportsList result = new TypedCollections.ReportsList();
        try {
            this.createAnalyticsReport(collector, result);
            result.addAll(SenderWorker.listPendingCrashes());
        }
        catch (Exception e) {
            SenderWorker.logException(e, "Failed to create initial report", new Object[0]);
        }
        return result;
    }

    protected void createAnalyticsReport(ModMetaCollector collector, TypedCollections.ReportsList result) {
        try {
            if (Config.scanOnly) {
                result.add(ReportBuilders.buildKnownFilesReport(collector));
            } else {
                result.add(ReportBuilders.buildAnalyticsReport(collector, this.state.installedMods));
            }
            if (Config.pingOnInitialReport) {
                result.add(new ReportPing());
            }
        }
        catch (Exception e) {
            SenderWorker.logException(e, "Failed to create analytics report", new Object[0]);
        }
    }

    private void sendReports(ModMetaCollector collector) {
        TypedCollections.ReportsList currentReports = this.createInitialReport(collector);
        try {
            ReportSender sender = new ReportSender(URL);
            while (!currentReports.isEmpty()) {
                TypedCollections.ResponseList response;
                SenderWorker.filterStructs(currentReports, Config.reportsBlacklist);
                SenderWorker.store(currentReports, "request");
                TypedCollections.ResponseList responseList = response = Config.dontSend ? null : (TypedCollections.ResponseList)sender.sendAndReceive(currentReports);
                if (response == null || response.isEmpty()) break;
                SenderWorker.filterStructs(response, Config.responseBlacklist);
                SenderWorker.store(response, "response");
                currentReports.clear();
                try {
                    currentReports = this.executeResponses(collector, response);
                }
                catch (Exception e) {
                    SenderWorker.logException(e, "Failed to execute responses", new Object[0]);
                    break;
                }
                this.firstMessageReceived.countDown();
            }
            SenderWorker.removePendingCrashes();
        }
        catch (GenericSender.FailedToSend e) {
            Log.warn(e, "Failed to send report to %s", URL);
        }
        catch (GenericSender.FailedToReceive e) {
            Log.warn(e, "Failed to receive response from %s", URL);
        }
        catch (Exception e) {
            Log.warn(e, "Failed to send report to %s", URL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ModMetaCollector collector = this.collector.get();
            this.sendReports(collector);
        }
        catch (Throwable t) {
            SenderWorker.logException(t, "Failed to send data to server OpenEye", new Object[0]);
        }
        finally {
            this.firstMessageReceived.countDown();
        }
    }

    public void start() {
        Thread senderThread = new Thread(this);
        senderThread.setName("OpenEye sender thread");
        senderThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                SenderWorker.logException(e, "Uncaught exception in data collector thread, report will not be send", new Object[0]);
                SenderWorker.this.firstMessageReceived.countDown();
            }
        });
        senderThread.start();
    }

    public void waitForFirstMsg() {
        try {
            if (!this.firstMessageReceived.await(30L, TimeUnit.SECONDS)) {
                Log.warn("OpenEye timeouted while waiting for worker thread, data will be incomplete", new Object[0]);
            }
        }
        catch (InterruptedException e) {
            Log.warn("Thread interrupted while waiting for msg", new Object[0]);
        }
    }

    public Collection<FileSignature> listDangerousFiles() {
        ArrayList result = Lists.newArrayList();
        try {
            ModMetaCollector collector = this.collector.get();
            for (String signature : this.dangerousSignatures) {
                FileSignature file = collector.getFileForSignature(signature);
                if (signature == null) continue;
                result.add(file);
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to list dangerous files", new Object[0]);
        }
        return result;
    }
}

