/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.versioning.VersionRange;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;
import openeye.Log;
import openeye.logic.ReportBuilders;
import openeye.reports.FileSignature;
import openeye.reports.ReportCrash;
import openeye.reports.ReportFileContents;
import openeye.reports.ReportFileInfo;

public class ModMetaCollector {
    private final Map<File, FileMeta> files = Maps.newHashMap();
    private final Map<String, FileMeta> signatures = Maps.newHashMap();
    private final long operationDuration;
    private final ASMDataTable table;

    ModMetaCollector(ASMDataTable table, LaunchClassLoader loader, Collection<ITweaker> tweakers) {
        Log.info("Starting mod metadatadata collection", new Object[0]);
        this.table = table;
        long start = System.nanoTime();
        Collection<ModCandidate> allCandidates = ModMetaCollector.stealCandidates(table);
        this.collectFilesFromModCandidates(allCandidates);
        this.collectFilesFromClassTransformers(loader, table);
        this.collectFilesFromTweakers(tweakers, table);
        this.collectFilesFromModContainers(table);
        this.fillSignaturesMap();
        this.operationDuration = System.nanoTime() - start;
        Log.info("Collection of mod metadata finished. Duration: %.4f ms", (double)this.operationDuration / 1000000.0);
    }

    private static FileMeta fromModCandidate(ModCandidate candidate) {
        FileMeta fileMeta = new FileMeta(candidate.getModContainer());
        fileMeta.packages.addAll(candidate.getContainedPackages());
        for (ModContainer c : candidate.getContainedMods()) {
            fileMeta.mods.put(c.getModId(), new ModMeta(c));
        }
        return fileMeta;
    }

    private static String calculateSignature(File file) {
        try {
            return "sha256:" + Files.hash((File)file, (HashFunction)Hashing.sha256()).toString();
        }
        catch (Throwable t) {
            Log.warn(t, "Can't hash file %s", file);
            return null;
        }
    }

    private FileMeta getOrCreateData(File file) {
        FileMeta data = this.files.get(file);
        if (data == null) {
            data = new FileMeta(file);
            this.files.put(file, data);
        }
        return data;
    }

    private void collectFilesFromModCandidates(Collection<ModCandidate> candidates) {
        for (ModCandidate c : candidates) {
            File modContainer = c.getModContainer();
            if (this.files.containsKey(modContainer) || c.isMinecraftJar() || c.getSourceType() != ContainerType.JAR) continue;
            FileMeta meta = ModMetaCollector.fromModCandidate(c);
            this.files.put(modContainer, meta);
        }
    }

    private static String extractPackage(String className) {
        int pkgIdx = className.lastIndexOf(46);
        if (pkgIdx == -1) {
            return null;
        }
        return className.substring(0, pkgIdx);
    }

    private static Set<ModCandidate> getCandidatesForClass(ASMDataTable table, String cls) {
        String packageName = ModMetaCollector.extractPackage(cls);
        if (Strings.isNullOrEmpty((String)packageName)) {
            return null;
        }
        return table.getCandidatesFor(packageName);
    }

    private void visitMeta(ASMDataTable table, String cls, IFileMetaVisitor visitor) {
        Set<ModCandidate> candidates = ModMetaCollector.getCandidatesForClass(table, cls);
        if (candidates != null) {
            for (ModCandidate c : candidates) {
                File container = c.getModContainer();
                if (container.isDirectory()) continue;
                FileMeta fileMeta = this.files.get(container);
                if (fileMeta == null) {
                    fileMeta = ModMetaCollector.fromModCandidate(c);
                    this.files.put(container, fileMeta);
                }
                visitor.visit(fileMeta);
            }
        }
    }

    private void registerClassTransformer(ASMDataTable table, final String cls) {
        this.visitMeta(table, cls, new IFileMetaVisitor(){

            @Override
            public void visit(FileMeta fileMeta) {
                fileMeta.classTransformers.add(cls);
            }
        });
    }

    private static Collection<ModCandidate> stealCandidates(ASMDataTable table) {
        try {
            Multimap packageMap = (Multimap)ReflectionHelper.getPrivateValue(ASMDataTable.class, (Object)table, (String[])new String[]{"packageMap"});
            if (packageMap != null) {
                return packageMap.values();
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Can't get ModCandidate map, data will be missing from report", new Object[0]);
        }
        return ImmutableList.of();
    }

    private void collectFilesFromModContainers(ASMDataTable table) {
        File dummyEntry = new File("minecraft.jar");
        for (ModContainer c : Loader.instance().getModList()) {
            File f = c.getSource();
            if (f == null || f.equals(dummyEntry) || f.isDirectory()) continue;
            FileMeta meta = this.getOrCreateData(f);
            meta.mods.put(c.getModId(), new ModMeta(c));
        }
    }

    private void collectFilesFromTweakers(Collection<ITweaker> tweakers, ASMDataTable table) {
        try {
            Class<?> coreModWrapper = Class.forName("cpw.mods.fml.relauncher.CoreModManager$FMLPluginWrapper");
            Field nameField = coreModWrapper.getField("name");
            nameField.setAccessible(true);
            Field pluginField = coreModWrapper.getField("coreModInstance");
            pluginField.setAccessible(true);
            Field locationField = coreModWrapper.getField("location");
            locationField.setAccessible(true);
            for (ITweaker tweaker : tweakers) {
                try {
                    File location = (File)locationField.get(tweaker);
                    if (location == null || location.isDirectory()) continue;
                    String name = (String)nameField.get(tweaker);
                    IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)pluginField.get(tweaker);
                    FileMeta meta = this.getOrCreateData(location);
                    meta.tweakers.add(new TweakMeta(name, plugin.getClass().getName()));
                }
                catch (Throwable t) {
                    Log.warn(t, "Can't get data for tweaker %s", tweaker);
                }
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Can't get tweaker data", new Object[0]);
        }
    }

    private void collectFilesFromClassTransformers(LaunchClassLoader loader, ASMDataTable table) {
        if (loader != null) {
            List transformers = loader.getTransformers();
            for (IClassTransformer transformer : transformers) {
                this.registerClassTransformer(table, transformer.getClass().getName());
            }
        } else {
            Log.warn("LaunchClassLoader not available", new Object[0]);
        }
    }

    private void fillSignaturesMap() {
        for (FileMeta meta : this.files.values()) {
            this.signatures.put(meta.signature(), meta);
        }
    }

    public List<String> listSignatures() {
        ArrayList result = Lists.newArrayList();
        for (FileMeta meta : this.files.values()) {
            result.add(meta.signature);
        }
        return result;
    }

    public List<ReportCrash.FileState> collectStates() {
        ArrayList result = Lists.newArrayList();
        for (FileMeta meta : this.files.values()) {
            result.add(meta.getStates());
        }
        return result;
    }

    public List<FileSignature> getAllFiles() {
        ArrayList result = Lists.newArrayList();
        for (FileMeta meta : this.files.values()) {
            FileSignature tmp = new FileSignature();
            tmp.signature = meta.signature();
            tmp.filename = meta.container.getName();
            result.add(meta.createFileSignature());
        }
        return result;
    }

    public Set<String> getAllSignatures() {
        HashSet result = Sets.newHashSet();
        for (FileMeta meta : this.files.values()) {
            result.add(meta.signature());
        }
        return result;
    }

    public long getCollectingDuration() {
        return this.operationDuration;
    }

    public ReportFileInfo generateFileReport(String signature) {
        FileMeta meta = this.signatures.get(signature);
        return meta != null ? meta.generateReport() : null;
    }

    public ReportFileContents generateFileContentsReport(String signature) {
        FileMeta meta = this.signatures.get(signature);
        return meta != null ? meta.generateFileContentsReport() : null;
    }

    public Set<String> getModsForSignature(String signature) {
        FileMeta meta = this.signatures.get(signature);
        if (meta != null) {
            return ImmutableSet.copyOf(meta.mods.keySet());
        }
        return ImmutableSet.of();
    }

    public FileSignature getFileForSignature(String signature) {
        FileMeta meta = this.signatures.get(signature);
        return meta != null ? meta.createFileSignature() : null;
    }

    public File getContainerForSignature(String signature) {
        FileMeta meta = this.signatures.get(signature);
        return meta != null ? meta.container : null;
    }

    public ClassSource identifyClassSource(String className) {
        FileMeta meta;
        String packageName = ModMetaCollector.extractPackage(className);
        ClassSource result = new ClassSource();
        if (packageName.startsWith("net.minecraft") || packageName.startsWith("net.minecraftforge") || packageName.startsWith("cpw.mods.fml")) {
            return null;
        }
        try {
            URL sourceUrl;
            File sourceFile;
            Class<?> cls = Class.forName(className);
            CodeSource src = cls.getProtectionDomain().getCodeSource();
            if (src != null && (meta = this.files.get(sourceFile = new File((sourceUrl = src.getLocation()).toURI()))) != null) {
                result.loadedFrom = meta.signature();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        Set candidates = this.table.getCandidatesFor(packageName);
        for (ModCandidate c : candidates) {
            File container = c.getModContainer();
            if (container == null || (meta = this.files.get(container)) == null) continue;
            result.containingClasses.add(meta.signature());
        }
        return result;
    }

    public static class ClassSource {
        public String loadedFrom;
        public final Set<String> containingClasses = Sets.newHashSet();
    }

    private static interface IFileMetaVisitor {
        public void visit(FileMeta var1);
    }

    private static class FileMeta {
        public final Set<String> classTransformers = Sets.newHashSet();
        public final Map<String, ModMeta> mods = Maps.newHashMap();
        public final List<TweakMeta> tweakers = Lists.newArrayList();
        public final Set<String> packages = Sets.newHashSet();
        public final File container;
        private String signature;

        public FileMeta(File container) {
            this.container = container;
        }

        public String signature() {
            if (this.signature == null) {
                this.signature = ModMetaCollector.calculateSignature(this.container);
            }
            return this.signature;
        }

        public Long getSize() {
            try {
                return this.container.length();
            }
            catch (Throwable t) {
                Log.info(t, "Can't get size info for file %s", this.container);
                return null;
            }
        }

        public ReportCrash.FileState getStates() {
            ReportCrash.FileState result = new ReportCrash.FileState();
            result.signature = this.signature();
            ArrayList mods = Lists.newArrayList();
            for (ModMeta meta : this.mods.values()) {
                mods.add(meta.getState());
            }
            result.mods = mods;
            return result;
        }

        public ReportFileInfo generateReport() {
            ReportFileInfo report = new ReportFileInfo();
            report.signature = this.signature();
            report.size = this.getSize();
            ImmutableList.Builder modsBuilder = ImmutableList.builder();
            for (ModMeta m : this.mods.values()) {
                modsBuilder.add((Object)m.toSerializable());
            }
            report.mods = modsBuilder.build();
            ImmutableList.Builder tweaksBuilder = ImmutableList.builder();
            for (TweakMeta t : this.tweakers) {
                tweaksBuilder.add((Object)t.toSerializable());
            }
            report.tweakers = tweaksBuilder.build();
            report.classTransformers = ImmutableList.copyOf(this.classTransformers);
            report.packages = ImmutableList.copyOf(this.packages);
            return report;
        }

        public ReportFileContents generateFileContentsReport() {
            ReportFileContents report = new ReportFileContents();
            report.signature = this.signature();
            ReportBuilders.fillFileContents(this.container, report);
            return report;
        }

        public FileSignature createFileSignature() {
            FileSignature result = new FileSignature();
            result.signature = this.signature();
            result.filename = this.container.getName();
            return result;
        }
    }

    private static class ModMeta {
        private final String modId;
        private final String name;
        private final String version;
        private final ModMetadata metadata;
        private final ModContainer container;

        private ModMeta(ModContainer container) {
            this.container = container;
            this.modId = Strings.nullToEmpty((String)container.getModId());
            this.name = Strings.nullToEmpty((String)container.getName());
            this.version = Strings.nullToEmpty((String)container.getVersion());
            this.metadata = container.getMetadata();
        }

        private static <T> Collection<T> safeCopy(Collection<T> input) {
            if (input == null) {
                return ImmutableList.of();
            }
            return ImmutableList.copyOf(input);
        }

        public ReportFileInfo.SerializableMod toSerializable() {
            ReportFileInfo.SerializableMod result = new ReportFileInfo.SerializableMod();
            result.modId = this.modId;
            result.name = this.name;
            result.version = this.version;
            VersionRange mcVersionRange = this.container.acceptableMinecraftVersionRange();
            if (mcVersionRange != null) {
                result.mcVersion = Strings.nullToEmpty((String)mcVersionRange.toString());
            }
            result.description = Strings.nullToEmpty((String)this.metadata.description);
            result.url = Strings.nullToEmpty((String)this.metadata.url);
            result.updateUrl = Strings.nullToEmpty((String)this.metadata.updateUrl);
            result.credits = Strings.nullToEmpty((String)this.metadata.credits);
            result.parent = Strings.nullToEmpty((String)this.metadata.parent);
            result.authors = ModMeta.safeCopy(this.metadata.authorList);
            result.requiredMods = ModMeta.safeCopy(this.metadata.requiredMods);
            result.dependants = ModMeta.safeCopy(this.metadata.dependants);
            result.dependencies = ModMeta.safeCopy(this.metadata.dependencies);
            return result;
        }

        public ReportCrash.ModState getState() {
            ReportCrash.ModState state = new ReportCrash.ModState();
            state.modId = this.modId;
            state.state = Loader.instance().getModState(this.container).toString();
            return state;
        }
    }

    private static class TweakMeta {
        private final String pluginName;
        private final String className;

        private TweakMeta(String pluginName, String className) {
            this.pluginName = Strings.nullToEmpty((String)pluginName);
            this.className = Strings.nullToEmpty((String)className);
        }

        public ReportFileInfo.SerializableTweak toSerializable() {
            ReportFileInfo.SerializableTweak result = new ReportFileInfo.SerializableTweak();
            result.plugin = this.pluginName;
            result.cls = this.className;
            return result;
        }
    }
}

