/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiSmelter;
import cofh.thermalexpansion.gui.container.machine.ContainerSmelter;
import cofh.thermalexpansion.util.crafting.SmelterManager;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileSmelter
extends TileMachineBase {
    static final int TYPE = BlockMachine.Types.SMELTER.ordinal();
    int outputTrackerPrimary;
    int outputTrackerSecondary;
    public boolean lockPrimary = false;

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileSmelter.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileSmelter.TYPE].numConfig = 8;
        TileMachineBase.defaultSideConfig[TileSmelter.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2, 3}, {4}, {2, 3, 4}, {0}, {1}, {0, 1, 2, 3, 4}};
        TileMachineBase.defaultSideConfig[TileSmelter.TYPE].allowInsertionSide = new boolean[]{false, true, false, false, false, true, true, true};
        TileMachineBase.defaultSideConfig[TileSmelter.TYPE].allowExtractionSide = new boolean[]{false, true, true, true, true, false, false, true};
        TileMachineBase.defaultSideConfig[TileSmelter.TYPE].allowInsertionSlot = new boolean[]{true, true, false, false, false, false};
        TileMachineBase.defaultSideConfig[TileSmelter.TYPE].allowExtractionSlot = new boolean[]{true, true, true, true, true, false};
        TileMachineBase.defaultSideConfig[TileSmelter.TYPE].sideTex = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        TileMachineBase.defaultSideConfig[TileSmelter.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        String string = "Machine.Smelter";
        int n = MathHelper.clampI((int)ThermalExpansion.config.get(string, "BasePower", 40), (int)10, (int)500);
        ThermalExpansion.config.set(string, "BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileSmelter.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(n);
        TileMachineBase.sounds[TileSmelter.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineSmelter");
        GameRegistry.registerTileEntity(TileSmelter.class, (String)"thermalexpansion.Smelter");
    }

    public TileSmelter() {
        this.inventory = new ItemStack[6];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getMaxInputSlot() {
        return 1;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null && this.inventory[1] == null) {
            return false;
        }
        SmelterManager.RecipeSmelter recipeSmelter = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipeSmelter == null || this.energyStorage.getEnergyStored() < recipeSmelter.getEnergy() * this.energyMod / this.processMod) {
            return false;
        }
        if (SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipeSmelter.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipeSmelter.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipeSmelter.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipeSmelter.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a) {
            return false;
        }
        ItemStack itemStack = recipeSmelter.getPrimaryOutput();
        ItemStack itemStack2 = recipeSmelter.getSecondaryOutput();
        if (itemStack2 != null && this.inventory[4] != null) {
            if (!this.inventory[4].func_77969_a(itemStack2)) {
                return false;
            }
            if (this.inventory[4].field_77994_a + itemStack2.field_77994_a > itemStack2.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemStack) && !this.inventory[3].func_77969_a(itemStack)) {
            return false;
        }
        if (!this.inventory[2].func_77969_a(itemStack)) {
            return this.inventory[3].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
        }
        if (!this.inventory[3].func_77969_a(itemStack)) {
            return this.inventory[2].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
        }
        return this.inventory[2].field_77994_a + this.inventory[3].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d() * 2;
    }

    @Override
    protected boolean hasValidInput() {
        SmelterManager.RecipeSmelter recipeSmelter = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipeSmelter == null) {
            return false;
        }
        return !(SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipeSmelter.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipeSmelter.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipeSmelter.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipeSmelter.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]).getEnergy();
    }

    @Override
    protected void processFinish() {
        int n;
        SmelterManager.RecipeSmelter recipeSmelter = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        ItemStack itemStack = recipeSmelter.getPrimaryOutput();
        ItemStack itemStack2 = recipeSmelter.getSecondaryOutput();
        if (this.inventory[2] == null) {
            this.inventory[2] = itemStack;
        } else if (this.inventory[2].func_77969_a(itemStack)) {
            if (this.inventory[2].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d()) {
                this.inventory[2].field_77994_a += itemStack.field_77994_a;
            } else {
                n = itemStack.func_77976_d() - this.inventory[2].field_77994_a;
                this.inventory[2].field_77994_a += n;
                if (this.inventory[3] == null) {
                    this.inventory[3] = itemStack;
                    this.inventory[3].field_77994_a = itemStack.field_77994_a - n;
                } else {
                    this.inventory[3].field_77994_a += itemStack.field_77994_a - n;
                }
            }
        } else if (this.inventory[3] == null) {
            this.inventory[3] = itemStack;
        } else {
            this.inventory[3].field_77994_a += itemStack.field_77994_a;
        }
        if (itemStack2 != null && ((n = recipeSmelter.getSecondaryOutputChance()) >= 100 || ((TileEntity)this).field_145850_b.field_73012_v.nextInt(this.secondaryChance) < n)) {
            if (this.inventory[4] == null) {
                this.inventory[4] = itemStack2;
            } else {
                this.inventory[4].field_77994_a += itemStack2.field_77994_a;
            }
            if (this.secondaryChance < n && this.inventory[4].field_77994_a + itemStack2.field_77994_a <= itemStack2.func_77976_d() && ((TileEntity)this).field_145850_b.field_73012_v.nextInt(this.secondaryChance) < n - this.secondaryChance) {
                this.inventory[4].field_77994_a += itemStack2.field_77994_a;
            }
        }
        if (SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
            this.inventory[1].field_77994_a -= recipeSmelter.getPrimaryInput().field_77994_a;
            this.inventory[0].field_77994_a -= recipeSmelter.getSecondaryInput().field_77994_a;
        } else {
            this.inventory[0].field_77994_a -= recipeSmelter.getPrimaryInput().field_77994_a;
            this.inventory[1].field_77994_a -= recipeSmelter.getSecondaryInput().field_77994_a;
        }
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[1].field_77994_a <= 0) {
            this.inventory[1] = null;
        }
    }

    @Override
    protected void transferProducts() {
        int n;
        int n2;
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.inventory[2] != null || this.inventory[3] != null) {
            for (n2 = this.outputTrackerPrimary + 1; n2 <= this.outputTrackerPrimary + 6; ++n2) {
                n = n2 % 6;
                if (this.sideCache[n] != 2 && this.sideCache[n] != 4) continue;
                if (this.transferItem(2, TileMachineBase.AUTO_EJECT[this.level] >> 1, n)) {
                    if (!this.transferItem(3, TileMachineBase.AUTO_EJECT[this.level] >> 1, n)) {
                        this.transferItem(2, TileMachineBase.AUTO_EJECT[this.level] >> 1, n);
                    }
                    this.outputTrackerPrimary = n;
                    break;
                }
                if (!this.transferItem(3, TileMachineBase.AUTO_EJECT[this.level], n)) continue;
                this.outputTrackerPrimary = n;
                break;
            }
        }
        if (this.inventory[4] == null) {
            return;
        }
        for (n2 = this.outputTrackerSecondary + 1; n2 <= this.outputTrackerSecondary + 6; ++n2) {
            n = n2 % 6;
            if (this.sideCache[n] != 3 && this.sideCache[n] != 4 || !this.transferItem(4, TileMachineBase.AUTO_EJECT[this.level], n)) continue;
            this.outputTrackerSecondary = n;
            break;
        }
    }

    @Override
    public boolean isItemValid(ItemStack itemStack, int n, int n2) {
        if (this.lockPrimary) {
            if (n == 0) {
                return SmelterManager.isItemFlux(itemStack);
            }
            if (n == 1) {
                return !SmelterManager.isItemFlux(itemStack) && SmelterManager.isItemValid(itemStack);
            }
        }
        return n <= 1 ? SmelterManager.isItemValid(itemStack) : true;
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!super.readPortableTagInternal(entityPlayer, nBTTagCompound)) {
            return false;
        }
        this.lockPrimary = nBTTagCompound.func_74767_n("SlotLock");
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!super.writePortableTagInternal(entityPlayer, nBTTagCompound)) {
            return false;
        }
        nBTTagCompound.func_74757_a("SlotLock", this.lockPrimary);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiSmelter(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerSmelter(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTrackerPrimary = nBTTagCompound.func_74762_e("Tracker1");
        this.outputTrackerSecondary = nBTTagCompound.func_74762_e("Tracker2");
        this.lockPrimary = nBTTagCompound.func_74767_n("SlotLock");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker1", this.outputTrackerPrimary);
        nBTTagCompound.func_74768_a("Tracker2", this.outputTrackerSecondary);
        nBTTagCompound.func_74757_a("SlotLock", this.lockPrimary);
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addBool(this.lockPrimary);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addBool(this.lockPrimary);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.lockPrimary = packetCoFHBase.getBool();
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.lockPrimary = packetCoFHBase.getBool();
        this.func_70296_d();
        this.callNeighborTileChange();
    }

    public void setMode(boolean bl) {
        boolean bl2 = this.lockPrimary;
        this.lockPrimary = bl;
        this.sendModePacket();
        this.lockPrimary = bl2;
    }
}

