/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.controller;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyStorage;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ServerHelper;
import io.endertech.config.GeneralConfig;
import io.endertech.multiblock.IMultiblockPart;
import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockValidationException;
import io.endertech.multiblock.block.BlockTankController;
import io.endertech.multiblock.rectangular.RectangularMultiblockControllerBase;
import io.endertech.multiblock.tile.TileTankController;
import io.endertech.multiblock.tile.TileTankEnergyInput;
import io.endertech.multiblock.tile.TileTankPart;
import io.endertech.multiblock.tile.TileTankValve;
import io.endertech.network.ITilePacketHandler;
import io.endertech.network.PacketETBase;
import io.endertech.util.BlockCoord;
import io.endertech.util.IChargeableFromSlot;
import io.endertech.util.IOutlineDrawer;
import io.endertech.util.RGBA;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.LogHelper;
import io.endertech.util.helper.NBTHelper;
import io.endertech.util.helper.RenderHelper;
import io.endertech.util.helper.StringHelper;
import io.endertech.util.helper.WorldHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ControllerTank
extends RectangularMultiblockControllerBase
implements IOutlineDrawer,
ITilePacketHandler,
IEnergyStorage,
IChargeableFromSlot,
IInventory {
    public static final int MAX_ENERGY_STORAGE = 10000000;
    private static final String TANK_NAME = "MainTank";
    public FluidTank tank;
    public FluidTank lastTank;
    public boolean renderedOnce = false;
    public int renderAddition = 0;
    public ItemStack[] inventory;
    protected boolean active = false;
    private Set<TileTankController> attachedControllers = new HashSet<TileTankController>();
    private Set<TileTankValve> attachedValves = new HashSet<TileTankValve>();
    private Set<TileTankEnergyInput> attachedEnergyInputs = new HashSet<TileTankEnergyInput>();
    private int storedEnergy = 0;
    private int random_number = 0;
    private int ticksSinceUpdate = 0;

    public ControllerTank(World world) {
        super(world);
        this.tank = new FluidTank(1000 * GeneralConfig.tankStorageMultiplier);
        this.lastTank = new FluidTank(1000 * GeneralConfig.tankStorageMultiplier);
        this.inventory = new ItemStack[1];
    }

    public int getRandomNumber() {
        return this.random_number;
    }

    public void setRandomNumber(int newRandomNumber) {
        this.random_number = newRandomNumber;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public void setStoredEnergy(int energyStored) {
        this.storedEnergy = energyStored;
    }

    @Override
    public void onAttachedPartWithMultiblockNBT(IMultiblockPart part, NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public void onAttachedPartWithMultiblockPacket(IMultiblockPart part, PacketETBase packetETBase) {
        this.handleTilePacket(packetETBase, true);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        TileTankPart tankPart;
        if (newPart instanceof TileTankController && BlockTankController.isController((tankPart = (TileTankPart)newPart).func_145832_p())) {
            this.attachedControllers.add((TileTankController)tankPart);
        }
        if (newPart instanceof TileTankValve) {
            this.attachedValves.add((TileTankValve)newPart);
        }
        if (newPart instanceof TileTankEnergyInput) {
            this.attachedEnergyInputs.add((TileTankEnergyInput)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        TileTankPart tankPart;
        if (oldPart instanceof TileTankController && BlockTankController.isController((tankPart = (TileTankPart)oldPart).func_145832_p())) {
            this.attachedControllers.remove(tankPart);
        }
        if (oldPart instanceof TileTankValve) {
            this.attachedValves.remove((TileTankValve)oldPart);
        }
        if (oldPart instanceof TileTankEnergyInput) {
            this.attachedEnergyInputs.remove((TileTankEnergyInput)oldPart);
        }
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.attachedControllers.size() != 1) {
            throw new MultiblockValidationException("You must have 1 controller in the tank structure (currently " + this.attachedControllers.size() + ")");
        }
        if (this.attachedValves.size() < 1) {
            throw new MultiblockValidationException("You must have at least 1 valve in the tank structure (currently " + this.attachedValves.size() + ")");
        }
        if (this.attachedEnergyInputs.size() < 1) {
            throw new MultiblockValidationException("You must have at least 1 energy input in the tank structure (currently " + this.attachedEnergyInputs.size() + ")");
        }
        super.isMachineWhole();
    }

    @Override
    protected void onMachineAssembled() {
        if (this.getRandomNumber() == 0) {
            this.setRandomNumber(new Random().nextInt(1000000));
        }
        BlockCoord minCoord = this.getMinimumCoord();
        BlockCoord maxCoord = this.getMaximumCoord();
        BlockCoord dimensionCoord = new BlockCoord(maxCoord.x - minCoord.x - 1, maxCoord.y - minCoord.y - 1, maxCoord.z - minCoord.z - 1);
        int interiorSize = dimensionCoord.x * dimensionCoord.y * dimensionCoord.z;
        int tankCapacity = interiorSize * 1000 * GeneralConfig.tankStorageMultiplier;
        this.tank.setCapacity(tankCapacity);
        if (this.lastTank != null) {
            this.lastTank.setCapacity(tankCapacity);
        }
        this.setActive(true);
        this.sendUpdatePacketToClosePlayers();
    }

    @Override
    protected void onMachineRestored() {
    }

    @Override
    protected void onMachinePaused() {
    }

    public void popInventoryContentsOut(World world, int x, int y, int z) {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack == null) continue;
            WorldHelper.spawnItemInWorldWithRandomness(itemStack, world, 0.3f, x, y, z, 2);
        }
        this.inventory = new ItemStack[this.inventory.length];
    }

    @Override
    protected void onMachineDisassembled() {
        TileTankController tankController;
        if (ServerHelper.isServerWorld(this.worldObj) && this.attachedControllers.size() > 0 && (tankController = this.attachedControllers.iterator().next()) != null) {
            ForgeDirection out = tankController.getFirstOutwardsDir();
            if (out == null) {
                out = tankController.getOrientation();
            }
            this.popInventoryContentsOut(tankController.func_145831_w(), tankController.field_145851_c + out.offsetX, tankController.field_145848_d + out.offsetY, tankController.field_145849_e + out.offsetZ);
        }
        this.setActive(false);
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return this.getMinimumXSize() * this.getMinimumZSize() * this.getMinimumYSize() - 7;
    }

    @Override
    protected int getMaximumXSize() {
        return 8;
    }

    @Override
    protected int getMinimumXSize() {
        return 3;
    }

    @Override
    protected int getMaximumZSize() {
        return 8;
    }

    @Override
    protected int getMinimumZSize() {
        return 3;
    }

    @Override
    protected int getMaximumYSize() {
        return 10;
    }

    @Override
    protected int getMinimumYSize() {
        return 3;
    }

    @Override
    protected void onAssimilate(MultiblockControllerBase assimilated) {
        LogHelper.debug("Assimilation occurred: ", new Object[0]);
        LogHelper.debug("Me: " + this.toString(), new Object[0]);
        LogHelper.debug("Assimilated: " + assimilated.toString(), new Object[0]);
        if (assimilated instanceof ControllerTank) {
            ControllerTank assimilatedController = (ControllerTank)assimilated;
            boolean thisHasContents = this.tank.getFluidAmount() > 0 || this.storedEnergy > 0;
            boolean assimilatedHasContents = assimilatedController.tank.getFluidAmount() > 0 || assimilatedController.storedEnergy > 0;
            ControllerTank candidate = null;
            if (!thisHasContents && assimilatedHasContents) {
                candidate = assimilatedController;
            } else if (thisHasContents && !assimilatedHasContents) {
                candidate = this;
            } else if (!thisHasContents && !assimilatedHasContents) {
                candidate = assimilatedController;
            }
            if (candidate == null) {
                candidate = this.tank.getFluidAmount() >= assimilatedController.tank.getFluidAmount() ? this : assimilatedController;
                if (ServerHelper.isServerWorld(this.worldObj)) {
                    LogHelper.error(LocalisationHelper.localiseString("error.multiblock.tank.destructive_assimilation", new Object[0]), new Object[0]);
                    LogHelper.error(this.toString(), new Object[0]);
                    LogHelper.error(candidate.toString(), new Object[0]);
                }
            }
            this.setRandomNumber(candidate.getRandomNumber());
            this.tank = new FluidTank(candidate.tank.getFluid(), candidate.tank.getCapacity());
            this.storedEnergy = candidate.storedEnergy;
        }
        LogHelper.debug("Result: " + this.toString(), new Object[0]);
    }

    @Override
    protected void onAssimilated(MultiblockControllerBase assimilator) {
        this.attachedControllers.clear();
        this.attachedEnergyInputs.clear();
        this.attachedValves.clear();
        this.storedEnergy = 0;
        this.tank = new FluidTank(null, 0);
    }

    @Override
    protected boolean updateServer() {
        if (this.ticksSinceUpdate > 20) {
            this.ticksSinceUpdate = 0;
            return true;
        }
        this.chargeFromGUISlot();
        ++this.ticksSinceUpdate;
        return false;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74757_a("tankActive", this.isActive());
        data.func_74768_a("randomNumber", this.random_number);
        data.func_74768_a("storedEnergy", this.storedEnergy);
        NBTTagCompound tankNBT = new NBTTagCompound();
        this.tank.writeToNBT(tankNBT);
        data.func_74782_a(TANK_NAME, (NBTBase)tankNBT);
        NBTHelper.writeInventoryToNBT(data, this.inventory);
    }

    public String toString() {
        return "R: " + this.getRandomNumber() + " A: " + this.active + " F: " + this.getFluidStringOrNone(this.tank.getFluid()) + " " + this.tank.getFluidAmount() + "/" + this.tank.getCapacity() + " Cs: " + this.attachedControllers.size() + " Vs: " + this.attachedValves.size() + " E: " + this.storedEnergy + "/" + 10000000;
    }

    private String getFluidStringOrNone(FluidStack fluid) {
        if (fluid == null) {
            return "none";
        }
        return this.getFluidStringOrNone(fluid.getFluid());
    }

    private String getFluidStringOrNone(Fluid fluid) {
        if (fluid == null) {
            return "none";
        }
        return fluid.getLocalizedName();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("tankActive")) {
            this.setActive(data.func_74767_n("tankActive"));
        }
        if (data.func_74764_b("randomNumber")) {
            this.setRandomNumber(data.func_74762_e("randomNumber"));
        }
        if (data.func_74764_b(TANK_NAME)) {
            this.tank.readFromNBT(data.func_74775_l(TANK_NAME));
        }
        if (data.func_74764_b("storedEnergy")) {
            this.storedEnergy = data.func_74762_e("storedEnergy");
        }
        if (data.func_74764_b("Inventory")) {
            this.inventory = NBTHelper.readInventoryFromNBT(data, 1);
        }
    }

    @Override
    public PacketETBase getPacket(PacketETBase packetSaveDelegateBase) {
        packetSaveDelegateBase.addInt(this.random_number);
        packetSaveDelegateBase.addFluidStack(this.tank.getFluid());
        packetSaveDelegateBase.addInt(this.tank.getCapacity());
        packetSaveDelegateBase.addInt(this.storedEnergy);
        packetSaveDelegateBase.addInventory(this.inventory);
        return packetSaveDelegateBase;
    }

    @Override
    public void handleTilePacket(PacketETBase packetETBase, boolean isServer) {
        int random_number = packetETBase.getInt();
        FluidStack fluidStack = packetETBase.getFluidStack();
        int capacity = packetETBase.getInt();
        int storedEnergy = packetETBase.getInt();
        ItemStack[] inventory = packetETBase.getInventory(1);
        if (!isServer) {
            this.random_number = random_number;
            this.tank.setCapacity(capacity);
            this.lastTank = new FluidTank(this.tank.getFluid(), this.tank.getCapacity());
            this.renderAddition = 0;
            this.tank.setFluid(fluidStack);
            this.storedEnergy = storedEnergy;
            this.inventory = inventory;
        }
    }

    @Override
    public String getName() {
        return "Ender Tank";
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (active == this.active) {
            return;
        }
        this.active = active;
        for (IMultiblockPart part : this.connectedParts) {
            if (this.active) {
                part.onMachineActivated();
                continue;
            }
            part.onMachineDeactivated();
        }
    }

    @Override
    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        throw new MultiblockValidationException("Interior must be air");
    }

    @Override
    public List<String> getWailaBody() {
        ArrayList<String> additions = new ArrayList<String>();
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
            additions.add(StringHelper.getFluidName(this.tank.getFluid()));
            additions.add(this.tank.getFluidAmount() + " / " + this.tank.getCapacity() + " mB");
        } else {
            additions.add("Empty");
        }
        additions.add(StringHelper.getEnergyString(this.storedEnergy) + " / " + StringHelper.getEnergyString(10000000) + " RF");
        return additions;
    }

    @Override
    public boolean shouldConsume(MultiblockControllerBase otherController) {
        boolean shouldConsume = super.shouldConsume(otherController);
        if (shouldConsume) {
            ControllerTank otherTank = (ControllerTank)otherController;
            if (!(this.getStoredEnergy() <= 0 && this.tank.getFluidAmount() <= 0 || otherTank.getStoredEnergy() <= 0 && otherTank.tank.getFluidAmount() <= 0 || !ServerHelper.isServerWorld(this.worldObj))) {
                LogHelper.warn(LocalisationHelper.localiseString("warning.multiblock.tank.destructive_assimilation_check", new Object[0]), new Object[0]);
            }
        }
        return shouldConsume;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int energy = this.getStoredEnergy();
        int energyExtracted = Math.min(energy, Math.min(10000000, maxExtract));
        if (!simulate) {
            this.setStoredEnergy(energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public boolean drawOutline(DrawBlockHighlightEvent event) {
        BlockCoord target = new BlockCoord(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        World world = event.player.field_70170_p;
        if (GeneralConfig.debugRender) {
            Set<IMultiblockPart> connectedParts = this.getConnectedParts();
            if (connectedParts.isEmpty()) {
                RenderHelper.renderBlockOutline(event.context, event.player, target, RGBA.White.setAlpha(0.6f), 2.0f, event.partialTicks);
            }
            RGBA colour = RGBA.Blue.setAlpha(0.6f);
            if (this.isAssembled()) {
                colour = RGBA.Green.setAlpha(0.6f);
            }
            for (IMultiblockPart part : connectedParts) {
                BlockCoord partCoord = part.getWorldLocation();
                Block blockPart = world.func_147439_a(partCoord.x, partCoord.y, partCoord.z);
                if (blockPart instanceof BlockTankController) {
                    if (BlockTankController.isController(world.func_72805_g(partCoord.x, partCoord.y, partCoord.z))) {
                        RenderHelper.renderBlockOutline(event.context, event.player, partCoord, RGBA.White.setAlpha(0.6f), 10.0f, event.partialTicks);
                    }
                } else {
                    RenderHelper.renderBlockOutline(event.context, event.player, partCoord, colour, 2.0f, event.partialTicks);
                }
                if (!part.isMultiblockSaveDelegate()) continue;
                RenderHelper.renderBlockOutline(event.context, event.player, partCoord, RGBA.Red, 10.0f, event.partialTicks);
            }
        } else {
            BlockCoord minCoord = this.getMinimumCoord();
            BlockCoord maxCoord = this.getMaximumCoord();
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)minCoord.x, (double)minCoord.y, (double)minCoord.z, (double)(maxCoord.x + 1), (double)(maxCoord.y + 1), (double)(maxCoord.z + 1));
            RenderHelper.renderAABBOutline(event.context, event.player, aabb, RGBA.Black, 1.0f, event.partialTicks);
        }
        return true;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energy = this.getStoredEnergy();
        int energyReceived = Math.min(10000000 - energy, Math.min(10000, maxReceive));
        if (!simulate) {
            this.setStoredEnergy(energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxEnergyStored() {
        return 10000000;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] == null) {
            return null;
        }
        if (this.inventory[slot].field_77994_a <= amount) {
            amount = this.inventory[slot].field_77994_a;
        }
        ItemStack itemStack = this.inventory[slot].func_77979_a(amount);
        if (this.inventory[slot].field_77994_a <= 0) {
            this.inventory[slot] = null;
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] == null) {
            return null;
        }
        ItemStack itemStack = this.inventory[slot];
        this.inventory[slot] = null;
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        int inventoryStackLimit = this.func_70297_j_();
        if (itemStack != null && itemStack.field_77994_a > inventoryStackLimit) {
            itemStack.field_77994_a = inventoryStackLimit;
        }
    }

    public String func_145825_b() {
        return this.getName();
    }

    public boolean func_145818_k_() {
        return !this.getName().isEmpty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return true;
    }

    @Override
    public int getChargeSlot() {
        return this.inventory.length - 1;
    }

    @Override
    public boolean hasChargeSlot() {
        return true;
    }

    @Override
    public void chargeFromGUISlot() {
        int chargeSlot = this.getChargeSlot();
        ItemStack chargeItemStack = this.inventory[chargeSlot];
        if (!this.hasChargeSlot() || !EnergyHelper.isEnergyContainerItem(chargeItemStack)) {
            return;
        }
        int chargeAmount = Math.min(10000, 10000000 - this.getEnergyStored());
        IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)chargeItemStack.func_77973_b();
        if (energyContainerItem == null) {
            return;
        }
        int extractedAmount = energyContainerItem.extractEnergy(chargeItemStack, chargeAmount, false);
        this.receiveEnergy(extractedAmount, false);
        if (chargeItemStack.field_77994_a <= 0) {
            this.inventory[chargeSlot] = null;
        }
    }
}

