/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.compat;

import com.cricketcraft.chisel.Chisel;
import com.cricketcraft.chisel.api.IMC;
import com.cricketcraft.chisel.api.carving.ICarvingRegistry;
import com.cricketcraft.chisel.carving.Carving;
import cpw.mods.fml.common.event.FMLInterModComms;
import net.minecraft.block.Block;

public class IMCHandler {
    public static final IMCHandler INSTANCE = new IMCHandler();
    private int order = 1000;

    private IMCHandler() {
    }

    public void handleMessage(FMLInterModComms.IMCMessage message) {
        for (IMC imc : IMC.values()) {
            if (!imc.key.equals(message.key)) continue;
            this.handle(message, imc, message.getStringValue());
        }
    }

    private void handle(FMLInterModComms.IMCMessage message, IMC type, String value) {
        ICarvingRegistry reg = Carving.chisel;
        String[] data = value.split("\\|");
        try {
            switch (type) {
                case ADD_VARIATION: 
                case REMOVE_VARIATION: {
                    Block block = (Block)Block.field_149771_c.func_82594_a(data[1]);
                    short meta = Short.parseShort(data[2]);
                    if (type == IMC.ADD_VARIATION) {
                        reg.addVariation(data[0], block, meta, this.order++);
                        break;
                    }
                    reg.removeVariation(block, meta, data[0]);
                    break;
                }
                case REGISTER_GROUP_ORE: {
                    reg.registerOre(data[0], data[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid IMC constant! How...what...?");
                }
            }
        }
        catch (Exception e) {
            Chisel.logger.error("Could not handle data {} for IMC type {}. This was sent from mod {}.\n!! This is a bug in that mod !!\nSwallowing error and continuing...", new Object[]{value, type.name(), message.getSender()});
            e.printStackTrace();
        }
    }
}

