/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.relauncher.ReflectionHelper;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.WorldServer;
import openmods.Log;

public class NetUtils {
    private static Field trackingPlayers;
    public static final ChannelFutureListener LOGGING_LISTENER;

    public static NetworkDispatcher getPlayerDispatcher(EntityPlayerMP player) {
        NetworkDispatcher dispatcher = (NetworkDispatcher)player.field_71135_a.field_147371_a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get();
        return dispatcher;
    }

    public static Set<EntityPlayerMP> getPlayersWatchingEntity(WorldServer server, int entityId) {
        IntHashMap trackers;
        EntityTracker tracker = server.func_73039_n();
        if (trackingPlayers == null) {
            trackingPlayers = ReflectionHelper.findField(EntityTracker.class, (String[])new String[]{"trackedEntityIDs", "field_72794_c"});
        }
        try {
            trackers = (IntHashMap)trackingPlayers.get(tracker);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        EntityTrackerEntry entry = (EntityTrackerEntry)trackers.func_76041_a(entityId);
        if (entry == null) {
            return ImmutableSet.of();
        }
        Set trackingPlayers = entry.field_73134_o;
        return ImmutableSet.copyOf((Collection)trackingPlayers);
    }

    public static Set<EntityPlayerMP> getPlayersWatchingChunk(WorldServer world, int chunkX, int chunkZ) {
        PlayerManager manager = world.func_73040_p();
        HashSet playerList = Sets.newHashSet();
        for (Object o : world.field_73010_i) {
            EntityPlayerMP player = (EntityPlayerMP)o;
            if (!manager.func_72694_a(player, chunkX, chunkZ)) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public static Set<EntityPlayerMP> getPlayersWatchingBlock(WorldServer world, int blockX, int blockZ) {
        return NetUtils.getPlayersWatchingChunk(world, blockX >> 4, blockZ >> 4);
    }

    static {
        LOGGING_LISTENER = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Throwable cause = future.cause();
                    Log.severe(cause, "Crash in pipeline handler", new Object[0]);
                }
            }
        };
    }
}

