/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public class InventoryRange {
    public IInventory inv;
    public int side;
    public ISidedInventory sidedInv;
    public int[] slots;

    public InventoryRange(IInventory inv, int side) {
        this.inv = inv;
        this.side = side;
        if (inv instanceof ISidedInventory) {
            this.sidedInv = (ISidedInventory)inv;
            this.slots = this.sidedInv.func_94128_d(side);
        } else {
            this.slots = new int[inv.func_70302_i_()];
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = i;
            }
        }
    }

    public InventoryRange(IInventory inv) {
        this(inv, 0);
    }

    public InventoryRange(IInventory inv, int fslot, int size) {
        this.inv = inv;
        this.slots = new int[size];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = fslot + i;
        }
    }

    public InventoryRange(IInventory inv, InventoryRange access) {
        this.inv = inv;
        this.slots = access.slots;
        this.side = access.side;
        if (inv instanceof ISidedInventory) {
            this.sidedInv = (ISidedInventory)inv;
        }
    }

    public boolean canInsertItem(int slot, ItemStack item) {
        return this.sidedInv == null ? this.inv.func_94041_b(slot, item) : this.sidedInv.func_102007_a(slot, item, this.side);
    }

    public boolean canExtractItem(int slot, ItemStack item) {
        return this.sidedInv == null ? this.inv.func_94041_b(slot, item) : this.sidedInv.func_102008_b(slot, item, this.side);
    }

    public int lastSlot() {
        int last = 0;
        for (int slot : this.slots) {
            if (slot <= last) continue;
            last = slot;
        }
        return last;
    }
}

