/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import java.util.List;
import java.util.Random;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shield.ShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import mcjty.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AbstractShieldBlock
extends Block
implements ITileEntityProvider {
    private IIcon icon;
    private IIcon[] icons = new IIcon[4];
    public static final int META_ITEMS = 1;
    public static final int META_PASSIVE = 2;
    public static final int META_HOSTILE = 4;
    public static final int META_PLAYERS = 8;

    public AbstractShieldBlock() {
        super(Material.field_151592_s);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149647_a(RFTools.tabRfTools);
    }

    public IIcon[] getIcons() {
        return this.icons;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return false;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public int func_149656_h() {
        return 2;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        ShieldBlockTileEntity shieldBlockTileEntity = (ShieldBlockTileEntity)world.func_147438_o(x, y, z);
        int cdData = shieldBlockTileEntity.getCollisionData();
        if (cdData == 0) {
            return;
        }
        if ((cdData & 4) != 0 && entity instanceof IMob) {
            if (this.checkEntityCD(world, x, y, z, "hostile")) {
                super.func_149743_a(world, x, y, z, mask, list, entity);
            }
            return;
        }
        if ((cdData & 2) != 0 && entity instanceof IAnimals && !(entity instanceof IMob)) {
            if (this.checkEntityCD(world, x, y, z, "animal")) {
                super.func_149743_a(world, x, y, z, mask, list, entity);
            }
            return;
        }
        if ((cdData & 8) != 0 && entity instanceof EntityPlayer && this.checkPlayerCD(world, x, y, z, (EntityPlayer)entity)) {
            super.func_149743_a(world, x, y, z, mask, list, entity);
        }
        if ((cdData & 1) != 0 && !(entity instanceof EntityLivingBase)) {
            if (this.checkEntityCD(world, x, y, z, "item")) {
                super.func_149743_a(world, x, y, z, mask, list, entity);
            }
            return;
        }
    }

    private boolean checkEntityCD(World world, int x, int y, int z, String filterName) {
        ShieldTEBase shieldTileEntity;
        ShieldBlockTileEntity shieldBlockTileEntity = (ShieldBlockTileEntity)world.func_147438_o(x, y, z);
        Coordinate shieldBlock = shieldBlockTileEntity.getShieldBlock();
        if (shieldBlock != null && (shieldTileEntity = (ShieldTEBase)world.func_147438_o(shieldBlock.getX(), shieldBlock.getY(), shieldBlock.getZ())) != null) {
            List<ShieldFilter> filters = shieldTileEntity.getFilters();
            for (ShieldFilter filter : filters) {
                if ("default".equals(filter.getFilterName())) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!filterName.equals(filter.getFilterName())) continue;
                return (filter.getAction() & 1) != 0;
            }
        }
        return false;
    }

    private boolean checkPlayerCD(World world, int x, int y, int z, EntityPlayer entity) {
        ShieldTEBase shieldTileEntity;
        ShieldBlockTileEntity shieldBlockTileEntity = (ShieldBlockTileEntity)world.func_147438_o(x, y, z);
        Coordinate shieldBlock = shieldBlockTileEntity.getShieldBlock();
        if (shieldBlock != null && (shieldTileEntity = (ShieldTEBase)world.func_147438_o(shieldBlock.getX(), shieldBlock.getY(), shieldBlock.getZ())) != null) {
            List<ShieldFilter> filters = shieldTileEntity.getFilters();
            for (ShieldFilter filter : filters) {
                if ("default".equals(filter.getFilterName())) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!"player".equals(filter.getFilterName())) continue;
                PlayerFilter playerFilter = (PlayerFilter)filter;
                String name = playerFilter.getName();
                if (name == null || name.isEmpty()) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!name.equals(entity.getDisplayName())) continue;
                return (filter.getAction() & 1) != 0;
            }
        }
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        ShieldBlockTileEntity shieldBlockTileEntity;
        int cdData;
        if (!(entity instanceof EntityLivingBase) && ((cdData = (shieldBlockTileEntity = (ShieldBlockTileEntity)world.func_147438_o(x, y, z)).getCollisionData()) & 1) == 0) {
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u - 1.0, entity.field_70161_v);
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("rftools:shieldtexture");
        this.icons[0] = iconRegister.func_94245_a("rftools:shield/shield0");
        this.icons[1] = iconRegister.func_94245_a("rftools:shield/shield1");
        this.icons[2] = iconRegister.func_94245_a("rftools:shield/shield2");
        this.icons[3] = iconRegister.func_94245_a("rftools:shield/shield3");
    }

    protected boolean blockShouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return super.func_149646_a(world, x, y, z, side);
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        int thisx = x - ForgeDirection.values()[side].offsetX;
        int thisy = y - ForgeDirection.values()[side].offsetY;
        int thisz = z - ForgeDirection.values()[side].offsetZ;
        ShieldBlockTileEntity shieldBlockTileEntity = (ShieldBlockTileEntity)world.func_147438_o(thisx, thisy, thisz);
        if (shieldBlockTileEntity == null) {
            return super.func_149646_a(world, x, y, z, side);
        }
        Block block = shieldBlockTileEntity.getBlock();
        if (block == null) {
            return super.func_149646_a(world, x, y, z, side);
        }
        return block.func_149646_a(world, x, y, z, side);
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.icon;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icon;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new ShieldBlockTileEntity();
    }
}

