/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.DefaultSelectionEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.BlockRender;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import mcjty.rftools.blocks.crafter.CrafterContainer;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.blocks.crafter.PacketCrafter;
import mcjty.rftools.network.Argument;
import mcjty.rftools.network.PacketHandler;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiCrafter
extends GenericGuiContainer<CrafterBaseTE> {
    public static final int CRAFTER_WIDTH = 256;
    public static final int CRAFTER_HEIGHT = 224;
    private EnergyBar energyBar;
    private WidgetList recipeList;
    private ChoiceLabel keepItem;
    private ChoiceLabel internalRecipe;
    private Button applyButton;
    private ImageChoiceLabel redstoneMode;
    private ImageChoiceLabel speedMode;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/crafter.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiCrafter(CrafterBaseTE crafterBlockTileEntity, CrafterContainer container) {
        super(crafterBlockTileEntity, container);
        CrafterBaseTE.setCurrentRF(crafterBlockTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((CrafterBaseTE)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint(new PositionalLayout.PositionalHint(12, 141, 8, 76))).setShowText(false);
        CrafterBaseTE cfr_ignored_0 = (CrafterBaseTE)this.tileEntity;
        this.energyBar.setValue(CrafterBaseTE.getCurrentRF());
        this.initKeepMode();
        this.initInternalRecipe();
        Slider listSlider = this.initRecipeList();
        this.applyButton = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Apply")).setTooltips(new String[]{"Press to apply the", "recipe to the crafter"})).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiCrafter.this.applyRecipe();
            }
        }).setEnabled(false)).setLayoutHint(new PositionalLayout.PositionalHint(212, 65, 34, 16));
        this.initRedstoneMode();
        this.initSpeedMode();
        Object toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout(new PositionalLayout()).addChild(this.energyBar)).addChild(this.keepItem)).addChild(this.internalRecipe)).addChild(this.recipeList)).addChild(listSlider)).addChild(this.applyButton)).addChild(this.redstoneMode)).addChild(this.speedMode);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.selectRecipe();
        this.sendChangeToServer(-1, null, null, false, false);
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((CrafterBaseTE)this.tileEntity).requestRfFromServer();
    }

    private Slider initRecipeList() {
        this.recipeList = (WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setFilledRectThickness(1)).addSelectionEvent(new DefaultSelectionEvent(){

            @Override
            public void select(Widget parent, int index) {
                GuiCrafter.this.selectRecipe();
            }
        }).setLayoutHint(new PositionalLayout.PositionalHint(10, 7, 125, 80));
        this.populateList();
        return (Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollable(this.recipeList).setLayoutHint(new PositionalLayout.PositionalHint(137, 7, 11, 80));
    }

    private void initInternalRecipe() {
        this.internalRecipe = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices("Ext", "Int").setTooltips(new String[]{"'Int' will put result of", "crafting operation in", "inventory instead of", "output buffer"})).addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiCrafter.this.updateRecipe();
            }
        }).setEnabled(false)).setLayoutHint(new PositionalLayout.PositionalHint(150, 24, 38, 14));
    }

    private void initKeepMode() {
        this.keepItem = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices("All", "Keep").setTooltips(new String[]{"'Keep' will keep one", "item in every inventory", "slot"})).addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiCrafter.this.updateRecipe();
            }
        }).setEnabled(false)).setLayoutHint(new PositionalLayout.PositionalHint(150, 7, 38, 14));
    }

    private void initSpeedMode() {
        this.speedMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiCrafter.this.changeSpeedMode();
            }
        }).addChoice("Slow", "Speed mode:\nSlow", iconGuiElements, 48, 0).addChoice("Fast", "Speed mode:\nFast", iconGuiElements, 64, 0);
        this.speedMode.setLayoutHint(new PositionalLayout.PositionalHint(49, 186, 16, 16));
        this.speedMode.setCurrentChoice(((CrafterBaseTE)this.tileEntity).getSpeedMode());
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiCrafter.this.changeRedstoneMode();
            }
        }).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint(new PositionalLayout.PositionalHint(31, 186, 16, 16));
        this.redstoneMode.setCurrentChoice(((CrafterBaseTE)this.tileEntity).getRedstoneMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((CrafterBaseTE)this.tileEntity).setRedstoneMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoice()]);
        this.sendChangeToServer();
    }

    private void changeSpeedMode() {
        ((CrafterBaseTE)this.tileEntity).setSpeedMode(this.speedMode.getCurrentChoice());
        this.sendChangeToServer();
    }

    private void sendChangeToServer() {
        this.sendServerCommand("mode", new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoice()].getDescription()), new Argument("speed", this.speedMode.getCurrentChoice()));
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < ((CrafterBaseTE)this.tileEntity).getSupportedRecipes(); ++i) {
            CraftingRecipe recipe = ((CrafterBaseTE)this.tileEntity).getRecipe(i);
            ItemStack stack = recipe.getResult();
            this.addRecipeLine(stack);
        }
    }

    private void addRecipeLine(Object craftingResult) {
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(new BlockRender(this.field_146297_k, (Gui)this).setRenderItem(craftingResult))).addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setDynamic(true)).setText(BlockInfo.getReadableName(craftingResult, 0)));
        this.recipeList.addChild(panel);
    }

    private void selectRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            for (int i = 0; i < 10; ++i) {
                this.field_147002_h.func_75139_a(i).func_75215_d(null);
            }
            this.keepItem.setChoice("All");
            this.internalRecipe.setChoice("Ext");
            this.keepItem.setEnabled(false);
            this.internalRecipe.setEnabled(false);
            this.applyButton.setEnabled(false);
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        InventoryCrafting inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            this.field_147002_h.func_75139_a(i).func_75215_d(inv.func_70301_a(i));
        }
        this.field_147002_h.func_75139_a(9).func_75215_d(craftingRecipe.getResult());
        this.keepItem.setChoice(craftingRecipe.isKeepOne() ? "Keep" : "All");
        this.internalRecipe.setChoice(craftingRecipe.isCraftInternal() ? "Int" : "Ext");
        this.keepItem.setEnabled(true);
        this.internalRecipe.setEnabled(true);
        this.applyButton.setEnabled(true);
    }

    private void testRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.field_147002_h.func_75139_a(i).func_75211_c());
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.field_146297_k.field_71441_e, inv);
        ItemStack newResult = recipe == null ? null : recipe.func_77572_b(inv);
        this.field_147002_h.func_75139_a(9).func_75215_d(newResult);
    }

    private void applyRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        InventoryCrafting inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            ItemStack newStack;
            ItemStack oldStack = inv.func_70301_a(i);
            if (this.itemStacksEqual(oldStack, newStack = this.field_147002_h.func_75139_a(i).func_75211_c())) continue;
            inv.func_70299_a(i, newStack);
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.field_146297_k.field_71441_e, inv);
        ItemStack newResult = recipe == null ? null : recipe.func_77572_b(inv);
        ItemStack oldResult = this.field_147002_h.func_75139_a(9).func_75211_c();
        if (!this.itemStacksEqual(oldResult, newResult)) {
            this.field_147002_h.func_75139_a(9).func_75215_d(newResult);
        }
        craftingRecipe.setResult(newResult);
        this.updateRecipe();
        this.populateList();
    }

    private void updateRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        boolean keepOne = "Keep".equals(this.keepItem.getCurrentChoice());
        boolean craftInternal = "Int".equals(this.internalRecipe.getCurrentChoice());
        craftingRecipe.setKeepOne(keepOne);
        craftingRecipe.setCraftInternal(craftInternal);
        this.sendChangeToServer(selected, craftingRecipe.getInventory(), craftingRecipe.getResult(), keepOne, craftInternal);
    }

    private boolean itemStacksEqual(ItemStack matches, ItemStack oldStack) {
        if (matches == null) {
            return oldStack == null;
        }
        return oldStack != null && matches.func_77969_a(oldStack);
    }

    private void sendChangeToServer(int index, InventoryCrafting inv, ItemStack result, boolean keepOne, boolean craftInternal) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketCrafter(((CrafterBaseTE)this.tileEntity).field_145851_c, ((CrafterBaseTE)this.tileEntity).field_145848_d, ((CrafterBaseTE)this.tileEntity).field_145849_e, index, inv, result, keepOne, craftInternal));
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        this.testRecipe();
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.window.draw();
        CrafterBaseTE cfr_ignored_0 = (CrafterBaseTE)this.tileEntity;
        int currentRF = CrafterBaseTE.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((CrafterBaseTE)this.tileEntity).requestRfFromServer();
    }
}

