/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumicenergistics.util.IInventoryUpdateReceiver;

public class PrivateInventory
implements IInventory {
    public ItemStack[] slots;
    public String customName;
    private int stackLimit;
    private IInventoryUpdateReceiver receiver = null;

    public PrivateInventory(String customName, int size, int stackLimit) {
        this.slots = new ItemStack[size];
        this.customName = customName;
        this.stackLimit = stackLimit;
    }

    public PrivateInventory(String customName, int size, int stackLimit, IInventoryUpdateReceiver receiver) {
        this(customName, size, stackLimit);
        this.receiver = receiver;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        ItemStack slotStack = this.slots[slotId];
        ItemStack resultStack = null;
        if (slotStack == null) {
            return null;
        }
        int decAmount = Math.min(amount, slotStack.field_77994_a);
        int remAmount = slotStack.field_77994_a - decAmount;
        if (remAmount > 0) {
            this.slots[slotId].field_77994_a = remAmount;
        } else {
            this.slots[slotId] = null;
        }
        if (decAmount > 0) {
            resultStack = slotStack.func_77946_l();
            resultStack.field_77994_a = decAmount;
        }
        this.func_70296_d();
        return resultStack;
    }

    public String func_145825_b() {
        return this.customName;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.slots[index];
    }

    public ItemStack func_70304_b(int slotId) {
        return this.slots[slotId];
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int incrStackSize(int slotId, int amount) {
        int stackLimit;
        ItemStack slotStack = this.slots[slotId];
        int added = 0;
        if (slotStack != null && (added = Math.min(amount, (stackLimit = Math.min(this.func_70297_j_(), slotStack.func_77976_d())) - slotStack.field_77994_a)) > 0) {
            this.slots[slotId].field_77994_a += added;
            this.func_70296_d();
        }
        return added;
    }

    public boolean func_94041_b(int slotId, ItemStack itemStack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public final void loadFromNBT(NBTTagCompound data, String tagName) {
        if (data == null) {
            return;
        }
        if (!data.func_74764_b(tagName)) {
            return;
        }
        NBTTagList invList = data.func_150295_c(tagName, 10);
        for (int index = 0; index < invList.func_74745_c(); ++index) {
            NBTTagCompound nbtCompound = invList.func_150305_b(index);
            int slotIndex = nbtCompound.func_74771_c("Slot") & 0xFF;
            if (slotIndex < 0 || slotIndex >= this.slots.length) continue;
            this.slots[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)nbtCompound);
        }
    }

    public void func_70296_d() {
        if (this.receiver != null) {
            this.receiver.onInventoryChanged(this);
        }
    }

    public void func_70295_k_() {
    }

    public final void saveToNBT(NBTTagCompound data, String tagName) {
        if (data == null) {
            return;
        }
        NBTTagList invList = new NBTTagList();
        for (int slotIndex = 0; slotIndex < this.slots.length; ++slotIndex) {
            if (this.slots[slotIndex] == null) continue;
            NBTTagCompound nbtCompound = new NBTTagCompound();
            nbtCompound.func_74774_a("Slot", (byte)slotIndex);
            this.slots[slotIndex].func_77955_b(nbtCompound);
            invList.func_74742_a((NBTBase)nbtCompound);
        }
        data.func_74782_a(tagName, (NBTBase)invList);
    }

    public void func_70299_a(int slotId, ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.slots[slotId] = itemStack;
        this.func_70296_d();
    }

    public void setReceiver(IInventoryUpdateReceiver receiver) {
        this.receiver = receiver;
    }
}

