/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerPartEssentiaLevelEmitter;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.gui.GuiEssentiaLevelEmitter;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.network.IAspectSlotPart;
import thaumicenergistics.network.packet.client.PacketClientAspectSlot;
import thaumicenergistics.network.packet.client.PacketClientEssentiaEmitter;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.registries.EnumCache;
import thaumicenergistics.texture.BlockTextureManager;
import thaumicenergistics.util.EffectiveSide;

public class AEPartEssentiaLevelEmitter
extends AbstractAEPartBase
implements IAspectSlotPart,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    private static final double IDLE_POWER_DRAIN = 0.3;
    private static final String ASPECT_FILTER_NBT_KEY = "aspect";
    private static final String REDSTONE_MODE_NBT_KEY = "mode";
    private static final String WANTED_AMOUNT_NBT_KEY = "wantedAmount";
    private static final String IS_EMITTING_NBT_KEY = "emitting";
    private Aspect filterAspect;
    private RedstoneMode redstoneMode = RedstoneMode.HIGH_SIGNAL;
    private long wantedAmount;
    private long currentAmount;
    private boolean isEmitting = false;

    public AEPartEssentiaLevelEmitter() {
        super(AEPartsEnum.EssentiaLevelEmitter);
    }

    private void checkEmitting() {
        boolean emitting = false;
        if (!this.isActive()) {
            return;
        }
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                emitting = this.currentAmount >= this.wantedAmount;
                break;
            }
            case LOW_SIGNAL: {
                emitting = this.currentAmount <= this.wantedAmount;
                break;
            }
        }
        if (emitting != this.isEmitting) {
            this.isEmitting = emitting;
            this.markAndNotify();
        }
    }

    private void checkRegistration() {
        IStorageGrid storageGrid = this.gridBlock.getStorageGrid();
        if (storageGrid == null) {
            return;
        }
        if (this.filterAspect == null) {
            storageGrid.getFluidInventory().removeListener((IMEMonitorHandlerReceiver)this);
        } else {
            storageGrid.getFluidInventory().addListener((IMEMonitorHandlerReceiver)this, (Object)this.gridBlock.getGrid());
        }
    }

    private void markAndNotify() {
        this.host.markForSave();
        this.host.markForUpdate();
        this.tile.func_145831_w().func_147459_d(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, Blocks.field_150350_a);
        this.tile.func_145831_w().func_147459_d(this.tile.field_145851_c + this.cableSide.offsetX, this.tile.field_145848_d + this.cableSide.offsetX, this.tile.field_145849_e + this.cableSide.offsetX, Blocks.field_150350_a);
    }

    private void onMonitorUpdate(IMEMonitor<IAEFluidStack> monitor) {
        GaseousEssentia aspectGas;
        if (this.filterAspect == null) {
            this.setCurrentAmount(0L);
        }
        if ((aspectGas = GaseousEssentia.getGasFromAspect(this.filterAspect)) == null) {
            this.setCurrentAmount(0L);
        }
        IAEFluidStack asGasStack = EssentiaConversionHelper.instance.createAEFluidStackInFluidUnits(aspectGas, 1L);
        IAEFluidStack fluidStack = (IAEFluidStack)monitor.getStorageList().findPrecise((IAEStack)asGasStack);
        if (fluidStack == null) {
            this.setCurrentAmount(0L);
        } else {
            this.setCurrentAmount(EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(fluidStack.getStackSize()));
        }
    }

    private void setCurrentAmount(long amount) {
        if (amount != this.currentAmount) {
            this.currentAmount = amount;
            this.host.markForSave();
            this.checkEmitting();
        }
    }

    @Override
    protected boolean canPlayerOpenGui(int playerID) {
        return this.doesPlayerHaveSecurityClearance(playerID, SecurityPermissions.BUILD);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 8;
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged channelEvent) {
        this.onListUpdate();
        this.checkRegistration();
        this.checkEmitting();
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[1];
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiEssentiaLevelEmitter(this, player);
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.3;
    }

    @Override
    public int getLightLevel() {
        return this.isEmitting ? 7 : 0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPartEssentiaLevelEmitter(this, player);
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isEmitting ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isProvidingStrongPower();
    }

    public boolean isValid(Object token) {
        IGrid grid = this.gridBlock.getGrid();
        if (grid != null) {
            return grid == token;
        }
        return false;
    }

    public void onClientAdjustWantedAmount(int adjustmentAmount, EntityPlayer player) {
        this.onClientSetWantedAmount(this.wantedAmount + (long)adjustmentAmount, player);
    }

    public void onClientSetWantedAmount(long wantedAmount, EntityPlayer player) {
        this.wantedAmount = wantedAmount;
        if (this.wantedAmount < 0L) {
            this.wantedAmount = 0L;
        } else if (this.wantedAmount > 9999999999L) {
            this.wantedAmount = 9999999999L;
        }
        this.host.markForSave();
        new PacketClientEssentiaEmitter().createWantedAmountUpdate(this.wantedAmount, player).sendPacketToPlayer();
        this.checkEmitting();
    }

    public void onClientToggleRedstoneMode(EntityPlayer player) {
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                this.redstoneMode = RedstoneMode.LOW_SIGNAL;
                break;
            }
            case LOW_SIGNAL: {
                this.redstoneMode = RedstoneMode.HIGH_SIGNAL;
                break;
            }
        }
        this.checkEmitting();
        new PacketClientEssentiaEmitter().createRedstoneModeUpdate(this.redstoneMode, player).sendPacketToPlayer();
    }

    public void onClientUpdateRequest(EntityPlayer player) {
        new PacketClientEssentiaEmitter().createFullUpdate(this.redstoneMode, this.wantedAmount, player).sendPacketToPlayer();
        ArrayList<Aspect> filter = new ArrayList<Aspect>();
        filter.add(this.filterAspect);
        new PacketClientAspectSlot().createFilterListUpdate(filter, player).sendPacketToPlayer();
    }

    public void onListUpdate() {
        if (this.filterAspect == null) {
            return;
        }
        IStorageGrid sGrid = this.gridBlock.getStorageGrid();
        if (sGrid != null) {
            this.onMonitorUpdate((IMEMonitor<IAEFluidStack>)sGrid.getFluidInventory());
        }
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> changes, BaseActionSource source) {
        if (this.filterAspect == null) {
            return;
        }
        if (changes == null) {
            return;
        }
        for (IAEFluidStack change : changes) {
            if (!(change.getFluid() instanceof GaseousEssentia)) continue;
            this.onMonitorUpdate((IMEMonitor<IAEFluidStack>)((IMEMonitor)monitor));
            break;
        }
    }

    @MENetworkEventSubscribe
    public void powerChanged(MENetworkPowerStatusChange powerEvent) {
        this.onListUpdate();
        this.checkRegistration();
        this.checkEmitting();
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
        if (this.isEmitting) {
            double particleX = (double)((float)this.cableSide.offsetX * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double particleY = (double)((float)this.cableSide.offsetY * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double particleZ = (double)((float)this.cableSide.offsetZ * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.func_72869_a("reddust", 0.5 + (double)x + particleX, 0.5 + (double)y + particleY, 0.5 + (double)z + particleZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.filterAspect = (Aspect)Aspect.aspects.get(data.func_74779_i(ASPECT_FILTER_NBT_KEY));
        this.redstoneMode = EnumCache.AE_REDSTONE_MODES[data.func_74762_e(REDSTONE_MODE_NBT_KEY)];
        this.wantedAmount = data.func_74763_f(WANTED_AMOUNT_NBT_KEY);
        this.isEmitting = data.func_74767_n(IS_EMITTING_NBT_KEY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean readFromStream(ByteBuf stream) throws IOException {
        super.readFromStream(stream);
        this.isEmitting = stream.readBoolean();
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[0]);
        helper.setBounds(7.0f, 1.0f, 14.0f, 9.0f, 7.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[1]);
        helper.setBounds(7.0f, 7.0f, 14.0f, 9.0f, 9.0f, 16.0f);
        helper.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[0]);
        helper.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 14.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.isEmitting) {
            helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[1]);
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        } else {
            helper.setTexture(BlockTextureManager.ESSENTIA_LEVEL_EMITTER.getTextures()[2]);
        }
        helper.setBounds(7.0f, 7.0f, 14.0f, 9.0f, 9.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
    }

    @Override
    public void setAspect(int index, Aspect aspect, EntityPlayer player) {
        this.filterAspect = aspect;
        if (EffectiveSide.isClientSide()) {
            return;
        }
        this.checkRegistration();
        this.onListUpdate();
        ArrayList<Aspect> filter = new ArrayList<Aspect>();
        filter.add(aspect);
        new PacketClientAspectSlot().createFilterListUpdate(filter, player).sendPacketToPlayer();
    }

    public boolean setFilteredAspectFromItemstack(EntityPlayer player, ItemStack itemStack) {
        Aspect itemAspect = EssentiaItemContainerHelper.instance.getAspectInContainer(itemStack);
        if (itemAspect == null) {
            return false;
        }
        this.setAspect(0, itemAspect, player);
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.filterAspect != null) {
            data.func_74778_a(ASPECT_FILTER_NBT_KEY, this.filterAspect.getTag());
        } else {
            data.func_74778_a(ASPECT_FILTER_NBT_KEY, "");
        }
        data.func_74768_a(REDSTONE_MODE_NBT_KEY, this.redstoneMode.ordinal());
        data.func_74772_a(WANTED_AMOUNT_NBT_KEY, this.wantedAmount);
        data.func_74757_a(IS_EMITTING_NBT_KEY, this.isEmitting);
    }

    @Override
    public void writeToStream(ByteBuf stream) throws IOException {
        super.writeToStream(stream);
        stream.writeBoolean(this.isEmitting);
    }
}

