/*
 * Decompiled with CFR 0.152.
 */
package opisapache.math3.geometry.euclidean.oned;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import opisapache.math3.geometry.euclidean.oned.Euclidean1D;
import opisapache.math3.geometry.euclidean.oned.Interval;
import opisapache.math3.geometry.euclidean.oned.OrientedPoint;
import opisapache.math3.geometry.euclidean.oned.SubOrientedPoint;
import opisapache.math3.geometry.euclidean.oned.Vector1D;
import opisapache.math3.geometry.partitioning.AbstractRegion;
import opisapache.math3.geometry.partitioning.BSPTree;
import opisapache.math3.geometry.partitioning.Region;
import opisapache.math3.geometry.partitioning.SubHyperplane;
import opisapache.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalsSet
extends AbstractRegion<Euclidean1D, Euclidean1D> {
    public IntervalsSet() {
    }

    public IntervalsSet(double lower, double upper) {
        super(IntervalsSet.buildTree(lower, upper));
    }

    public IntervalsSet(BSPTree<Euclidean1D> tree) {
        super(tree);
    }

    public IntervalsSet(Collection<SubHyperplane<Euclidean1D>> boundary) {
        super(boundary);
    }

    private static BSPTree<Euclidean1D> buildTree(double lower, double upper) {
        if (Double.isInfinite(lower) && lower < 0.0) {
            if (Double.isInfinite(upper) && upper > 0.0) {
                return new BSPTree<Euclidean1D>(Boolean.TRUE);
            }
            SubOrientedPoint upperCut = new OrientedPoint(new Vector1D(upper), true).wholeHyperplane();
            return new BSPTree<Euclidean1D>(upperCut, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null);
        }
        SubOrientedPoint lowerCut = new OrientedPoint(new Vector1D(lower), false).wholeHyperplane();
        if (Double.isInfinite(upper) && upper > 0.0) {
            return new BSPTree<Euclidean1D>(lowerCut, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null);
        }
        SubOrientedPoint upperCut = new OrientedPoint(new Vector1D(upper), true).wholeHyperplane();
        return new BSPTree<Euclidean1D>(lowerCut, new BSPTree(Boolean.FALSE), new BSPTree<Euclidean1D>(upperCut, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), null);
    }

    public IntervalsSet buildNew(BSPTree<Euclidean1D> tree) {
        return new IntervalsSet(tree);
    }

    @Override
    protected void computeGeometricalProperties() {
        if (this.getTree(false).getCut() == null) {
            this.setBarycenter(Vector1D.NaN);
            this.setSize((Boolean)this.getTree(false).getAttribute() != false ? Double.POSITIVE_INFINITY : 0.0);
        } else {
            double size = 0.0;
            double sum = 0.0;
            for (Interval interval : this.asList()) {
                size += interval.getSize();
                sum += interval.getSize() * interval.getBarycenter();
            }
            this.setSize(size);
            if (Double.isInfinite(size)) {
                this.setBarycenter(Vector1D.NaN);
            } else if (size >= Precision.SAFE_MIN) {
                this.setBarycenter(new Vector1D(sum / size));
            } else {
                this.setBarycenter(((OrientedPoint)this.getTree(false).getCut().getHyperplane()).getLocation());
            }
        }
    }

    public double getInf() {
        BSPTree node = this.getTree(false);
        double inf = Double.POSITIVE_INFINITY;
        while (node.getCut() != null) {
            OrientedPoint op = (OrientedPoint)node.getCut().getHyperplane();
            inf = op.getLocation().getX();
            node = op.isDirect() ? node.getMinus() : node.getPlus();
        }
        return (Boolean)node.getAttribute() != false ? Double.NEGATIVE_INFINITY : inf;
    }

    public double getSup() {
        BSPTree node = this.getTree(false);
        double sup = Double.NEGATIVE_INFINITY;
        while (node.getCut() != null) {
            OrientedPoint op = (OrientedPoint)node.getCut().getHyperplane();
            sup = op.getLocation().getX();
            node = op.isDirect() ? node.getPlus() : node.getMinus();
        }
        return (Boolean)node.getAttribute() != false ? Double.POSITIVE_INFINITY : sup;
    }

    public List<Interval> asList() {
        ArrayList<Interval> list = new ArrayList<Interval>();
        this.recurseList(this.getTree(false), list, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        return list;
    }

    private void recurseList(BSPTree<Euclidean1D> node, List<Interval> list, double lower, double upper) {
        if (node.getCut() == null) {
            if (((Boolean)node.getAttribute()).booleanValue()) {
                list.add(new Interval(lower, upper));
            }
        } else {
            OrientedPoint op = (OrientedPoint)node.getCut().getHyperplane();
            Vector1D loc = op.getLocation();
            double x = loc.getX();
            BSPTree<Euclidean1D> low = op.isDirect() ? node.getMinus() : node.getPlus();
            BSPTree<Euclidean1D> high = op.isDirect() ? node.getPlus() : node.getMinus();
            this.recurseList(low, list, lower, x);
            if (this.checkPoint(low, loc) == Region.Location.INSIDE && this.checkPoint(high, loc) == Region.Location.INSIDE) {
                x = list.remove(list.size() - 1).getInf();
            }
            this.recurseList(high, list, x, upper);
        }
    }
}

