/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.map;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import mapwriter.Mw;
import mapwriter.Render;
import mapwriter.api.IMwChunkOverlay;
import mapwriter.api.IMwDataProvider;
import mapwriter.api.MwAPI;
import mapwriter.map.MapView;
import mapwriter.map.MapViewRequest;
import mapwriter.map.mapmode.MapMode;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MapRenderer {
    private Mw mw;
    private MapMode mapMode;
    private MapView mapView;
    public Point2D.Double playerArrowScreenPos = new Point2D.Double(0.0, 0.0);
    private ResourceLocation backgroundTexture = new ResourceLocation("mapwriter", "textures/map/background.png");
    private ResourceLocation roundMapTexture = new ResourceLocation("mapwriter", "textures/map/border_round.png");
    private ResourceLocation squareMapTexture = new ResourceLocation("mapwriter", "textures/map/border_square.png");
    private ResourceLocation playerArrowTexture = new ResourceLocation("mapwriter", "textures/map/arrow_player.png");
    private ResourceLocation northArrowTexture = new ResourceLocation("mapwriter", "textures/map/arrow_north.png");

    public MapRenderer(Mw mw, MapMode mapMode, MapView mapView) {
        this.mw = mw;
        this.mapMode = mapMode;
        this.mapView = mapView;
    }

    private void drawMap() {
        double h;
        double w;
        double v;
        double u;
        int regionZoomLevel = Math.max(0, this.mapView.getZoomLevel());
        double tSize = this.mw.textureSize;
        double zoomScale = 1 << regionZoomLevel;
        if (!this.mapMode.circular && this.mw.mapPixelSnapEnabled && this.mapView.getZoomLevel() >= 0) {
            u = (double)Math.round(this.mapView.getMinX() / zoomScale) / tSize % 1.0;
            v = (double)Math.round(this.mapView.getMinZ() / zoomScale) / tSize % 1.0;
            w = (double)Math.round(this.mapView.getWidth() / zoomScale) / tSize;
            h = (double)Math.round(this.mapView.getHeight() / zoomScale) / tSize;
        } else {
            double tSizeInBlocks = tSize * zoomScale;
            u = this.mapView.getMinX() / tSizeInBlocks % 1.0;
            v = this.mapView.getMinZ() / tSizeInBlocks % 1.0;
            w = this.mapView.getWidth() / tSizeInBlocks;
            h = this.mapView.getHeight() / tSizeInBlocks;
        }
        GL11.glPushMatrix();
        if (this.mapMode.rotate) {
            GL11.glRotated((double)this.mw.mapRotationDegrees, (double)0.0, (double)0.0, (double)1.0);
        }
        if (this.mapMode.circular) {
            Render.setCircularStencil(0.0, 0.0, (double)this.mapMode.h / 2.0);
        }
        if (this.mapView.getUndergroundMode() && regionZoomLevel == 0) {
            this.mw.undergroundMapTexture.requestView(this.mapView);
            Render.setColourWithAlphaPercent(0, this.mapMode.alphaPercent);
            Render.drawRect(this.mapMode.x, this.mapMode.y, this.mapMode.w, this.mapMode.h);
            Render.setColourWithAlphaPercent(0xFFFFFF, this.mapMode.alphaPercent);
            this.mw.undergroundMapTexture.bind();
            Render.drawTexturedRect(this.mapMode.x, this.mapMode.y, this.mapMode.w, this.mapMode.h, u, v, u + w, v + h);
        } else {
            MapViewRequest req = new MapViewRequest(this.mapView);
            this.mw.mapTexture.requestView(req, this.mw.executor, this.mw.regionManager);
            if (this.mw.backgroundTextureMode > 0) {
                double bu1 = 0.0;
                double bu2 = 1.0;
                double bv1 = 0.0;
                double bv2 = 1.0;
                if (this.mw.backgroundTextureMode == 2) {
                    double bSize = tSize / 256.0;
                    bu1 = u * bSize;
                    bu2 = (u + w) * bSize;
                    bv1 = v * bSize;
                    bv2 = (v + h) * bSize;
                }
                this.mw.mc.field_71446_o.func_110577_a(this.backgroundTexture);
                Render.setColourWithAlphaPercent(0xFFFFFF, this.mapMode.alphaPercent);
                Render.drawTexturedRect(this.mapMode.x, this.mapMode.y, this.mapMode.w, this.mapMode.h, bu1, bv1, bu2, bv2);
            } else {
                Render.setColourWithAlphaPercent(0, this.mapMode.alphaPercent);
                Render.drawRect(this.mapMode.x, this.mapMode.y, this.mapMode.w, this.mapMode.h);
            }
            if (this.mw.mapTexture.isLoaded(req)) {
                this.mw.mapTexture.bind();
                Render.setColourWithAlphaPercent(0xFFFFFF, this.mapMode.alphaPercent);
                Render.drawTexturedRect(this.mapMode.x, this.mapMode.y, this.mapMode.w, this.mapMode.h, u, v, u + w, v + h);
            }
        }
        IMwDataProvider provider = this.drawOverlay();
        if (provider != null) {
            GL11.glPushMatrix();
            provider.onDraw(this.mapView, this.mapMode);
            GL11.glPopMatrix();
        }
        if (this.mapMode.circular) {
            Render.disableStencil();
        }
        GL11.glPopMatrix();
    }

    private void drawBorder() {
        if (this.mapMode.circular) {
            this.mw.mc.field_71446_o.func_110577_a(this.roundMapTexture);
        } else {
            this.mw.mc.field_71446_o.func_110577_a(this.squareMapTexture);
        }
        Render.setColour(-1);
        Render.drawTexturedRect((double)this.mapMode.x / 0.75, (double)this.mapMode.y / 0.75, (double)this.mapMode.w / 0.75, (double)this.mapMode.h / 0.75, 0.0, 0.0, 1.0, 1.0);
    }

    private void drawPlayerArrow() {
        GL11.glPushMatrix();
        double scale = this.mapView.getDimensionScaling(this.mw.playerDimension);
        Point2D.Double p = this.mapMode.getClampedScreenXY(this.mapView, this.mw.playerX * scale, this.mw.playerZ * scale);
        this.playerArrowScreenPos.setLocation(p.x + (double)this.mapMode.xTranslation, p.y + (double)this.mapMode.yTranslation);
        GL11.glTranslated((double)p.x, (double)p.y, (double)0.0);
        if (!this.mapMode.rotate) {
            GL11.glRotated((double)(-this.mw.mapRotationDegrees), (double)0.0, (double)0.0, (double)1.0);
        }
        double arrowSize = this.mapMode.playerArrowSize;
        Render.setColour(-1);
        this.mw.mc.field_71446_o.func_110577_a(this.playerArrowTexture);
        Render.drawTexturedRect(-arrowSize, -arrowSize, arrowSize * 2.0, arrowSize * 2.0, 0.0, 0.0, 1.0, 1.0);
        GL11.glPopMatrix();
    }

    private void drawIcons() {
        GL11.glPushMatrix();
        if (this.mapMode.rotate) {
            GL11.glRotated((double)this.mw.mapRotationDegrees, (double)0.0, (double)0.0, (double)1.0);
        }
        this.mw.markerManager.drawMarkers(this.mapMode, this.mapView);
        if (this.mw.playerTrail.enabled) {
            this.mw.playerTrail.draw(this.mapMode, this.mapView);
        }
        if (this.mapMode.rotate) {
            double y = (double)this.mapMode.h / 2.0;
            double arrowSize = this.mapMode.playerArrowSize;
            Render.setColour(-1);
            this.mw.mc.field_71446_o.func_110577_a(this.northArrowTexture);
            Render.drawTexturedRect(-arrowSize, -y - arrowSize * 2.0, arrowSize * 2.0, arrowSize * 2.0, 0.0, 0.0, 1.0, 1.0);
        }
        GL11.glPopMatrix();
        this.drawPlayerArrow();
    }

    private void drawCoords() {
        if (this.mapMode.coordsEnabled) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.mapMode.textX, (float)this.mapMode.textY, (float)0.0f);
            if (this.mw.coordsMode != 2) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            }
            int offset = 0;
            if (this.mw.coordsMode > 0) {
                Render.drawCentredString(0, 0, this.mapMode.textColour, "%d, %d, %d", this.mw.playerXInt, this.mw.playerYInt, this.mw.playerZInt);
                offset += 12;
            }
            if (this.mw.undergroundMode) {
                Render.drawCentredString(0, offset, this.mapMode.textColour, "underground mode", new Object[0]);
            }
            GL11.glPopMatrix();
        }
    }

    private IMwDataProvider drawOverlay() {
        ArrayList<IMwChunkOverlay> overlays;
        IMwDataProvider provider = MwAPI.getCurrentDataProvider();
        if (provider != null && (overlays = provider.getChunksOverlay(this.mapView.getDimension(), this.mapView.getX(), this.mapView.getZ(), this.mapView.getMinX(), this.mapView.getMinZ(), this.mapView.getMaxX(), this.mapView.getMaxZ())) != null) {
            for (IMwChunkOverlay overlay : overlays) {
                MapRenderer.paintChunk(this.mapMode, this.mapView, overlay);
            }
        }
        return provider;
    }

    public void draw() {
        this.mapMode.setScreenRes();
        this.mapView.setMapWH(this.mapMode);
        this.mapView.setTextureSize(this.mw.textureSize);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslated((double)this.mapMode.xTranslation, (double)this.mapMode.yTranslation, (double)-2000.0);
        this.drawMap();
        if (this.mapMode.borderMode > 0) {
            this.drawBorder();
        }
        this.drawIcons();
        this.drawCoords();
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    private static void paintChunk(MapMode mapMode, MapView mapView, IMwChunkOverlay overlay) {
        int chunkX = overlay.getCoordinates().x;
        int chunkZ = overlay.getCoordinates().y;
        float filling = overlay.getFilling();
        Point2D.Double topCorner = mapMode.blockXZtoScreenXY(mapView, chunkX << 4, chunkZ << 4);
        Point2D.Double botCorner = mapMode.blockXZtoScreenXY(mapView, chunkX + 1 << 4, chunkZ + 1 << 4);
        topCorner.x = Math.max((double)mapMode.x, topCorner.x);
        topCorner.x = Math.min((double)(mapMode.x + mapMode.w), topCorner.x);
        topCorner.y = Math.max((double)mapMode.y, topCorner.y);
        topCorner.y = Math.min((double)(mapMode.y + mapMode.h), topCorner.y);
        botCorner.x = Math.max((double)mapMode.x, botCorner.x);
        botCorner.x = Math.min((double)(mapMode.x + mapMode.w), botCorner.x);
        botCorner.y = Math.max((double)mapMode.y, botCorner.y);
        botCorner.y = Math.min((double)(mapMode.y + mapMode.h), botCorner.y);
        double sizeX = (botCorner.x - topCorner.x) * (double)filling;
        double sizeY = (botCorner.y - topCorner.y) * (double)filling;
        double offsetX = (botCorner.x - topCorner.x - sizeX) / 2.0;
        double offsetY = (botCorner.y - topCorner.y - sizeY) / 2.0;
        if (overlay.hasBorder()) {
            Render.setColour(overlay.getBorderColor());
            Render.drawRectBorder(topCorner.x + 1.0, topCorner.y + 1.0, botCorner.x - topCorner.x - 1.0, botCorner.y - topCorner.y - 1.0, overlay.getBorderWidth());
        }
        Render.setColour(overlay.getColor());
        Render.drawRect(topCorner.x + offsetX + 1.0, topCorner.y + offsetY + 1.0, sizeX - 1.0, sizeY - 1.0);
    }
}

