/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gui.PacketOpenConduitUI;
import crazypants.enderio.conduit.redstone.IInsulatedRedstoneConduit;
import crazypants.enderio.network.PacketHandler;
import crazypants.render.ColorUtil;
import crazypants.util.BlockCoord;
import java.awt.Color;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiExternalConnectionSelector
extends GuiScreen {
    Set<ForgeDirection> cons;
    IConduitBundle cb;

    public GuiExternalConnectionSelector(IConduitBundle cb) {
        this.cb = cb;
        this.cons = new HashSet<ForgeDirection>();
        for (IConduit con : cb.getConduits()) {
            if (con instanceof IInsulatedRedstoneConduit) {
                Set<ForgeDirection> conCons = con.getConduitConnections();
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (conCons.contains(dir)) continue;
                    this.cons.add(dir);
                }
                continue;
            }
            this.cons.addAll(con.getExternalConnections());
        }
    }

    protected void func_146284_a(GuiButton b) {
        ForgeDirection dir = ForgeDirection.values()[b.field_146127_k];
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        BlockCoord loc = this.cb.getLocation();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenConduitUI(this.cb.getEntity(), dir));
        player.openGui((Object)EnderIO.instance, 9 + dir.ordinal(), player.field_70170_p, loc.x, loc.y, loc.z);
    }

    public void func_73866_w_() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Point p = this.getOffsetForDir(dir);
            GuiButton b = new GuiButton(dir.ordinal(), p.x, p.y, 60, 20, dir.toString());
            this.field_146292_n.add(b);
            if (this.cons.contains(dir)) continue;
            b.field_146124_l = false;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        int butHeight = 20;
        String txt = "Select Connection to Adjust";
        int x = this.field_146294_l / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(txt) / 2;
        int y = this.field_146295_m / 2 - butHeight * 3 - 5;
        Tessellator.field_78398_a.func_78382_b();
        this.func_73731_b(Minecraft.func_71410_x().field_71466_p, txt, x, y, ColorUtil.getARGB(Color.white));
        Tessellator.field_78398_a.func_78381_a();
    }

    private Point getOffsetForDir(ForgeDirection dir) {
        int mx = this.field_146294_l / 2;
        int my = this.field_146295_m / 2;
        int butWidth = 60;
        int butHeight = 20;
        int x = mx - butWidth / 2 + dir.offsetX * butWidth;
        int y = my - butHeight / 2 + dir.offsetZ * butHeight * 2;
        return new Point(x += Math.abs(dir.offsetY) * (5 + butWidth * 2), y -= dir.offsetY * butHeight * 2);
    }
}

