/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.inbound;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openperipheral.api.converter.IConverter;
import openperipheral.converter.GenericInboundConverterAdapter;

public class ConverterItemStackInbound
extends GenericInboundConverterAdapter {
    @Override
    public Object toJava(IConverter registry, Object o, Class<?> required) {
        if (required == ItemStack.class && o instanceof Map) {
            Map m = (Map)o;
            Object id = m.get("id");
            Preconditions.checkArgument((boolean)(id instanceof String), (Object)"Invalid item id");
            String[] parts = ((String)id).split(":");
            Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)"Invalid item id");
            String modId = parts[0];
            String name = parts[1];
            Item item = GameRegistry.findItem((String)modId, (String)name);
            int quantity = ConverterItemStackInbound.getIntValue(m, "qty", 1);
            int dmg = ConverterItemStackInbound.getIntValue(m, "dmg", 0);
            return new ItemStack(item, quantity, dmg);
        }
        return null;
    }

    private static int getIntValue(Map<?, ?> map, String key, int _default) {
        Object value = map.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return _default;
    }
}

