/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft.v2;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xcompwiz.mystcraft.api.MystAPI;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import openmods.reflection.ReflectionHelper;
import openperipheral.api.meta.IItemStackMetaProvider;

public class BookMetaProvider
implements IItemStackMetaProvider<Item> {
    private static Class<?> CLS = ReflectionHelper.getClass((String)"com.xcompwiz.mystcraft.item.ItemLinking");
    private final MystAPI api;
    private static final Set<String> FLAGS = ImmutableSet.of((Object)"Relative", (Object)"Maintain Momentum", (Object)"Intra Linking", (Object)"Generate Platform", (Object)"Disarm", (Object)"Following", (Object[])new String[0]);

    public BookMetaProvider(MystAPI api) {
        this.api = api;
    }

    public String getKey() {
        return "myst_book";
    }

    public Class<? extends Item> getTargetClass() {
        return CLS;
    }

    public Object getMeta(Item target, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        ILinkInfo linkInfo = this.api.getLinkingAPI().createLinkInfo(stack.field_77990_d);
        String unlocalizedName = target.func_77658_a();
        boolean isLinkbook = "item.myst.linkbook".equals(unlocalizedName);
        boolean isAgebook = "item.myst.agebook".equals(unlocalizedName);
        HashMap result = Maps.newHashMap();
        result.put("type", isLinkbook ? "link" : (isAgebook ? "age" : "unknown"));
        result.put("destination", linkInfo.getDisplayName());
        result.put("dimension", linkInfo.getDimensionUID());
        HashMap flags = Maps.newHashMap();
        for (String flag : FLAGS) {
            flags.put(flag, linkInfo.getFlag(flag));
        }
        result.put("flags", flags);
        ChunkCoordinates coords = linkInfo.getSpawn();
        if (coords != null) {
            result.put("spawn", Lists.newArrayList((Object[])new Integer[]{coords.field_71574_a, coords.field_71572_b, coords.field_71573_c}));
        }
        result.put("spawnYaw", Float.valueOf(linkInfo.getSpawnYaw()));
        return result;
    }
}

