/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.generic;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonGenericEntities
implements IWailaEntityProvider {
    private static String[] itemTypes = new String[]{"heldItem", "feet", "leggings", "chestplate", "helmet"};
    public static ArrayList<String> petTags = new ArrayList();
    private static String showEquippedItems = "wawla.showEquipment";
    private static String showEntityArmor = "wawla.showMobArmor";
    private static String showPetOwner = "wawla.pets.showOwner";
    private static String showPetSitting = "wawla.pets.sitting";
    private static String showAge = "wawla.pets.age";
    private static String showBirthCooldown = "wawla.pets.cooldown";

    public Entity getWailaOverride(IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return data.getEntity();
    }

    public List<String> getWailaHead(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        if (entity instanceof EntityLiving && cfg.getConfig(showEquippedItems)) {
            EntityLiving living = (EntityLiving)entity;
            for (int i = 0; i < 5; ++i) {
                ItemStack stack = living.func_71124_b(i);
                if (stack == null || !data.getPlayer().func_70093_af()) continue;
                tip.add(StatCollector.func_74838_a((String)("tooltip.wawla." + itemTypes[i])) + ": " + stack.func_82833_r());
            }
            if (cfg.getConfig(showEntityArmor) && living.func_70658_aO() > 0) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.armor") + ": " + living.func_70658_aO());
            }
        }
        if (cfg.getConfig(showPetOwner)) {
            NBTTagCompound tag = Utilities.convertEntityToNbt(entity);
            NBTTagCompound extTag = entity.getEntityData();
            for (String currentKey : petTags) {
                if (tag.func_74764_b(currentKey) && !tag.func_74779_i(currentKey).isEmpty()) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.owner") + ": " + tag.func_74779_i(currentKey));
                }
                if (!extTag.func_74764_b(currentKey) || extTag.func_74779_i(currentKey).isEmpty()) continue;
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.owner") + ": " + extTag.func_74779_i(currentKey));
            }
        }
        if (entity instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)entity;
            if (cfg.getConfig(showAge) && animal.func_70631_g_() && animal.func_70874_b() != 0) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.age") + ": " + animal.func_70874_b() / 20 * -1 + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
            } else if (cfg.getConfig(showBirthCooldown) && animal.func_70874_b() != 0) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.birth") + ": " + animal.func_70874_b() / 20 + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
            }
        }
        if (entity instanceof EntityTameable && cfg.getConfig(showPetSitting)) {
            EntityTameable pet = (EntityTameable)entity;
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.sit") + ": " + pet.func_70906_o());
        }
        return tip;
    }

    public List<String> getWailaTail(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        if (entity != null) {
            entity.func_70109_d(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonGenericEntities dataProvider = new AddonGenericEntities();
        petTags.add("Owner");
        petTags.add("OwnerName");
        petTags.add("owner");
        petTags.add("ownerName");
        register.addConfig("Wawla-Entity", showEquippedItems);
        register.addConfig("Wawla-Entity", showPetOwner);
        register.addConfig("Wawla-Entity", showPetSitting);
        register.addConfig("Wawla-Entity", showAge);
        register.addConfig("Wawla-Entity", showBirthCooldown);
        register.addConfig("Wawla-Entity", showEntityArmor);
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, Entity.class);
        register.registerNBTProvider((IWailaEntityProvider)dataProvider, Entity.class);
    }
}

