/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import tuhljin.automagy.gui.ContainerScribe;
import tuhljin.automagy.gui.GuiButtonCheckbox;
import tuhljin.automagy.gui.GuiButtonHoverAndSound;
import tuhljin.automagy.gui.GuiButtonPseudoSlot;
import tuhljin.automagy.gui.GuiTextFieldWithReporting;
import tuhljin.automagy.gui.ModGuiContainer;
import tuhljin.automagy.lib.SortItemStack;
import tuhljin.automagy.lib.compat.CompatibilityManager;
import tuhljin.automagy.lib.compat.nei.INEICompatPseudoSlots;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.IItemMap;
import tuhljin.automagy.lib.inventory.MappedItemsOrderedByTimeAdded;
import tuhljin.automagy.network.MessageGUIInventariumRequest;
import tuhljin.automagy.tiles.IInventariumBook;

public class GUIScribe
extends ModGuiContainer
implements INEICompatPseudoSlots {
    public static int INVENTORY_ROWS = 6;
    public static int INVENTORY_ROW_SIZE = 10;
    public static int DEMAND_ROWS = 5;
    public static int DEMAND_ROW_SIZE = 3;
    public static int REQUESTSIZE_CTRL = 10;
    public IInventariumBook book;
    private InventoryPlayer inventoryPlayer;
    public final ResourceLocation texture = new ResourceLocation("Automagy:textures/gui/scribeItems.png");
    protected boolean showLocal = false;
    protected ArrayList<ItemStack> stacksLocal = new ArrayList();
    protected ArrayList<ItemStack> stacksInventarium = new ArrayList();
    protected GuiButtonPseudoSlot[] pSlots = new GuiButtonPseudoSlot[INVENTORY_ROWS * INVENTORY_ROW_SIZE];
    protected boolean sortingItemCount = true;
    protected List<ItemStack> stacksRequested = new ArrayList<ItemStack>();
    protected GuiButtonPseudoSlot[] demandSlots = new GuiButtonPseudoSlot[DEMAND_ROWS * DEMAND_ROW_SIZE];
    public boolean hasDemand;
    public boolean hasLocal;
    protected GuiButtonHoverAndSound pagePrev;
    protected GuiButtonHoverAndSound pageNext;
    public int page = 1;
    protected int maxPages;
    protected GuiTextFieldWithReporting textField;
    private String prevText;
    protected GuiButtonCheckbox checkboxLocal;
    protected GuiButtonCheckbox checkboxSortByCount;
    public static boolean alwaysTreatChunkAsUnloaded = true;
    public static boolean chunkLoaded = true;
    private static FilteringItemList contentsForUnloadedChunk;
    private static FilteringItemList contentsForUnloadedChunkLocal;
    private static MappedItemsOrderedByTimeAdded requestsForUnloadedChunk;

    public GUIScribe(InventoryPlayer inventoryPlayer, IInventariumBook book, boolean hasLocal, boolean hasDemand) {
        super(new ContainerScribe(inventoryPlayer, book, hasLocal, hasDemand));
        this.book = book;
        this.inventoryPlayer = inventoryPlayer;
        this.hasLocal = hasLocal;
        this.hasDemand = hasDemand;
        this.field_146999_f = 207;
        this.field_147000_g = 223;
        this.scaleFactor = 0.5f;
        if (hasDemand) {
            this.field_146999_f += ContainerScribe.XOFFSET_DEMAND;
        }
        if (hasLocal) {
            this.showLocal = book.doesPlayerPreferLocalView(inventoryPlayer.field_70458_d);
        }
        this.sortingItemCount = !book.doesPlayerPreferSortByName(inventoryPlayer.field_70458_d);
    }

    @Override
    public void func_73866_w_() {
        int y;
        super.func_73866_w_();
        int xOffset = this.hasDemand ? ContainerScribe.XOFFSET_DEMAND : 0;
        int btns = 0;
        for (y = 1; y <= INVENTORY_ROWS; ++y) {
            for (int x = 1; x <= INVENTORY_ROW_SIZE; ++x) {
                int xPos = this.field_147003_i + 12 + (x - 1) * 18 + xOffset;
                if (x > INVENTORY_ROW_SIZE / 2) {
                    xPos += 6;
                }
                this.pSlots[btns] = new GuiButtonPseudoSlot(btns, this, xPos, this.field_147009_r + 8 + (y - 1) * 18);
                this.field_146292_n.add(this.pSlots[btns]);
                ++btns;
            }
        }
        y = this.field_147009_r + 27 + (INVENTORY_ROWS - 1) * 18;
        this.pagePrev = new GuiButtonHoverAndSound(btns++, this.field_147003_i + 12 + xOffset, y, 11, 5, this.texture, 1, 226, 1, 232, "thaumcraft:page");
        this.field_146292_n.add(this.pagePrev);
        this.pageNext = new GuiButtonHoverAndSound(btns++, this.field_147003_i + 184 + xOffset, y, 12, 5, this.texture, 12, 226, 12, 232, "thaumcraft:page");
        this.field_146292_n.add(this.pageNext);
        ResourceLocation temp = new ResourceLocation("Automagy:textures/gui/eagerChest.png");
        if (this.hasLocal) {
            this.checkboxLocal = new GuiButtonCheckbox(btns++, this.field_147003_i + 108 + xOffset, this.field_147009_r + 119, !this.showLocal, temp, 176, 0);
            this.field_146292_n.add(this.checkboxLocal);
        }
        this.checkboxSortByCount = new GuiButtonCheckbox(btns++, this.field_147003_i + 147 + xOffset, this.field_147009_r + 119, this.sortingItemCount, temp, 176, 0);
        this.field_146292_n.add(this.checkboxSortByCount);
        this.textField = new GuiTextFieldWithReporting(0, this, this.field_146289_q, (int)((float)(this.field_147003_i + 28 + xOffset) / this.scaleFactorTextField), (int)((float)(y + 1) / this.scaleFactorTextField), 94, 16);
        this.textField.setEmptyMessage(StatCollector.func_74838_a((String)"Automagy.gui.scribe.search"));
        this.textFieldList.add(this.textField);
        if (chunkLoaded) {
            this.setStacks(this.book.getInventariumItemList(), false);
            if (this.hasLocal) {
                this.setStacks(this.book.getLocalItemList(), true);
            }
        } else {
            this.setStacks(contentsForUnloadedChunk, false);
            if (this.hasLocal) {
                this.setStacks(contentsForUnloadedChunkLocal, true);
            }
        }
        if (this.hasDemand) {
            int slot = 0;
            for (y = 1; y <= DEMAND_ROWS; ++y) {
                for (int x = 1; x <= DEMAND_ROW_SIZE; ++x) {
                    int xPos = this.field_147003_i - 19 + (x - 1) * 18;
                    this.demandSlots[slot] = new GuiButtonPseudoSlot(btns, this, xPos, this.field_147009_r + 35 + (y - 1) * 18);
                    this.field_146292_n.add(this.demandSlots[slot]);
                    ++slot;
                    ++btns;
                }
            }
            if (chunkLoaded) {
                this.updateRequestedItems(this.book.getInventariumRequestedItemList());
            } else {
                this.updateRequestedItems(requestsForUnloadedChunk);
            }
        }
    }

    public void setStacks(IItemMap list, boolean local) {
        if (list != null) {
            if (local) {
                this.stacksLocal = list.getItemStacks();
            } else {
                this.stacksInventarium = list.getItemStacks();
            }
            this.sortStacks(local);
        } else {
            if (local) {
                this.stacksLocal.clear();
            } else {
                this.stacksInventarium.clear();
            }
            this.updateStacksDisplay();
        }
    }

    public void sortStacks(boolean local) {
        if (this.sortingItemCount) {
            Collections.sort(local ? this.stacksLocal : this.stacksInventarium, new SortItemStack.CompareBySizeReverse());
        } else {
            Collections.sort(local ? this.stacksLocal : this.stacksInventarium, new SortItemStack.CompareByName());
        }
        if (local == this.showLocal) {
            this.updateStacksDisplay();
        }
    }

    public void updateStacksDisplay() {
        ArrayList<ItemStack> stacks = this.showLocal ? this.stacksLocal : this.stacksInventarium;
        String search = this.textField.func_146179_b().toLowerCase();
        int size = stacks.size();
        int slotNum = 0;
        int stackNum = INVENTORY_ROWS * INVENTORY_ROW_SIZE * (this.page - 1);
        while (slotNum < this.pSlots.length) {
            ItemStack stack = stackNum < size ? stacks.get(stackNum) : null;
            ++stackNum;
            if (stack != null && !search.isEmpty()) {
                ArrayList tooltip = (ArrayList)stack.func_82840_a(this.inventoryPlayer.field_70458_d, false);
                boolean found = false;
                for (String s : tooltip) {
                    if (!(s = EnumChatFormatting.func_110646_a((String)s)).toLowerCase().contains(search)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            this.pSlots[slotNum].setItemStack(stack);
            ++slotNum;
        }
        this.maxPages = Math.max((int)Math.ceil((double)stacks.size() / (double)(INVENTORY_ROWS * INVENTORY_ROW_SIZE)), 1);
        if (this.page > this.maxPages) {
            this.page = this.maxPages;
        }
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        int xOffset = this.hasDemand ? ContainerScribe.XOFFSET_DEMAND : 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k + xOffset, l, 0, 0, this.field_146999_f, INVENTORY_ROWS * 18 + 43);
        this.func_73729_b(k + xOffset, l + INVENTORY_ROWS * 18 + 17, 0, 126, this.field_146999_f - (this.hasDemand ? 45 : 15), 96);
        if (this.hasDemand) {
            this.func_73729_b(k - 24, l + 23, 194, 151, 61, 105);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
        if (this.hasLocal) {
            this.drawStringScaledNoShadow(this.field_146289_q, StatCollector.func_74838_a((String)(this.showLocal ? "Automagy.gui.scribe.itemsLocal" : "Automagy.gui.scribe.itemsSystem")), this.field_147003_i + 117 + xOffset, this.field_147009_r + 121, 0x3F3F3F);
        }
        this.drawStringScaledNoShadow(this.field_146289_q, StatCollector.func_74838_a((String)(this.sortingItemCount ? "Automagy.gui.scribe.sortCount" : "Automagy.gui.scribe.sortName")), this.field_147003_i + 156 + xOffset, this.field_147009_r + 121, 0x3F3F3F);
        if (this.hasDemand) {
            this.drawCenteredStringScaledNoShadow(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.scribe.deliver"), this.field_147003_i + 7, this.field_147009_r + 27, 0x3F3F3F);
        }
        GL11.glPopMatrix();
        if (CompatibilityManager.modLoadedNEI) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
            this.drawPseudoSlots(this.pSlots, var2, var3);
            if (this.hasDemand) {
                this.drawPseudoSlots(this.demandSlots, var2, var3);
            }
            GL11.glPopMatrix();
        }
        super.func_146976_a(var1, var2, var3);
    }

    public void func_73863_a(int x, int y, float p_73863_3_) {
        int scroll;
        super.func_73863_a(x, y, p_73863_3_);
        if (!CompatibilityManager.modLoadedNEI) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
            this.drawPseudoSlots(this.pSlots, x, y);
            if (this.hasDemand) {
                this.drawPseudoSlots(this.demandSlots, x, y);
            }
            GL11.glPopMatrix();
        }
        if ((scroll = Mouse.getDWheel()) < 0) {
            int oldPage = this.page;
            this.buttonClicked(this.pageNext, false);
            if (this.page != oldPage) {
                this.pageNext.func_146113_a(this.field_146297_k.func_147118_V());
            }
        } else if (scroll > 0) {
            int oldPage = this.page;
            this.buttonClicked(this.pagePrev, false);
            if (this.page != oldPage) {
                this.pagePrev.func_146113_a(this.field_146297_k.func_147118_V());
            }
        }
        if (this.textField != null && !this.textField.func_146179_b().equals(this.prevText)) {
            this.prevText = this.textField.func_146179_b();
            this.page = 1;
            this.updateStacksDisplay();
        }
    }

    public void drawPseudoSlots(GuiButtonPseudoSlot[] slots, int x, int y) {
        for (int i = 0; i < slots.length; ++i) {
            GuiButtonPseudoSlot pSlot = slots[i];
            if (!pSlot.pointIsOver(x, y)) continue;
            if (this.inventoryPlayer.func_70445_o() != null) break;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int j1 = pSlot.field_146128_h - this.field_147003_i;
            int k1 = pSlot.field_146129_i - this.field_147009_r;
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            if (pSlot.getItemStack() == null || CompatibilityManager.modLoadedNEI) break;
            this.func_146285_a(pSlot.getItemStack(), x - this.field_147003_i, y - this.field_147009_r + 10);
            break;
        }
    }

    @Override
    protected void buttonClicked(GuiButton button, boolean rightClick) {
        ItemStack stack;
        if (button == this.pageNext) {
            if (this.page < this.maxPages && this.pSlots[this.pSlots.length - 1].getItemStack() != null) {
                ++this.page;
                this.updateStacksDisplay();
            }
        } else if (button == this.pagePrev) {
            if (this.page > 1) {
                --this.page;
                this.updateStacksDisplay();
            }
        } else if (button == this.checkboxLocal) {
            this.checkboxLocal.checked = !this.checkboxLocal.checked;
            this.showLocal = !this.checkboxLocal.checked;
            this.page = 1;
            this.sortStacks(this.showLocal);
            this.book.setPlayerLocalViewPreference(this.inventoryPlayer.field_70458_d, this.showLocal);
        } else if (button == this.checkboxSortByCount) {
            this.sortingItemCount = this.checkboxSortByCount.checked = !this.checkboxSortByCount.checked;
            this.sortStacks(this.showLocal);
            this.book.setPlayerSortingPreference(this.inventoryPlayer.field_70458_d, !this.sortingItemCount);
        } else if (this.hasDemand && button instanceof GuiButtonPseudoSlot && (stack = ((GuiButtonPseudoSlot)button).getItemStack()) != null) {
            boolean isDemandSlot;
            int amt;
            int n = amt = rightClick ? -1 : 1;
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                int max = stack.func_77976_d();
                if (max > 1) {
                    amt *= max;
                }
            } else if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                amt *= REQUESTSIZE_CTRL;
            }
            boolean bl = isDemandSlot = button.field_146127_k >= this.demandSlots[0].field_146127_k;
            if (isDemandSlot) {
                if (stack.field_77994_a + amt < 0) {
                    amt = stack.field_77994_a * -1;
                }
            } else if (amt > 0 && !Keyboard.isKeyDown((int)56) && !Keyboard.isKeyDown((int)184)) {
                int currentDemand = this.getDisplayedRequestAmount(new HashableItemWithoutSize(stack));
                if (currentDemand >= stack.field_77994_a) {
                    amt = 0;
                } else if (stack.field_77994_a - currentDemand - amt < 0) {
                    amt = stack.field_77994_a - currentDemand;
                }
            }
            if (amt != 0) {
                ItemStack requestStack = stack.func_77946_l();
                requestStack.field_77994_a = amt;
                MessageGUIInventariumRequest.sendToServer(this.book, requestStack, !isDemandSlot);
                if (isDemandSlot) {
                    int count = stack.field_77994_a + amt;
                    stack.field_77994_a += amt;
                }
            }
        }
    }

    @Override
    public GuiButtonPseudoSlot getPseudoSlotAt(int x, int y) {
        GuiButtonPseudoSlot pSlot;
        int i;
        for (i = 0; i < this.pSlots.length; ++i) {
            pSlot = this.pSlots[i];
            if (!pSlot.pointIsOver(x, y)) continue;
            return pSlot;
        }
        if (this.hasDemand) {
            for (i = 0; i < this.demandSlots.length; ++i) {
                pSlot = this.demandSlots[i];
                if (!pSlot.pointIsOver(x, y)) continue;
                return pSlot;
            }
        }
        return null;
    }

    public void updateRequestedItems(MappedItemsOrderedByTimeAdded list) {
        if (list != null) {
            this.stacksRequested = list.getItemStacks();
            this.stacksRequested = Lists.reverse(this.stacksRequested);
        }
        this.updateRequestedStacksDisplay();
    }

    public void updateRequestedStacksDisplay() {
        int demandPage = 1;
        String search = this.textField.func_146179_b().toLowerCase();
        int size = this.stacksRequested.size();
        int slotNum = 0;
        int stackNum = DEMAND_ROWS * DEMAND_ROW_SIZE * (demandPage - 1);
        while (slotNum < this.demandSlots.length) {
            boolean searchAffectsDemandListing;
            ItemStack stack = stackNum < size ? this.stacksRequested.get(stackNum) : null;
            ++stackNum;
            if (stack != null && (searchAffectsDemandListing = true) && !search.isEmpty()) {
                ArrayList tooltip = (ArrayList)stack.func_82840_a(this.inventoryPlayer.field_70458_d, false);
                boolean found = false;
                for (String s : tooltip) {
                    if (!(s = EnumChatFormatting.func_110646_a((String)s)).toLowerCase().contains(search)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            this.demandSlots[slotNum].setItemStack(stack);
            ++slotNum;
        }
    }

    public int getDisplayedRequestAmount(HashableItemWithoutSize item) {
        if (this.hasDemand) {
            for (GuiButtonPseudoSlot pSlot : this.demandSlots) {
                if (!item.isSameItem(pSlot.getItemStack())) continue;
                return pSlot.stack.field_77994_a;
            }
        }
        return 0;
    }

    public static void handleStacksForUnloadedChunk(ArrayList<ItemStack> list, boolean partial, boolean isRequestList, boolean local) {
        chunkLoaded = false;
        if (isRequestList) {
            if (!partial) {
                requestsForUnloadedChunk.setAll(list);
            } else {
                boolean needUpdate = false;
                GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                GUIScribe guiScribe = gui instanceof GUIScribe ? (GUIScribe)gui : null;
                for (ItemStack stack : list) {
                    int amt;
                    HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
                    requestsForUnloadedChunk.set(item, stack.field_77994_a);
                    if (guiScribe == null || (amt = guiScribe.getDisplayedRequestAmount(item)) != 0 && amt == stack.field_77994_a) continue;
                    needUpdate = true;
                }
                if (needUpdate) {
                    guiScribe.updateRequestedItems(requestsForUnloadedChunk);
                }
            }
        } else if (local) {
            if (!partial || contentsForUnloadedChunkLocal == null) {
                contentsForUnloadedChunkLocal = new FilteringItemList(list, false);
            } else {
                for (ItemStack stack : list) {
                    contentsForUnloadedChunkLocal.set(new HashableItemWithoutSize(stack), stack.field_77994_a > 0 ? stack.field_77994_a : 0);
                }
            }
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof GUIScribe) {
                ((GUIScribe)gui).setStacks(contentsForUnloadedChunkLocal, false);
            }
        } else {
            if (!partial || contentsForUnloadedChunk == null) {
                contentsForUnloadedChunk = new FilteringItemList(list, false);
            } else {
                for (ItemStack stack : list) {
                    contentsForUnloadedChunk.set(new HashableItemWithoutSize(stack), stack.field_77994_a > 0 ? stack.field_77994_a : 0);
                }
            }
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof GUIScribe) {
                ((GUIScribe)gui).setStacks(contentsForUnloadedChunk, false);
            }
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        if (!chunkLoaded) {
            chunkLoaded = true;
            contentsForUnloadedChunk = null;
            contentsForUnloadedChunkLocal = null;
            requestsForUnloadedChunk.clear();
        }
    }

    static {
        requestsForUnloadedChunk = new MappedItemsOrderedByTimeAdded("ItemsRequested");
    }
}

