/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import net.bdew.neiaddons.network.NBTMessageCodec;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class NetChannel {
    public EnumMap<Side, FMLEmbeddedChannel> channels;

    public NetChannel(String name) {
        this.channels = NetworkRegistry.INSTANCE.newChannel(name, new ChannelHandler[]{new NBTMessageCodec()});
    }

    public void addHandler(Side side, ChannelHandler handler) {
        FMLEmbeddedChannel ch = this.channels.get(side);
        String name = ch.findChannelHandlerNameForType(NBTMessageCodec.class);
        ch.pipeline().addAfter(name, side + "Handler", handler);
    }

    public void sendToAll(NBTTagCompound message) {
        FMLEmbeddedChannel chan = this.channels.get(Side.SERVER);
        chan.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        chan.writeAndFlush((Object)message);
    }

    public void sendTo(NBTTagCompound message, EntityPlayerMP player) {
        FMLEmbeddedChannel chan = this.channels.get(Side.SERVER);
        chan.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        chan.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        chan.writeAndFlush((Object)message);
    }

    public void sendToAllAround(NBTTagCompound message, NetworkRegistry.TargetPoint point) {
        FMLEmbeddedChannel chan = this.channels.get(Side.SERVER);
        chan.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        chan.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        chan.writeAndFlush((Object)message);
    }

    public void sendToDimension(NBTTagCompound message, int dimensionId) {
        FMLEmbeddedChannel chan = this.channels.get(Side.SERVER);
        chan.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        chan.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        chan.writeAndFlush((Object)message);
    }

    public void sendToServer(NBTTagCompound message) {
        FMLEmbeddedChannel chan = this.channels.get(Side.CLIENT);
        chan.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        chan.writeAndFlush((Object)message);
    }
}

