/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.core.sync.GuiBridge;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumicenergistics.container.ContainerInternalCrafting;
import thaumicenergistics.container.ContainerWithPlayerInventory;
import thaumicenergistics.container.slot.SlotArcaneCraftingResult;
import thaumicenergistics.container.slot.SlotRestrictive;
import thaumicenergistics.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.integration.tc.ArcaneRecipeHelper;
import thaumicenergistics.network.packet.client.PacketClientArcaneCraftingTerminal;
import thaumicenergistics.parts.AEPartArcaneCraftingTerminal;
import thaumicenergistics.util.EffectiveSide;

public class ContainerPartArcaneCraftingTerminal
extends ContainerWithPlayerInventory
implements IMEMonitorHandlerReceiver<IAEItemStack> {
    private static int PLAYER_INV_POSITION_Y = 162;
    private static int HOTBAR_INV_POSITION_Y = 220;
    private static int CRAFTING_GRID_SIZE = 3;
    public static int CRAFTING_GRID_TOTAL_SIZE = CRAFTING_GRID_SIZE * CRAFTING_GRID_SIZE;
    public static int CRAFTING_SLOT_X_POS = 44;
    public static int CRAFTING_SLOT_Y_POS = 90;
    private static int RESULT_SLOT_X_POS = 116;
    private static int RESULT_SLOT_Y_POS = 126;
    private static int WAND_SLOT_XPOS = 116;
    private static int WAND_SLOT_YPOS = 90;
    public static int VIEW_SLOT_XPOS = 206;
    public static int VIEW_SLOT_YPOS = 8;
    private static int SLOT_SIZE = 18;
    private static CraftingManager CRAFT_MANAGER = CraftingManager.func_77594_a();
    private AEPartArcaneCraftingTerminal arcaneCraftingTerminalPart;
    private EntityPlayer player;
    private int firstCraftingSlotNumber = -1;
    private int lastCraftingSlotNumber = -1;
    private int firstViewSlotNumber = -1;
    private int lastViewSlotNumber = -1;
    private int wandSlotNumber = -1;
    private int resultSlotNumber = -1;
    private ItemStack wand;
    private AspectList requiredAspects;
    private List<ArcaneCrafingCost> craftingCost = new ArrayList<ArcaneCrafingCost>();
    private IMEMonitor<IAEItemStack> monitor;
    private PlayerSource playerSource;

    public ContainerPartArcaneCraftingTerminal(AEPartArcaneCraftingTerminal terminal, EntityPlayer player) {
        this.arcaneCraftingTerminalPart = terminal;
        this.player = player;
        this.playerSource = new PlayerSource(this.player, (IActionHost)terminal);
        this.bindPlayerInventory((IInventory)player.field_71071_by, PLAYER_INV_POSITION_Y, HOTBAR_INV_POSITION_Y);
        Slot craftingSlot = null;
        for (int row = 0; row < CRAFTING_GRID_SIZE; ++row) {
            for (int column = 0; column < CRAFTING_GRID_SIZE; ++column) {
                int slotIndex = row * CRAFTING_GRID_SIZE + column;
                craftingSlot = new Slot((IInventory)terminal, slotIndex, CRAFTING_SLOT_X_POS + column * SLOT_SIZE, CRAFTING_SLOT_Y_POS + row * SLOT_SIZE);
                this.func_75146_a(craftingSlot);
                if (row + column != 0) continue;
                this.firstCraftingSlotNumber = craftingSlot.field_75222_d;
            }
        }
        if (craftingSlot != null) {
            this.lastCraftingSlotNumber = craftingSlot.field_75222_d;
        }
        SlotArcaneCraftingResult resultSlot = new SlotArcaneCraftingResult(player, this, terminal, terminal, 10, RESULT_SLOT_X_POS, RESULT_SLOT_Y_POS);
        this.func_75146_a((Slot)resultSlot);
        this.resultSlotNumber = resultSlot.field_75222_d;
        SlotRestrictive wandSlot = new SlotRestrictive(terminal, 9, WAND_SLOT_XPOS, WAND_SLOT_YPOS);
        this.func_75146_a(wandSlot);
        this.wandSlotNumber = wandSlot.field_75222_d;
        SlotRestrictive viewSlot = null;
        for (int viewSlotID = 11; viewSlotID <= 15; ++viewSlotID) {
            int row = viewSlotID - 11;
            int yPos = VIEW_SLOT_YPOS + row * SLOT_SIZE;
            viewSlot = new SlotRestrictive(terminal, viewSlotID, VIEW_SLOT_XPOS, yPos);
            this.func_75146_a(viewSlot);
            if (row != 0) continue;
            this.firstViewSlotNumber = viewSlot.field_75222_d;
        }
        if (viewSlot != null) {
            this.lastViewSlotNumber = viewSlot.field_75222_d;
        }
        if (EffectiveSide.isServerSide()) {
            this.registerForUpdates();
            this.monitor = terminal.getItemInventory();
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            }
        }
    }

    private boolean clearCraftingGrid(boolean sendUpdate) {
        if (EffectiveSide.isClientSide()) {
            return false;
        }
        boolean clearedAll = true;
        for (int index = this.firstCraftingSlotNumber; index <= this.lastCraftingSlotNumber; ++index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) continue;
            ItemStack slotStack = slot.func_75211_c();
            boolean didMerge = this.mergeWithMENetwork(slotStack);
            if (!didMerge) {
                clearedAll = false;
                continue;
            }
            if (slotStack == null || slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
                continue;
            }
            clearedAll = false;
            slot.func_75218_e();
        }
        this.func_75142_b();
        return clearedAll;
    }

    private void doShiftAutoCrafting(EntityPlayer player) {
        int autoCraftCounter = 0;
        SlotArcaneCraftingResult resultSlot = (SlotArcaneCraftingResult)this.func_75139_a(this.resultSlotNumber);
        ItemStack resultStack = resultSlot.func_75211_c();
        ItemStack slotStackOriginal = resultStack.func_77946_l();
        for (autoCraftCounter = slotStackOriginal.field_77994_a; autoCraftCounter <= 64; autoCraftCounter += slotStackOriginal.field_77994_a) {
            boolean didMerge;
            boolean bl = didMerge = this.mergeSlotWithPlayerInventory(resultStack) || this.mergeSlotWithHotbarInventory(resultStack);
            if (!didMerge) break;
            resultSlot.onPickupFromSlotViaTransfer(player, resultStack);
            this.func_75130_a(null);
            resultStack = resultSlot.func_75211_c();
            if (resultStack == null || resultStack.field_77994_a == 0 || !resultStack.func_77973_b().equals(slotStackOriginal.func_77973_b())) break;
        }
        if (autoCraftCounter > 0) {
            resultSlot.func_75218_e();
            this.func_75142_b();
        }
    }

    private boolean doStacksMatch(IAEItemStack keyStack, IAEItemStack potentialMatch) {
        if (keyStack.getItemStack().func_77969_a(potentialMatch.getItemStack())) {
            return true;
        }
        int[] keyIDs = OreDictionary.getOreIDs((ItemStack)keyStack.getItemStack());
        int[] matchIDs = OreDictionary.getOreIDs((ItemStack)potentialMatch.getItemStack());
        if (keyIDs.length == 0 || matchIDs.length == 0) {
            return false;
        }
        for (int keyID : keyIDs) {
            for (int matchID : matchIDs) {
                if (keyID != matchID) continue;
                return true;
            }
        }
        return false;
    }

    private ItemStack findMatchingArcaneResult() {
        ItemStack arcaneResult = null;
        IArcaneRecipe matchingRecipe = ArcaneRecipeHelper.instance.findMatchingArcaneResult(this.arcaneCraftingTerminalPart, 0, CRAFTING_GRID_TOTAL_SIZE, this.player);
        if (matchingRecipe != null) {
            arcaneResult = this.validateWandVisAmount(matchingRecipe);
        }
        return arcaneResult;
    }

    private ItemStack findMatchingRegularResult() {
        InventoryCrafting craftingInventory = new InventoryCrafting((Container)new ContainerInternalCrafting(), CRAFTING_GRID_SIZE, CRAFTING_GRID_SIZE);
        for (int slotIndex = 0; slotIndex < CRAFTING_GRID_TOTAL_SIZE; ++slotIndex) {
            craftingInventory.func_70299_a(slotIndex, this.arcaneCraftingTerminalPart.func_70301_a(slotIndex));
        }
        return CRAFT_MANAGER.func_82787_a(craftingInventory, this.arcaneCraftingTerminalPart.getWorldObj());
    }

    private ItemStack[] getViewCells() {
        ArrayList<ItemStack> viewCells = new ArrayList<ItemStack>();
        for (int viewSlotIndex = this.firstViewSlotNumber; viewSlotIndex <= this.lastViewSlotNumber; ++viewSlotIndex) {
            Slot viewSlot = this.func_75139_a(viewSlotIndex);
            if (!viewSlot.func_75216_d()) continue;
            viewCells.add(viewSlot.func_75211_c());
        }
        return viewCells.toArray(new ItemStack[viewCells.size()]);
    }

    private void getWand() {
        Slot wandSlot = this.func_75139_a(this.wandSlotNumber);
        if (wandSlot != null) {
            if (this.wand == wandSlot.func_75211_c()) {
                return;
            }
            if (AEPartArcaneCraftingTerminal.isItemValidCraftingWand(wandSlot.func_75211_c())) {
                this.wand = wandSlot.func_75211_c();
                return;
            }
        }
        this.wand = null;
    }

    private boolean mergeWithMENetwork(ItemStack itemStack) {
        IAEItemStack toInject = AEApi.instance().storage().createItemStack(itemStack);
        IAEItemStack leftOver = (IAEItemStack)this.monitor.injectItems((IAEStack)toInject, Actionable.MODULATE, (BaseActionSource)this.playerSource);
        if (leftOver != null && leftOver.getStackSize() > 0L) {
            if (leftOver.getStackSize() == toInject.getStackSize()) {
                return false;
            }
            itemStack.field_77994_a = (int)leftOver.getStackSize();
            return true;
        }
        itemStack.field_77994_a = 0;
        return true;
    }

    private boolean mergeWithViewCells(ItemStack itemStack) {
        if (!this.arcaneCraftingTerminalPart.func_94041_b(11, itemStack)) {
            return false;
        }
        for (int viewSlotIndex = this.firstViewSlotNumber; viewSlotIndex <= this.lastViewSlotNumber; ++viewSlotIndex) {
            Slot viewSlot = this.func_75139_a(viewSlotIndex);
            if (viewSlot.func_75216_d()) continue;
            viewSlot.func_75215_d(itemStack.func_77946_l());
            itemStack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateGUIViewCells() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiArcaneCraftingTerminal) {
            ((GuiArcaneCraftingTerminal)gui).onViewCellsChanged(this.getViewCells());
        }
    }

    private ItemStack validateWandVisAmount(IArcaneRecipe forRecipe) {
        boolean hasAll = true;
        AspectList wandAspectList = null;
        ItemWandCasting wandItem = null;
        this.requiredAspects = ArcaneRecipeHelper.instance.getRecipeAspectCost(this.arcaneCraftingTerminalPart, 0, CRAFTING_GRID_TOTAL_SIZE, forRecipe);
        if (this.requiredAspects == null) {
            return null;
        }
        Aspect[] recipeAspects = this.requiredAspects.getAspects();
        if (this.wand != null) {
            wandItem = (ItemWandCasting)this.wand.func_77973_b();
            wandAspectList = wandItem.getAllVis(this.wand);
        }
        for (Aspect currentAspect : recipeAspects) {
            int baseVis = this.requiredAspects.getAmount(currentAspect);
            int requiredVis = baseVis * 100;
            boolean hasEnough = false;
            if (wandItem != null && wandAspectList != null) {
                requiredVis = (int)((float)requiredVis * wandItem.getConsumptionModifier(this.wand, this.player, currentAspect, true));
                boolean bl = hasEnough = wandAspectList.getAmount(currentAspect) >= requiredVis;
            }
            if (!hasEnough) {
                hasAll = false;
            }
            this.craftingCost.add(new ArcaneCrafingCost((float)requiredVis / 100.0f, currentAspect, hasEnough));
        }
        if (hasAll) {
            return ArcaneRecipeHelper.instance.getRecipeOutput(this.arcaneCraftingTerminalPart, 0, CRAFTING_GRID_TOTAL_SIZE, forRecipe);
        }
        return null;
    }

    protected boolean slotClickedWasInCraftingInventory(int slotNumber) {
        return slotNumber >= this.firstCraftingSlotNumber && slotNumber <= this.lastCraftingSlotNumber;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public List<ArcaneCrafingCost> getCraftingCost() {
        if (this.craftingCost.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(this.craftingCost);
    }

    public boolean isValid(Object authToken) {
        return true;
    }

    public void onClientNEIRequestSetCraftingGrid(EntityPlayer player, IAEItemStack[] gridItems) {
        if (this.clearCraftingGrid(false)) {
            for (int craftingSlotIndex = 0; craftingSlotIndex < 9; ++craftingSlotIndex) {
                ItemStack matchingStack;
                IAEItemStack slotStack = gridItems[craftingSlotIndex];
                if (slotStack == null || (matchingStack = this.requestCraftingReplenishment(slotStack.getItemStack())) == null) continue;
                Slot slot = (Slot)this.field_75151_b.get(this.firstCraftingSlotNumber + craftingSlotIndex);
                slot.func_75215_d(matchingStack);
            }
            this.func_75142_b();
        }
    }

    public void onClientRequestAutoCraft(EntityPlayer player, IAEItemStack result) {
        Platform.openGUI((EntityPlayer)player, (TileEntity)this.arcaneCraftingTerminalPart.getHostTile(), (ForgeDirection)this.arcaneCraftingTerminalPart.getSide(), (GuiBridge)GuiBridge.GUI_CRAFTING_AMOUNT);
        if (player.field_71070_bA instanceof ContainerCraftAmount) {
            ContainerCraftAmount cca = (ContainerCraftAmount)this.player.field_71070_bA;
            cca.craftingItem.func_75215_d(result.getItemStack());
            cca.whatToMake = result;
            cca.func_75142_b();
        }
    }

    public void onClientRequestClearCraftingGrid(EntityPlayer player) {
        this.clearCraftingGrid(true);
    }

    public void onClientRequestDeposit(EntityPlayer player, int mouseButton) {
        IAEItemStack leftOverStack;
        boolean depositOne;
        if (player == null) {
            return;
        }
        ItemStack playerHolding = player.field_71071_by.func_70445_o();
        if (playerHolding == null) {
            return;
        }
        IAEItemStack toInjectStack = AEApi.instance().storage().createItemStack(playerHolding);
        boolean bl = depositOne = mouseButton == 1 || mouseButton == -2;
        if (depositOne) {
            toInjectStack.setStackSize(1L);
        }
        if ((leftOverStack = (IAEItemStack)this.monitor.injectItems((IAEStack)toInjectStack, Actionable.MODULATE, (BaseActionSource)this.playerSource)) != null && leftOverStack.getStackSize() > 0L) {
            if (toInjectStack.getStackSize() == 1L) {
                return;
            }
            player.field_71071_by.func_70437_b(leftOverStack.getItemStack());
        } else if (depositOne && playerHolding.field_77994_a > 1) {
            --playerHolding.field_77994_a;
            player.field_71071_by.func_70437_b(playerHolding);
            leftOverStack = AEApi.instance().storage().createItemStack(playerHolding);
        } else {
            player.field_71071_by.func_70437_b(null);
        }
        new PacketClientArcaneCraftingTerminal().createPlayerHoldingUpdate(player, leftOverStack).sendPacketToPlayer();
    }

    public void onClientRequestDepositRegion(EntityPlayer player, int slotNumber) {
        List<Slot> slotsToDeposit = null;
        if (this.slotClickedWasInPlayerInventory(slotNumber)) {
            slotsToDeposit = this.getNonEmptySlotsFromPlayerInventory();
        } else if (this.slotClickedWasInHotbarInventory(slotNumber)) {
            slotsToDeposit = this.getNonEmptySlotsFromHotbar();
        }
        if (slotsToDeposit != null) {
            for (Slot slot : slotsToDeposit) {
                ItemStack slotStack;
                boolean didMerge;
                if (slot == null || !slot.func_75216_d() || !(didMerge = this.mergeWithMENetwork(slotStack = slot.func_75211_c()))) continue;
                if (slotStack == null || slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                    continue;
                }
                slot.func_75218_e();
            }
            this.func_75142_b();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onClientRequestExtract(EntityPlayer player, IAEItemStack requestedStack, int mouseButton, boolean isShiftHeld) {
        if (player == null) {
            return;
        }
        if (requestedStack == null || requestedStack.getStackSize() == 0L) {
            return;
        }
        int maxStackSize = requestedStack.getItemStack().func_77976_d();
        int amountToExtract = 0;
        switch (mouseButton) {
            case 0: {
                amountToExtract = (int)Math.min((long)maxStackSize, requestedStack.getStackSize());
                break;
            }
            case 1: {
                if (isShiftHeld) {
                    amountToExtract = 1;
                    break;
                }
                double halfRequest = (double)requestedStack.getStackSize() / 2.0;
                double halfMax = (double)maxStackSize / 2.0;
                halfRequest = Math.ceil(halfRequest);
                halfMax = Math.ceil(halfMax);
                amountToExtract = (int)Math.min(halfMax, halfRequest);
                break;
            }
            case -2: {
                if (!isShiftHeld) break;
                amountToExtract = 1;
            }
        }
        if (amountToExtract <= 0) {
            return;
        }
        IAEItemStack toExtract = requestedStack.copy();
        toExtract.setStackSize((long)amountToExtract);
        IAEItemStack extractedStack = (IAEItemStack)this.monitor.extractItems((IAEStack)toExtract, Actionable.SIMULATE, (BaseActionSource)this.playerSource);
        if (extractedStack == null || extractedStack.getStackSize() <= 0L) return;
        if (mouseButton == 0 && isShiftHeld && player.field_71071_by.func_70441_a(extractedStack.getItemStack())) {
            this.monitor.extractItems((IAEStack)toExtract, Actionable.MODULATE, (BaseActionSource)this.playerSource);
            return;
        }
        ItemStack playerHolding = player.field_71071_by.func_70445_o();
        if (playerHolding != null) {
            if (playerHolding.field_77994_a >= maxStackSize || !playerHolding.func_77969_a(extractedStack.getItemStack())) return;
            if ((amountToExtract = Math.min(amountToExtract, maxStackSize - playerHolding.field_77994_a)) <= 0) {
                return;
            }
            playerHolding.field_77994_a += amountToExtract;
            player.field_71071_by.func_70437_b(playerHolding);
            toExtract.setStackSize((long)amountToExtract);
        } else {
            player.field_71071_by.func_70437_b(extractedStack.getItemStack());
        }
        this.monitor.extractItems((IAEStack)toExtract, Actionable.MODULATE, (BaseActionSource)this.playerSource);
        new PacketClientArcaneCraftingTerminal().createPlayerHoldingUpdate(player, AEApi.instance().storage().createItemStack(player.field_71071_by.func_70445_o())).sendPacketToPlayer();
    }

    public void onClientRequestFullUpdate(EntityPlayer player) {
        new PacketClientArcaneCraftingTerminal().createSortingUpdate(player, this.arcaneCraftingTerminalPart.getSortingOrder(), this.arcaneCraftingTerminalPart.getSortingDirection(), this.arcaneCraftingTerminalPart.getViewMode()).sendPacketToPlayer();
        if (this.monitor != null) {
            IItemList fullList = this.monitor.getStorageList();
            new PacketClientArcaneCraftingTerminal().createFullListUpdate(player, (IItemList<IAEItemStack>)fullList).sendPacketToPlayer();
        }
    }

    public void onClientRequestSetSort(SortOrder order, SortDir dir, ViewItems viewMode) {
        this.arcaneCraftingTerminalPart.setSorts(order, dir, viewMode);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.arcaneCraftingTerminalPart != null) {
            this.arcaneCraftingTerminalPart.removeListener(this);
        }
        if (EffectiveSide.isServerSide() && this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void func_75130_a(IInventory inventory) {
        this.requiredAspects = null;
        this.craftingCost.clear();
        this.getWand();
        ItemStack craftResult = this.findMatchingRegularResult();
        if (craftResult == null) {
            craftResult = this.findMatchingArcaneResult();
        }
        SlotArcaneCraftingResult resultSlot = (SlotArcaneCraftingResult)this.func_75139_a(this.resultSlotNumber);
        resultSlot.setResultAspects(this.requiredAspects);
        resultSlot.setWand(this.wand);
        this.arcaneCraftingTerminalPart.setInventorySlotContentsWithoutNotify(10, craftResult);
    }

    public void onListUpdate() {
    }

    public void onViewCellChange() {
        if (EffectiveSide.isClientSide()) {
            this.updateGUIViewCells();
        }
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> changes, BaseActionSource actionSource) {
        for (IAEItemStack change : changes) {
            IAEItemStack newAmount = (IAEItemStack)this.monitor.getStorageList().findPrecise((IAEStack)change);
            if (newAmount == null) {
                newAmount = change.copy();
                newAmount.setStackSize(0L);
            }
            new PacketClientArcaneCraftingTerminal().createChangeUpdate(this.player, newAmount).sendPacketToPlayer();
        }
    }

    public void registerForUpdates() {
        this.arcaneCraftingTerminalPart.registerListener(this);
    }

    public ItemStack requestCraftingReplenishment(ItemStack itemStack) {
        IAEItemStack requestStack = AEApi.instance().storage().createItemStack(itemStack);
        requestStack.setStackSize(1L);
        IAEItemStack replenishment = (IAEItemStack)this.monitor.extractItems((IAEStack)requestStack, Actionable.MODULATE, (BaseActionSource)this.playerSource);
        if (replenishment != null) {
            return replenishment.getItemStack();
        }
        IItemList networkItems = this.monitor.getStorageList();
        for (IAEItemStack potentialMatch : networkItems) {
            if (!this.doStacksMatch(requestStack, potentialMatch)) continue;
            requestStack = potentialMatch.copy();
            requestStack.setStackSize(1L);
            replenishment = (IAEItemStack)this.monitor.extractItems((IAEStack)requestStack, Actionable.MODULATE, (BaseActionSource)this.playerSource);
            if (replenishment == null || replenishment.getStackSize() <= 0L) continue;
            return replenishment.getItemStack();
        }
        return null;
    }

    public ItemStack func_75144_a(int slotID, int button, int flag, EntityPlayer player) {
        if (slotID == this.resultSlotNumber && button == 1) {
            return null;
        }
        return super.func_75144_a(slotID, button, flag, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        if (EffectiveSide.isClientSide()) {
            return null;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (slotNumber == this.wandSlotNumber || this.slotClickedWasInCraftingInventory(slotNumber)) {
                didMerge = this.mergeWithMENetwork(slotStack);
                if (!didMerge && !(didMerge = this.mergeSlotWithHotbarInventory(slotStack))) {
                    didMerge = this.mergeSlotWithPlayerInventory(slotStack);
                }
            } else if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                if (this.func_75139_a(this.wandSlotNumber).func_75214_a(slotStack)) {
                    didMerge = this.func_75135_a(slotStack, this.wandSlotNumber, this.wandSlotNumber + 1, false);
                }
                if (!(didMerge || (didMerge = this.mergeWithViewCells(slotStack)) || (didMerge = this.mergeWithMENetwork(slotStack)) || (didMerge = this.func_75135_a(slotStack, this.firstCraftingSlotNumber, this.lastCraftingSlotNumber + 1, false)))) {
                    didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                }
            } else {
                if (slotNumber == this.resultSlotNumber) {
                    this.doShiftAutoCrafting(player);
                    return null;
                }
                if (slotNumber >= this.firstViewSlotNumber && slotNumber <= this.lastViewSlotNumber && !(didMerge = this.mergeSlotWithHotbarInventory(slotStack))) {
                    didMerge = this.mergeSlotWithPlayerInventory(slotStack);
                }
            }
            if (didMerge) {
                if (slotStack == null || slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                this.func_75142_b();
            }
        }
        return null;
    }

    public class ArcaneCrafingCost {
        public final float visCost;
        public final Aspect primal;
        public final boolean hasEnoughVis;

        public ArcaneCrafingCost(float visCost, Aspect primal, boolean hasEnough) {
            this.visCost = (float)Math.round(visCost * 10.0f) / 10.0f;
            this.primal = primal;
            this.hasEnoughVis = hasEnough;
        }
    }
}

