/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.Vector3;

public class Matrix3 {
    public static Matrix3 ident = new Matrix3();
    public static Matrix3[] turnRotations = new Matrix3[]{Matrix3.rotY(0.0), Matrix3.rotY(90.0), Matrix3.rotY(180.0), Matrix3.rotY(270.0)};
    public static Matrix3[] sideRotations = new Matrix3[]{ident, Matrix3.rotX(180.0), Matrix3.rotX(90.0), Matrix3.rotX(-90.0).mul(Matrix3.rotY(180.0)), Matrix3.rotZ(-90.0).mul(Matrix3.rotY(90.0)), Matrix3.rotZ(90.0).mul(Matrix3.rotY(-90.0))};
    public double[][] m = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};

    public static Matrix3 rotX(double d) {
        return Matrix3.rot(d, 1, 2);
    }

    public static Matrix3 rotY(double d) {
        return Matrix3.rot(d, 2, 0);
    }

    public static Matrix3 rotZ(double d) {
        return Matrix3.rot(d, 0, 1);
    }

    static Matrix3 rot(double d, int n, int n2) {
        double d2 = Math.toRadians(d);
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        Matrix3 matrix3 = new Matrix3();
        matrix3.m[n][n] = d4;
        matrix3.m[n][n2] = -d3;
        matrix3.m[n2][n] = d3;
        matrix3.m[n2][n2] = d4;
        return matrix3;
    }

    public Matrix3 mul(Matrix3 matrix3) {
        Matrix3 matrix32 = new Matrix3();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                matrix32.m[i][j] = this.m[i][0] * matrix3.m[0][j] + this.m[i][1] * matrix3.m[1][j] + this.m[i][2] * matrix3.m[2][j];
            }
        }
        return matrix32;
    }

    public Vector3 mul(double d, double d2, double d3) {
        return new Vector3(d * this.m[0][0] + d2 * this.m[0][1] + d3 * this.m[0][2], d * this.m[1][0] + d2 * this.m[1][1] + d3 * this.m[1][2], d * this.m[2][0] + d2 * this.m[2][1] + d3 * this.m[2][2]);
    }

    public Vector3 imul(double d, double d2, double d3) {
        return new Vector3(d * this.m[0][0] + d2 * this.m[1][0] + d3 * this.m[2][0], d * this.m[0][1] + d2 * this.m[1][1] + d3 * this.m[2][1], d * this.m[0][2] + d2 * this.m[1][2] + d3 * this.m[2][2]);
    }

    public Vector3 mul(Vector3 vector3) {
        return this.mul(vector3.x, vector3.y, vector3.z);
    }

    public Vector3 imul(Vector3 vector3) {
        return this.imul(vector3.x, vector3.y, vector3.z);
    }

    public void dump() {
        for (int i = 0; i < 3; ++i) {
            System.out.printf("[%6.3f %6.3f %6.3f]\n", this.m[i][0], this.m[i][1], this.m[i][2]);
        }
    }
}

