/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import com.google.common.base.Strings;
import java.awt.Desktop;
import java.net.URI;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StatCollector;
import openeye.Log;
import openeye.notes.GuiNotesList;
import openeye.notes.entries.NoteEntry;

public abstract class GuiNotesBase
extends GuiScreen {
    private static final int ACTION_GOTO_URL = 0;
    private static final int BUTTON_FINISHED_ID = 0;
    private static final int BUTTON_GOTO_ID = 1;
    private final GuiScreen prevGui;
    private GuiNotesList noteList;
    private int selectedNote = -1;
    private final List<NoteEntry> notes;
    private GuiButton gotoButton;
    private String gotoUrl;

    GuiNotesBase(GuiScreen prevGui, List<NoteEntry> notes) {
        this.prevGui = prevGui;
        this.notes = notes;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2, this.field_146295_m - 30, 150, 20, StatCollector.func_74838_a((String)"gui.done")));
        this.gotoButton = new GuiButton(1, this.field_146294_l / 2 - 150, this.field_146295_m - 30, 150, 20, StatCollector.func_74838_a((String)"openeye.notes.goto_page"));
        this.gotoButton.field_146124_l = false;
        this.field_146292_n.add(this.gotoButton);
        this.noteList = new GuiNotesList(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, 10, this.field_146295_m - 40, this.notes);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.noteList.drawScreen(par1, par2, par3);
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(this.prevGui);
        } else if (button.field_146127_k == 1) {
            this.displayConfirmation(this.gotoUrl, 0);
        }
    }

    protected abstract void displayConfirmation(String var1, int var2);

    private static void openURI(String uri) {
        try {
            URI parsedUri = new URI(uri);
            Desktop.getDesktop().browse(parsedUri);
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to open URL %s", uri);
        }
    }

    public void func_73878_a(boolean result, int action) {
        if (action == 0 && result) {
            GuiNotesBase.openURI(this.gotoUrl);
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    public void selectNote(int slot) {
        this.selectedNote = slot;
        this.gotoUrl = this.getUrl(slot);
        this.gotoButton.field_146124_l = !Strings.isNullOrEmpty((String)this.gotoUrl);
    }

    private String getUrl(int slot) {
        if (slot >= 0 && slot < this.notes.size()) {
            NoteEntry entry = this.notes.get(slot);
            return entry.url();
        }
        return null;
    }

    public boolean isNoteSelected(int slot) {
        return this.selectedNote == slot;
    }
}

