/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Preconditions;
import java.io.File;
import openeye.logic.GsonUtils;
import openeye.logic.ModState;
import openeye.reports.ReportCrash;
import openeye.storage.GsonPredefinedStorage;
import openeye.storage.GsonSessionStorage;
import openeye.storage.GsonWorkingStorage;
import openeye.storage.IAppendableStorage;
import openeye.storage.IQueryableStorage;
import openeye.storage.IWorkingStorage;

public class Storages {
    public static final String STATE_FILE_ID = "state";
    public final IQueryableStorage<ModState> state;
    public final IWorkingStorage<ReportCrash> pendingCrashes;
    public final IAppendableStorage<Object> sessionArchive;
    public final File reportsDir;
    private static Storages instance;

    private Storages(File mcDir) {
        this.reportsDir = new File(mcDir, "reports");
        this.reportsDir.mkdir();
        this.state = new GsonPredefinedStorage<ModState>(this.reportsDir, ModState.class, GsonUtils.PRETTY_GSON, STATE_FILE_ID);
        this.pendingCrashes = new GsonWorkingStorage<ReportCrash>(this.reportsDir, "pending-crash", ReportCrash.class, GsonUtils.PRETTY_GSON);
        this.sessionArchive = new GsonSessionStorage<Object>(this.reportsDir, "json", Object.class, GsonUtils.PRETTY_GSON);
    }

    public static Storages init(File mcDir) {
        if (instance == null) {
            instance = new Storages(mcDir);
        }
        return instance;
    }

    public static Storages instance() {
        Preconditions.checkNotNull((Object)instance, (Object)"Storage not initialized");
        return instance;
    }
}

