/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.TypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallVirtual;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.casting.ICastingRuleDelegate;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;
import stanhebben.zenscript.value.IntRange;

public class ZenTypeIntRange
extends ZenType {
    public static final ZenTypeIntRange INSTANCE = new ZenTypeIntRange();
    private final IJavaMethod methodFrom;
    private final IJavaMethod methodTo;

    private ZenTypeIntRange() {
        TypeRegistry dummy = new TypeRegistry();
        this.methodFrom = JavaMethod.get(dummy, IntRange.class, "getFrom", new Class[0]);
        this.methodTo = JavaMethod.get(dummy, IntRange.class, "getTo", new Class[0]);
    }

    @Override
    public String getAnyClassName(IEnvironmentGlobal global) {
        throw new UnsupportedOperationException("range values cannot yet be used as any value");
    }

    @Override
    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        environment.error(position, "cannot apply unary operators on int ranges");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        environment.error(position, "cannot apply binary operators on int ranges");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        environment.error(position, "cannot apply ternary operators on int ranges");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        environment.error(position, "cannot compare int ranges");
        return new ExpressionInvalid(position, BOOL);
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        if (name.equals("from")) {
            return new ExpressionCallVirtual(position, environment, this.methodFrom, value.eval(environment), new Expression[0]);
        }
        if (name.equals("to")) {
            return new ExpressionCallVirtual(position, environment, this.methodTo, value.eval(environment), new Expression[0]);
        }
        environment.error(position, "no such member " + name + " in int range");
        return new ExpressionInvalid(position);
    }

    @Override
    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        environment.error(position, "int ranges don't have static members");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        environment.error(position, "int ranges cannot be called");
        return new ExpressionInvalid(position);
    }

    @Override
    public void constructCastingRules(IEnvironmentGlobal environment, ICastingRuleDelegate rules, boolean followCasters) {
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        if (numValues == 1) {
            return new IntRangeIterator(methodOutput);
        }
        return null;
    }

    @Override
    public Class toJavaClass() {
        return IntRange.class;
    }

    @Override
    public Type toASMType() {
        return Type.getType(IntRange.class);
    }

    @Override
    public int getNumberType() {
        return 0;
    }

    @Override
    public String getSignature() {
        return ZenTypeUtil.signature(IntRange.class);
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public String getName() {
        return "int..";
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }

    private class IntRangeIterator
    implements IZenIterator {
        private final IEnvironmentMethod method;

        public IntRangeIterator(IEnvironmentMethod methodOutput) {
            this.method = methodOutput;
        }

        @Override
        public void compileStart(int[] locals) {
            MethodOutput output = this.method.getOutput();
            output.dup();
            ZenTypeIntRange.this.methodFrom.invokeVirtual(output);
            output.storeInt(locals[0]);
        }

        @Override
        public void compilePreIterate(int[] locals, Label exit) {
        }

        @Override
        public void compilePostIterate(int[] locals, Label exit, Label repeat) {
            MethodOutput output = this.method.getOutput();
            output.dup();
            ZenTypeIntRange.this.methodTo.invokeVirtual(output);
            output.loadInt(locals[0]);
            output.iinc(locals[0]);
            output.dup();
            output.storeInt(locals[0]);
            output.ifICmpGT(repeat);
            output.goTo(exit);
        }

        @Override
        public void compileEnd() {
            this.method.getOutput().pop();
        }

        @Override
        public ZenType getType(int i) {
            return ZenType.INT;
        }
    }
}

