/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.client.model.anim.DragonAnimator;
import info.ata4.minecraft.dragon.server.entity.EntityFlyingTameable;
import info.ata4.minecraft.dragon.server.entity.ai.DragonBodyHelper;
import info.ata4.minecraft.dragon.server.entity.ai.air.EntityAICatchOwnerAir;
import info.ata4.minecraft.dragon.server.entity.ai.air.EntityAILand;
import info.ata4.minecraft.dragon.server.entity.ai.air.EntityAIRideAir;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAICatchOwnerGround;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIDragonMate;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIFollowOwner;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIHunt;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIPanicChild;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIRideGround;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIWatchIdle;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIWatchLiving;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBreedHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonDebug;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStageHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonParticleHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonReproductionHelper;
import info.ata4.minecraft.dragon.server.util.ItemUtils;
import info.ata4.minecraft.dragon.util.reflection.PrivateFields;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityTameableDragon
extends EntityFlyingTameable {
    private static final Logger L = LogManager.getLogger();
    public static final double BASE_SPEED_GROUND = 0.3;
    public static final double BASE_SPEED_AIR = 1.5;
    public static final double BASE_DAMAGE = 8.0;
    public static final double BASE_HEALTH = 60.0;
    public static final float BASE_WIDTH = 4.0f;
    public static final float BASE_HEIGHT = 3.0f;
    public static final int HOME_RADIUS = 256;
    public static final Item FAVORITE_FOOD = Items.field_151115_aP;
    private static final int INDEX_SADDLED = 20;
    private static final int INDEX_BREEDER = 21;
    private static final int INDEX_BREED = 22;
    private static final int INDEX_REPRO_COUNT = 23;
    private static final String NBT_SADDLED = "Saddle";
    private Map<Class, DragonHelper> helpers;
    private DragonAnimator animator;
    private BitSet controlFlags;

    public EntityTameableDragon(World world) {
        super(world);
        try {
            ReflectionHelper.setPrivateValue(EntityLiving.class, (Object)((Object)this), (Object)((Object)new DragonBodyHelper(this)), (String[])PrivateFields.ENTITYLIVING_BODYHELPER);
        }
        catch (Exception ex) {
            L.warn("Can't override EntityBodyHelper", (Throwable)ex);
        }
        this.func_70105_a(4.0f, 3.0f);
        this.field_70138_W = 1.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAICatchOwnerGround(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRideGround(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIDragonMate(this, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.75, FAVORITE_FOOD, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollowOwner(this, 1.0, 12.0f, 128.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIPanicChild(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchLiving(this, 16.0f, 0.05f));
        this.airTasks.func_75776_a(0, (EntityAIBase)new EntityAIRideAir(this));
        this.airTasks.func_75776_a(0, (EntityAIBase)new EntityAILand(this));
        this.airTasks.func_75776_a(0, (EntityAIBase)new EntityAICatchOwnerAir(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHunt(this, EntitySheep.class, 200, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHunt(this, EntityPig.class, 200, false));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHunt(this, EntityChicken.class, 200, false));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.addHelper(new DragonBreedHelper(this, 22));
        this.addHelper(new DragonLifeStageHelper(this));
        this.addHelper(new DragonReproductionHelper(this, 21, 23));
        this.addHelper(new DragonParticleHelper(this));
        if (DragonMounts.instance.getConfig().isDebug()) {
            this.addHelper(new DragonDebug(this));
        }
        if (this.isClient()) {
            this.animator = new DragonAnimator(this);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.setAttributes();
        for (DragonHelper helper : this.helpers.values()) {
            helper.applyEntityAttributes();
        }
    }

    private void setAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(MOVE_SPEED_AIR).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a(NBT_SADDLED, this.isSaddled());
        for (DragonHelper helper : this.helpers.values()) {
            helper.writeToNBT(nbt);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSaddled(nbt.func_74767_n(NBT_SADDLED));
        for (DragonHelper helper : this.helpers.values()) {
            helper.readFromNBT(nbt);
        }
        this.setAttributes();
    }

    @Override
    public void func_70636_d() {
        EntityLivingBase owner;
        for (DragonHelper helper : this.helpers.values()) {
            helper.onLivingUpdate();
        }
        if (this.isClient()) {
            if (!this.isEgg()) {
                this.animator.setOnGround(!this.isFlying());
                this.animator.update();
            }
        } else if (this.func_70909_n() && (owner = this.func_70902_q()) != null) {
            this.func_110171_b((int)owner.field_70165_t, (int)owner.field_70163_u, (int)owner.field_70161_v, 256);
        }
        super.func_70636_d();
    }

    protected void func_70609_aI() {
        for (DragonHelper helper : this.helpers.values()) {
            helper.onDeathUpdate();
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70078_a(null);
        }
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70177_z = this.field_70126_B;
        this.field_70759_as = this.field_70758_at;
        if (this.isEgg()) {
            this.func_70106_y();
        } else if (this.field_70725_aQ >= this.getMaxDeathTime()) {
            this.func_70106_y();
        }
        ++this.field_70725_aQ;
    }

    public void func_70106_y() {
        for (DragonHelper helper : this.helpers.values()) {
            helper.onDeath();
        }
        super.func_70106_y();
    }

    public String func_70005_c_() {
        if (this.func_94056_bM()) {
            return this.func_94057_bL();
        }
        String entName = EntityList.func_75621_b((Entity)this);
        String breedName = this.getBreed().getName().toLowerCase();
        return StatCollector.func_74838_a((String)("entity." + entName + "." + breedName + ".name"));
    }

    protected String func_70639_aQ() {
        if (this.isEgg() || this.isFlying()) {
            return null;
        }
        return this.getBreed().getLivingSound(this);
    }

    protected String func_70621_aR() {
        if (this.isEgg()) {
            return "mob.zombie.wood";
        }
        return this.getBreed().getHurtSound(this);
    }

    protected String func_70673_aS() {
        if (this.isEgg()) {
            return "mob.zombie.woodbreak";
        }
        return this.getBreed().getDeathSound(this);
    }

    public void func_70642_aH() {
        String sound = this.func_70639_aQ();
        if (sound == null) {
            return;
        }
        float v = this.func_70599_aP();
        float p = this.func_70647_i();
        if (sound.endsWith("breathe")) {
            v = (float)((double)v * 0.5);
            p = (float)((double)p * 0.5);
        }
        this.func_85030_a(sound, v, p);
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        if (!this.isEgg() && !this.field_70171_ac) {
            if (this.isHatchling()) {
                super.func_145780_a(x, y, z, block);
            } else {
                this.field_70170_p.func_72956_a((Entity)this, DragonMounts.AID + ":mob.enderdragon.step", 0.5f, 1.0f);
            }
        }
    }

    protected float func_70599_aP() {
        return 2.0f - this.getScale();
    }

    protected float func_70647_i() {
        return super.func_70647_i() * (2.0f - this.getScale());
    }

    public int func_70627_aG() {
        return 240;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.getBreed().getCreatureAttribute();
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack playerItem = player.field_71071_by.func_70448_g();
        if (playerItem != null && playerItem.func_77973_b() == Items.field_151063_bx) {
            return super.func_70085_c(player);
        }
        if (this.isEgg()) {
            return false;
        }
        if (this.func_70909_n() || this.func_70631_g_()) {
            ItemFood food = null;
            if (this.getHealthRelative() < 1.0) {
                food = (ItemFood)ItemUtils.consumeEquipped(player, FAVORITE_FOOD, Items.field_151147_al, Items.field_151082_bd, Items.field_151076_bf);
            }
            if (food != null) {
                this.func_70691_i(food.func_150905_g(playerItem));
                float volume = this.func_70599_aP() * 0.7f;
                float pitch = this.func_70647_i();
                this.field_70170_p.func_72956_a((Entity)this, "random.eat", volume, pitch);
                return true;
            }
            if (!this.func_152114_e((EntityLivingBase)player)) {
                if (this.isServer()) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("dragon.owned", new Object[0]));
                }
            } else if (!this.func_70631_g_() && this.field_70153_n == null) {
                if (!this.isSaddled() && ItemUtils.consumeEquipped(player, Items.field_151141_av)) {
                    if (this.isServer()) {
                        this.setSaddled(true);
                    }
                } else if (ItemUtils.hasEquipped(player, Items.field_151103_aS)) {
                    if (this.isServer()) {
                        this.field_70911_d.func_75270_a(!this.func_70906_o());
                        this.field_70703_bu = false;
                        this.func_70778_a(null);
                    }
                } else if (this.getReproductionHelper().canReproduce() && ItemUtils.consumeEquipped(player, FAVORITE_FOOD)) {
                    if (this.isClient()) {
                        this.getParticleHelper().spawnBodyParticles("heart");
                    }
                    this.func_146082_f(player);
                } else if (this.isSaddled() && !ItemUtils.hasEquippedUsable(player) && this.isServer()) {
                    this.setRidingPlayer(player);
                }
            }
        } else {
            if (this.isServer() && ItemUtils.consumeEquipped(player, FAVORITE_FOOD)) {
                this.tamedFor(player, this.field_70146_Z.nextInt(3) == 0);
            }
            return true;
        }
        return false;
    }

    public void tamedFor(EntityPlayer player, boolean successful) {
        if (successful) {
            this.func_70903_f(true);
            this.func_70778_a(null);
            this.func_70624_b(null);
            this.func_152115_b(player.func_110124_au().toString());
            this.func_70908_e(true);
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        } else {
            this.func_70908_e(false);
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
        }
    }

    @Override
    protected void func_70619_bc() {
        if (!this.isEgg()) {
            super.func_70619_bc();
        }
    }

    public boolean func_70877_b(ItemStack item) {
        return false;
    }

    public float func_70047_e() {
        float eyeHeight = super.func_70047_e();
        if (this.func_70906_o()) {
            eyeHeight *= 0.8f;
        }
        return eyeHeight;
    }

    public double func_70042_X() {
        return (this.func_70906_o() ? 1.7f : 2.2f) * this.getScale();
    }

    public float func_70603_bj() {
        return this.getScale();
    }

    protected boolean func_70650_aV() {
        return true;
    }

    @Override
    protected boolean isGroundAIEnabled() {
        return super.isGroundAIEnabled() && !this.isEgg();
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.isEgg();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        if (this.isSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    public boolean func_70652_k(Entity victim) {
        boolean attacked;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (victim instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)victim));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)victim));
        }
        if (attacked = victim.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            int fireAspect;
            if (knockback > 0) {
                double vx = -Math.sin(Math.toRadians(this.field_70177_z)) * (double)knockback * 0.5;
                double vy = 0.1;
                double vz = Math.cos(Math.toRadians(this.field_70177_z)) * (double)knockback * 0.5;
                victim.func_70024_g(vx, vy, vz);
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                victim.func_70015_d(fireAspect * 4);
            }
            if (victim instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)victim), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)victim);
            this.func_130011_c(victim);
            float volume = this.func_70599_aP() * 0.7f;
            float pitch = this.func_70647_i();
            this.field_70170_p.func_72956_a((Entity)this, "random.eat", volume, pitch);
        }
        return attacked;
    }

    public boolean func_70097_a(DamageSource src, float par2) {
        if (this.isInvulnerableTo(src)) {
            return false;
        }
        this.field_70911_d.func_75270_a(false);
        return super.func_70097_a(src, par2);
    }

    public boolean func_90999_ad() {
        return super.func_90999_ad() && !this.getBreedHelper().getBreed().isImmuneToDamage(DamageSource.field_76372_a);
    }

    public boolean func_70878_b(EntityAnimal mate) {
        return this.getReproductionHelper().canMateWith(mate);
    }

    public EntityAgeable func_90011_a(EntityAgeable mate) {
        return this.getReproductionHelper().createChild(mate);
    }

    public DragonAnimator getAnimator() {
        return this.animator;
    }

    private void addHelper(DragonHelper helper) {
        L.trace("addHelper({})", new Object[]{helper.getClass().getName()});
        if (this.helpers == null) {
            this.helpers = new HashMap<Class, DragonHelper>();
        }
        this.helpers.put(helper.getClass(), helper);
    }

    public <T extends DragonHelper> T getHelper(Class<T> clazz) {
        return (T)this.helpers.get(clazz);
    }

    public DragonBreedHelper getBreedHelper() {
        return this.getHelper(DragonBreedHelper.class);
    }

    public DragonLifeStageHelper getLifeStageHelper() {
        return this.getHelper(DragonLifeStageHelper.class);
    }

    public DragonReproductionHelper getReproductionHelper() {
        return this.getHelper(DragonReproductionHelper.class);
    }

    private DragonParticleHelper getParticleHelper() {
        return this.getHelper(DragonParticleHelper.class);
    }

    public boolean getBooleanData(int index) {
        return (this.field_70180_af.func_75683_a(index) & 1) != 0;
    }

    public void setBooleanData(int index, boolean value) {
        this.field_70180_af.func_75692_b(index, (Object)(value ? (byte)1 : 0));
    }

    public boolean isSaddled() {
        return this.getBooleanData(20);
    }

    public void setSaddled(boolean saddled) {
        L.trace("setSaddled({})", new Object[]{saddled});
        this.setBooleanData(20, saddled);
    }

    public DragonBreed getBreed() {
        return this.getBreedHelper().getBreed();
    }

    public void setBreed(DragonBreed breed) {
        this.getBreedHelper().setBreed(breed);
    }

    public EntityPlayer getRidingPlayer() {
        if (this.field_70153_n instanceof EntityPlayer) {
            return (EntityPlayer)this.field_70153_n;
        }
        return null;
    }

    public void setRidingPlayer(EntityPlayer player) {
        L.trace("setRidingPlayer({})", new Object[]{player.func_70005_c_()});
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        player.func_70078_a((Entity)this);
    }

    public void setControlFlags(BitSet flags) {
        this.controlFlags = flags;
    }

    public BitSet getControlFlags() {
        return this.controlFlags;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double px = this.field_70165_t;
            double py = this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W();
            double pz = this.field_70161_v;
            Vec3 pos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)(0.8 * (double)this.getScale()));
            pos.func_72442_b((float)Math.toRadians(-this.field_70761_aq));
            this.field_70153_n.func_70107_b(px += pos.field_72450_a, py += pos.field_72448_b, pz += pos.field_72449_c);
            if (this.field_70153_n instanceof EntityLiving) {
                EntityLiving rider = (EntityLiving)this.field_70153_n;
                rider.field_70127_C = rider.field_70125_A;
                rider.field_70126_B = rider.field_70177_z;
                rider.field_70761_aq = this.field_70761_aq;
            }
        }
    }

    public boolean isInvulnerableTo(DamageSource src) {
        Entity srcEnt = src.func_76346_g();
        if (srcEnt != null) {
            if (srcEnt == this) {
                return true;
            }
            if (srcEnt == this.field_70153_n) {
                return true;
            }
        }
        if (src.field_76373_n.equals("drown") && this.isEgg()) {
            return true;
        }
        return this.getBreed().isImmuneToDamage(src);
    }

    public double getHealthRelative() {
        return (double)this.func_110143_aJ() / (double)this.func_110138_aP();
    }

    public int getDeathTime() {
        return this.field_70725_aQ;
    }

    public int getMaxDeathTime() {
        return 120;
    }

    public void onWingsDown(float speed) {
        if (!this.field_70171_ac) {
            float pitch = this.func_70647_i() + (1.0f - speed);
            float volume = this.func_70599_aP() * 0.3f + (1.0f - speed) * 0.2f;
            this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.enderdragon.wings", volume, pitch, false);
        }
    }

    public void setImmuneToFire(boolean isImmuneToFire) {
        L.trace("setImmuneToFire({})", new Object[]{isImmuneToFire});
        this.field_70178_ae = isImmuneToFire;
    }

    public void setAttackDamage(double damage) {
        L.trace("setAttackDamage({})", new Object[]{damage});
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(damage);
    }

    public double getAttackDamage() {
        return this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    public void setScalePublic(float scale) {
        double posXTmp = this.field_70165_t;
        double posYTmp = this.field_70163_u;
        double posZTmp = this.field_70161_v;
        this.func_98055_j(scale);
        this.func_70107_b(posXTmp, posYTmp, posZTmp);
    }

    public void func_98054_a(boolean p_98054_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public float getScale() {
        return this.getLifeStageHelper().getScale();
    }

    public boolean isEgg() {
        return this.getLifeStageHelper().isEgg();
    }

    public boolean isHatchling() {
        return this.getLifeStageHelper().isHatchling();
    }

    public boolean isJuvenile() {
        return this.getLifeStageHelper().isJuvenile();
    }

    public boolean isAdult() {
        return this.getLifeStageHelper().isAdult();
    }
}

