/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.helpers.IPriorityHost;
import appeng.parts.automation.StackUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerPartEssentiaStorageBus;
import thaumicenergistics.gui.GuiEssentiaStorageBus;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.inventory.AbstractHandlerEssentiaStorageBus;
import thaumicenergistics.inventory.HandlerEssentiaStorageBusDuality;
import thaumicenergistics.network.IAspectSlotPart;
import thaumicenergistics.network.packet.client.PacketClientAspectSlot;
import thaumicenergistics.network.packet.client.PacketClientEssentiaStorageBus;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.texture.BlockTextureManager;
import thaumicenergistics.util.EffectiveSide;
import thaumicenergistics.util.IInventoryUpdateReceiver;

public class AEPartEssentiaStorageBus
extends AbstractAEPartBase
implements IGridTickable,
ICellContainer,
IInventoryUpdateReceiver,
IAspectSlotPart,
IAEAppEngInventory,
IPriorityHost {
    public static final int FILTER_SIZE = 9;
    private static final double IDLE_POWER_DRAIN = 1.0;
    private static final String NBT_KEY_PRIORITY = "Priority";
    private static final String NBT_KEY_FILTER = "FilterAspects#";
    private static final String NBT_KEY_UPGRADES = "UpgradeInventory";
    private static final String NBT_KEY_VOID = "IsVoidAllowed";
    private int priority = 0;
    private AbstractHandlerEssentiaStorageBus handler = new HandlerEssentiaStorageBusDuality(this);
    private List<Aspect> filteredAspects = new ArrayList<Aspect>(9);
    private UpgradeInventory upgradeInventory = new StackUpgradeInventory(this.associatedItem, (IAEAppEngInventory)this, 1);
    private List<ContainerPartEssentiaStorageBus> listeners = new ArrayList<ContainerPartEssentiaStorageBus>();

    public AEPartEssentiaStorageBus() {
        super(AEPartsEnum.EssentiaStorageBus);
        for (int index = 0; index < 9; ++index) {
            this.filteredAspects.add(null);
        }
    }

    private void notifyListenersOfFilteredAspectsChange() {
        for (ContainerPartEssentiaStorageBus listner : this.listeners) {
            listner.setFilteredAspects(this.filteredAspects);
        }
    }

    private void postGridUpdateEvent() {
        IGrid grid;
        if (this.node != null && (grid = this.node.getGrid()) != null) {
            grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
    }

    @Override
    protected boolean canPlayerOpenGui(int playerID) {
        return this.doesPlayerHaveSecurityClearance(playerID, SecurityPermissions.EXTRACT) && this.doesPlayerHaveSecurityClearance(playerID, SecurityPermissions.INJECT);
    }

    public boolean addFilteredAspectFromItemstack(EntityPlayer player, ItemStack itemStack) {
        Aspect itemAspect = EssentiaItemContainerHelper.instance.getAspectInContainer(itemStack);
        if (itemAspect != null) {
            if (this.filteredAspects.contains(itemAspect)) {
                return true;
            }
            for (int index = 0; index < 9; ++index) {
                if (this.filteredAspects.get(index) != null) continue;
                this.setAspect(index, itemAspect, player);
                return true;
            }
        }
        return false;
    }

    public void addListener(ContainerPartEssentiaStorageBus listener) {
        if (!this.listeners.contains((Object)listener)) {
            this.listeners.add(listener);
        }
    }

    public void blinkCell(int slot) {
    }

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(1.0, 1.0, 15.0, 15.0, 15.0, 16.0);
        helper.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 15.0);
        helper.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[0];
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>();
        if (channel == StorageChannel.FLUIDS) {
            list.add(this.handler);
        }
        return list;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiEssentiaStorageBus(this, player);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        if (wrenched) {
            return;
        }
        ItemStack slotStack = this.upgradeInventory.func_70301_a(0);
        if (slotStack != null && slotStack.field_77994_a > 0) {
            drops.add(slotStack);
        }
    }

    @Override
    public double getIdlePowerUsage() {
        return 1.0;
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPartEssentiaStorageBus(this, player);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(20, 20, false, false);
    }

    public UpgradeInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void onChangeInventory(IInventory inv, int arg1, InvOperation arg2, ItemStack arg3, ItemStack arg4) {
        this.onInventoryChanged(inv);
    }

    public void onClientRequestFullUpdate(EntityPlayer player) {
        new PacketClientEssentiaStorageBus().createSetIsVoidAllowed(player, this.handler.isVoidAllowed()).sendPacketToPlayer();
        new PacketClientAspectSlot().createFilterListUpdate(this.filteredAspects, player).sendPacketToPlayer();
    }

    public void onClientRequestSetVoidMode(EntityPlayer player, boolean isVoidAllowed) {
        this.handler.setVoidAllowed(isVoidAllowed);
        this.saveChanges();
    }

    @Override
    public void onInventoryChanged(IInventory sourceInventory) {
        boolean inverted = AEApi.instance().definitions().materials().cardInverter().isSameAs(this.upgradeInventory.func_70301_a(0));
        this.handler.setInverted(inverted);
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        if (EffectiveSide.isServerSide() && this.handler.onNeighborChange()) {
            this.postGridUpdateEvent();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.priority = data.func_74762_e(NBT_KEY_PRIORITY);
        for (int index = 0; index < 9; ++index) {
            this.filteredAspects.set(index, (Aspect)Aspect.aspects.get(data.func_74779_i(NBT_KEY_FILTER + index)));
        }
        this.upgradeInventory.readFromNBT(data, NBT_KEY_UPGRADES);
        if (data.func_74764_b(NBT_KEY_VOID)) {
            this.handler.setVoidAllowed(data.func_74767_n(NBT_KEY_VOID));
        }
        this.onInventoryChanged((IInventory)this.upgradeInventory);
        this.handler.setPrioritizedAspects(this.filteredAspects);
    }

    public void removeListener(ContainerPartEssentiaStorageBus listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[2];
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[0], side, side);
        helper.setBounds(1.0f, 1.0f, 15.0f, 15.0f, 15.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(2.0f, 2.0f, 15.0f, 14.0f, 14.0f, 16.0f);
        helper.setInvColor(AbstractAEPartBase.INVENTORY_OVERLAY_COLOR);
        ts.func_78380_c(0xF000F0);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[1], ForgeDirection.SOUTH, renderer);
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[2];
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_STORAGE_BUS.getTexture(), side, side);
        helper.setBounds(1.0f, 1.0f, 15.0f, 15.0f, 15.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        tessellator.func_78378_d(this.host.getColor().blackVariant);
        if (this.isActive()) {
            tessellator.func_78380_c(0xD000D0);
        }
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_STORAGE_BUS.getTextures()[1], ForgeDirection.SOUTH, renderer);
        helper.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        helper.renderBlock(x, y, z, renderer);
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    public void saveChanges() {
        this.host.markForSave();
    }

    public void saveChanges(IMEInventory inventory) {
        this.saveChanges();
    }

    @Override
    public void setAspect(int index, Aspect aspect, EntityPlayer player) {
        this.filteredAspects.set(index, aspect);
        if (EffectiveSide.isServerSide()) {
            this.handler.setPrioritizedAspects(this.filteredAspects);
            this.notifyListenersOfFilteredAspectsChange();
            this.postGridUpdateEvent();
            this.host.markForSave();
        }
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        this.handler.tickingRequest(node, TicksSinceLastCall);
        return TickRateModulation.SAME;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a(NBT_KEY_PRIORITY, this.priority);
        for (int index = 0; index < 9; ++index) {
            Aspect aspect = this.filteredAspects.get(index);
            if (aspect != null) {
                data.func_74778_a(NBT_KEY_FILTER + index, aspect.getTag());
                continue;
            }
            data.func_74778_a(NBT_KEY_FILTER + index, "");
        }
        this.upgradeInventory.writeToNBT(data, NBT_KEY_UPGRADES);
        data.func_74757_a(NBT_KEY_VOID, this.handler.isVoidAllowed());
    }
}

