/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import crazypants.vecmath.Vector3d;
import net.minecraftforge.common.util.ForgeDirection;

public final class ForgeDirectionOffsets {
    public static final Vector3d[] OFFSETS = new Vector3d[ForgeDirection.values().length];

    public static Vector3d forDir(ForgeDirection dir) {
        return OFFSETS[dir.ordinal()];
    }

    public static Vector3d forDirCopy(ForgeDirection dir) {
        return new Vector3d(OFFSETS[dir.ordinal()]);
    }

    public static Vector3d offsetScaled(ForgeDirection dir, double scale) {
        Vector3d res = ForgeDirectionOffsets.forDirCopy(dir);
        res.scale(scale);
        return res;
    }

    public static Vector3d absolueOffset(ForgeDirection dir) {
        Vector3d res = ForgeDirectionOffsets.forDirCopy(dir);
        res.x = Math.abs(res.x);
        res.y = Math.abs(res.y);
        res.z = Math.abs(res.z);
        return res;
    }

    public ForgeDirection closest(float x, float y, float z) {
        float ax = Math.abs(x);
        float ay = Math.abs(y);
        float az = Math.abs(z);
        if (ax >= ay && ax >= az) {
            return x > 0.0f ? ForgeDirection.EAST : ForgeDirection.WEST;
        }
        if (ay >= ax && ay >= az) {
            return y > 0.0f ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        return z > 0.0f ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
    }

    private ForgeDirectionOffsets() {
    }

    public static boolean isPositiveOffset(ForgeDirection dir) {
        return dir == ForgeDirection.SOUTH || dir == ForgeDirection.EAST || dir == ForgeDirection.UP;
    }

    static {
        for (ForgeDirection dir : ForgeDirection.values()) {
            ForgeDirectionOffsets.OFFSETS[dir.ordinal()] = new Vector3d(dir.offsetX, dir.offsetY, dir.offsetZ);
        }
    }
}

