/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.generator.combustion.TranslatedCubeRenderer;
import crazypants.enderio.machine.vat.BlockVat;
import crazypants.enderio.machine.vat.TileVat;
import crazypants.render.BoundingBox;
import crazypants.render.CustomCubeRenderer;
import crazypants.render.CustomRenderBlocks;
import crazypants.render.IRenderFace;
import crazypants.render.VertexTransform;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector3f;
import crazypants.vecmath.Vertex;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class VatRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    private VertXForm xform = new VertXForm();
    private CustomCubeRenderer ccr = new CustomCubeRenderer();
    private OverlayRenderer overlayRenderer = new OverlayRenderer();
    private TileVat vat;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderInventoryBlock(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j(), 0, (RenderBlocks)data[0]);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int facing = 3;
        boolean active = false;
        if (world != null) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileVat) {
                this.vat = (TileVat)te;
                facing = this.vat.facing;
                active = this.vat.isActive();
            } else {
                this.vat = null;
            }
        }
        float fudge = 1.0f;
        IIcon override = renderer.field_147840_d;
        BoundingBox bb = BoundingBox.UNIT_CUBE.scale(0.334, (double)fudge, (double)fudge);
        bb = bb.translate(0.333f, 0.0f, 0.0f);
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.xform, override, world != null);
        bb = BoundingBox.UNIT_CUBE.scale(0.334, (double)fudge, (double)fudge);
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.xform, override, world != null);
        bb = BoundingBox.UNIT_CUBE.scale(0.334, (double)fudge, (double)fudge);
        bb = bb.translate(-0.333f, 0.0f, 0.0f);
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.xform, override, world != null);
        if (this.vat != null) {
            this.ccr.renderBlock(world, block, x, y, z, this.overlayRenderer);
        }
        this.vat = null;
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glDisable((int)2896);
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        tes.func_78372_c(0.0f, -0.1f, 0.0f);
        this.renderWorldBlock(null, 0, 0, 0, block, 0, renderer);
        tes.func_78372_c(0.0f, 0.1f, 0.0f);
        tes.func_78381_a();
        GL11.glEnable((int)2896);
    }

    public int getRenderId() {
        return BlockVat.renderId;
    }

    private class OverlayRenderer
    implements IRenderFace {
        private OverlayRenderer() {
        }

        @Override
        public void renderFace(CustomRenderBlocks rb, ForgeDirection face, Block par1Block, double x, double y, double z, IIcon texture, List<Vertex> refVertices, boolean translateToXyz) {
            if (VatRenderer.this.vat != null && par1Block instanceof AbstractMachineBlock) {
                Vector3d offset = ForgeDirectionOffsets.offsetScaled(face, 0.01);
                Tessellator.field_78398_a.func_78372_c((float)offset.x, (float)offset.y, (float)offset.z);
                IoMode mode = VatRenderer.this.vat.getIoMode(face);
                IIcon tex = ((AbstractMachineBlock)par1Block).getOverlayIconForMode(mode);
                if (tex != null) {
                    VatRenderer.this.ccr.getCustomRenderBlocks().doDefaultRenderFace(face, par1Block, x, y, z, tex);
                }
                Tessellator.field_78398_a.func_78372_c(-((float)offset.x), -((float)offset.y), -((float)offset.z));
            }
        }
    }

    private static class VertXForm
    implements VertexTransform {
        @Override
        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        @Override
        public void apply(Vector3d vec) {
            if (vec.x > 0.9 || vec.x < 0.1) {
                vec.z -= 0.5;
                vec.z *= 0.42;
                vec.z += 0.5;
            }
        }

        @Override
        public void applyToNormal(Vector3f vec) {
        }
    }
}

