/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoMagmatic;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileDynamoMagmatic
extends TileDynamoBase
implements IFluidHandler {
    static final int TYPE = BlockDynamo.Types.MAGMATIC.ordinal();
    static TObjectIntHashMap<Fluid> fuels = new TObjectIntHashMap();
    FluidTankAdv tank = new FluidTankAdv(4000);
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);

    public static void initialize() {
        GameRegistry.registerTileEntity(TileDynamoMagmatic.class, (String)"thermalexpansion.DynamoMagmatic");
    }

    public static boolean isValidFuel(FluidStack fluidStack) {
        return fluidStack == null ? false : fuels.containsKey((Object)fluidStack.getFluid());
    }

    public static boolean registerFuel(Fluid fluid, int n) {
        if (fluid == null || n < 10000 || n > 200000000) {
            return false;
        }
        fuels.put((Object)fluid, n / 20);
        return true;
    }

    public static int getFuelEnergy(FluidStack fluidStack) {
        return fluidStack == null ? 0 : fuels.get((Object)fluidStack.getFluid());
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getLightValue() {
        return this.isActive ? 14 : 0;
    }

    @Override
    protected boolean canGenerate() {
        return this.fuelRF > 0 ? true : this.tank.getFluidAmount() >= 50;
    }

    @Override
    public void generate() {
        if (this.fuelRF <= 0) {
            this.fuelRF += TileDynamoMagmatic.getFuelEnergy(this.tank.getFluid()) * this.fuelMod / 100;
            this.tank.drain(50, true);
        }
        int n = this.calcEnergy() * this.energyMod;
        this.energyStorage.modifyEnergyStored(n);
        this.fuelRF -= n;
    }

    @Override
    public IIcon getActiveIcon() {
        return this.renderFluid.getFluid().getIcon(this.renderFluid);
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiDynamoMagmatic(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public FluidTankAdv getTank(int n) {
        return this.tank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.tank.readFromNBT(nBTTagCompound);
        if (!TileDynamoMagmatic.isValidFuel(this.tank.getFluid())) {
            this.tank.setFluid(null);
        }
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addFluidStack(this.tank.getFluid());
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addFluidStack(this.tank.getFluid());
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.tank.setFluid(packetCoFHBase.getFluidStack());
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.renderFluid = packetCoFHBase.getFluidStack();
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || forgeDirection.ordinal() == this.facing && !this.augmentCoilDuct) {
            return 0;
        }
        if (TileDynamoMagmatic.isValidFuel(fluidStack)) {
            return this.tank.fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || !this.augmentCoilDuct) {
            return null;
        }
        if (TileDynamoMagmatic.isValidFuel(fluidStack)) {
            return this.tank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (!this.augmentCoilDuct) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

