/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.pipes;

import com.rwtema.extrautils.item.ItemNodeUpgrade;
import com.rwtema.extrautils.tileentity.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils.tileentity.transfernodes.TNHelper;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeBase;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeFilter
extends PipeBase {
    public PipeFilter() {
        super("Filter");
    }

    @Override
    public ArrayList<ForgeDirection> getOutputDirections(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        if (TNHelper.getPipe(world, x, y, z) != null) {
            IInventory inv = TNHelper.getPipe(world, x, y, z).getFilterInventory(world, x, y, z);
            if (inv == null) {
                return super.getOutputDirections(world, x, y, z, dir, buffer);
            }
            for (ForgeDirection d : TNHelper.randomDirections()) {
                ItemStack filter;
                if (d == dir.getOpposite() || !TNHelper.canOutput(world, x, y, z, d) || !TNHelper.canInput(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, d.getOpposite()) || (filter = inv.func_70301_a(d.ordinal())) == null || !ItemNodeUpgrade.matchesFilterBuffer(buffer, filter)) continue;
                dirs.add(d);
            }
            for (ForgeDirection d : TNHelper.randomDirections()) {
                if (d == dir.getOpposite() || !TNHelper.canOutput(world, x, y, z, d) || !TNHelper.canInput(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, d.getOpposite()) || inv.func_70301_a(d.ordinal()) != null) continue;
                dirs.add(d);
            }
        }
        return dirs;
    }

    @Override
    public boolean transferItems(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        ItemStack filter;
        boolean advance = true;
        IPipe pipe = TNHelper.getPipe(world, x, y, z);
        if (pipe == null) {
            return true;
        }
        IInventory inv = pipe.getFilterInventory(world, x, y, z);
        if (inv == null) {
            return super.transferItems(world, x, y, z, dir, buffer);
        }
        for (ForgeDirection d : TNHelper.randomDirections()) {
            if (d.getOpposite() == dir || (filter = inv.func_70301_a(d.ordinal())) == null || !pipe.shouldConnectToTile(world, x, y, z, d) || !ItemNodeUpgrade.matchesFilterBuffer(buffer, filter) || buffer.transfer(world.func_147438_o(x + d.offsetX, y + d.offsetY, z + d.offsetZ), d.getOpposite(), pipe, x, y, z, dir)) continue;
            advance = false;
        }
        for (ForgeDirection d : TNHelper.randomDirections()) {
            if (d.getOpposite() == dir || (filter = inv.func_70301_a(d.ordinal())) != null || !pipe.shouldConnectToTile(world, x, y, z, d) || buffer.transfer(world.func_147438_o(x + d.offsetX, y + d.offsetY, z + d.offsetZ), d.getOpposite(), pipe, x, y, z, dir)) continue;
            advance = false;
        }
        return advance;
    }

    @Override
    public IIcon pipeTexture(ForgeDirection dir, boolean blocked) {
        if (dir.ordinal() == 6) {
            return BlockTransferPipe.pipes;
        }
        return BlockTransferPipe.pipes_diamond[dir.ordinal()];
    }

    @Override
    public IIcon invPipeTexture(ForgeDirection dir) {
        return this.pipeTexture(dir, false);
    }
}

