/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tileentities;

import appeng.api.networking.IGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.me.GridAccessException;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.common.Thaumcraft;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.tileentities.TileProviderBase;

public class TileInfusionProvider
extends TileProviderBase
implements IAspectSource,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    protected List<AspectStack> aspectStackList = new ArrayList<AspectStack>();

    private void doParticalFX(int aspectColor) {
        int i;
        float red = (float)(aspectColor & 0xFF0000) / 1.671168E7f;
        float green = (float)(aspectColor & 0xFF00) / 65280.0f;
        float blue = (float)(aspectColor & 0xFF) / 255.0f;
        for (i = 0; i < 5; ++i) {
            Thaumcraft.proxy.blockRunes(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, red, green, blue, 15, -0.1f);
        }
        for (i = 0; i < 5; ++i) {
            Thaumcraft.proxy.blockRunes(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, red, green, blue, 15, 0.1f);
        }
    }

    @Override
    protected double getIdlePowerusage() {
        return 5.0;
    }

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        return ThEApi.instance().blocks().InfusionProvider.getStack();
    }

    @Override
    protected void onChannelUpdate() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            IGrid grid;
            if (this.monitor != null) {
                this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
            }
            try {
                grid = this.gridProxy.getGrid();
            }
            catch (GridAccessException e) {
                return;
            }
            if (this.getFluidMonitor()) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, (Object)grid);
                this.aspectStackList = EssentiaConversionHelper.instance.convertIIAEFluidStackListToAspectStackList((IItemList<IAEFluidStack>)this.monitor.getStorageList());
                this.markForUpdate();
            }
        }
    }

    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    @Deprecated
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    public AspectList getAspects() {
        return null;
    }

    public boolean isValid(Object prevGrid) {
        IGrid grid;
        try {
            grid = this.gridProxy.getGrid();
        }
        catch (GridAccessException e) {
            return false;
        }
        return prevGrid == grid;
    }

    public void onBreakBlock() {
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void onListUpdate() {
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> changes, BaseActionSource source) {
        if (changes == null) {
            return;
        }
        for (IAEFluidStack change : changes) {
            if (!(change.getFluid() instanceof GaseousEssentia)) continue;
            this.aspectStackList = EssentiaConversionHelper.instance.convertIIAEFluidStackListToAspectStackList((IItemList<IAEFluidStack>)((IMEMonitor)monitor).getStorageList());
            this.markForUpdate();
            break;
        }
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.extractEssentiaFromNetwork(tag, amount, true) == amount) {
            this.doParticalFX(tag.getColor());
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }
}

