/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft.v2;

import com.google.common.base.Preconditions;
import com.xcompwiz.mystcraft.api.item.IItemPageCollection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.adapter.method.ScriptObject;

@ScriptObject
@Asynchronous
@AdapterSourceName(value="notebook")
public class NotebookWrapper {
    private final WorldServer ownerWorld;
    private IItemPageCollection item;
    private ItemStack stack;

    public NotebookWrapper(WorldServer ownerWorld, IItemPageCollection item, ItemStack stack) {
        this.ownerWorld = ownerWorld;
        this.item = item;
        this.stack = stack;
    }

    @ScriptCallable(returnTypes={ReturnType.STRING})
    public String getName() {
        return (String)FakePlayerPool.instance.executeOnPlayer(this.ownerWorld, (FakePlayerPool.PlayerUserReturning)new FakePlayerPool.PlayerUserReturning<String>(){

            public String usePlayer(OpenModsFakePlayer fakePlayer) {
                return NotebookWrapper.this.item.getDisplayName((EntityPlayer)fakePlayer, NotebookWrapper.this.stack);
            }
        });
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, name="getAllPages")
    public List<ItemStack> getPages() {
        return (List)FakePlayerPool.instance.executeOnPlayer(this.ownerWorld, (FakePlayerPool.PlayerUserReturning)new FakePlayerPool.PlayerUserReturning<List<ItemStack>>(){

            public List<ItemStack> usePlayer(OpenModsFakePlayer fakePlayer) {
                return NotebookWrapper.this.item.getItems((EntityPlayer)fakePlayer, NotebookWrapper.this.stack);
            }
        });
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER})
    public int getSlotCount(int slot) {
        return this.getPages().size();
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE})
    public ItemStack getPageFromSlot(@Arg(name="slot") int slot) {
        List<ItemStack> pages = this.getPages();
        Preconditions.checkElementIndex((int)slot, (int)pages.size(), (String)"slot");
        return pages.get(slot);
    }

    public ItemStack removePage(final ItemStack page) {
        return (ItemStack)FakePlayerPool.instance.executeOnPlayer(this.ownerWorld, (FakePlayerPool.PlayerUserReturning)new FakePlayerPool.PlayerUserReturning<ItemStack>(){

            public ItemStack usePlayer(OpenModsFakePlayer fakePlayer) {
                return NotebookWrapper.this.item.remove((EntityPlayer)fakePlayer, NotebookWrapper.this.stack, page);
            }
        });
    }

    public ItemStack addPage(final ItemStack page) {
        return (ItemStack)FakePlayerPool.instance.executeOnPlayer(this.ownerWorld, (FakePlayerPool.PlayerUserReturning)new FakePlayerPool.PlayerUserReturning<ItemStack>(){

            public ItemStack usePlayer(OpenModsFakePlayer fakePlayer) {
                return NotebookWrapper.this.item.addPage((EntityPlayer)fakePlayer, NotebookWrapper.this.stack, page);
            }
        });
    }
}

