/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr;

import cofh.lib.util.WeightedRandomItemStack;
import java.util.Map;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.annotations.OnRegister;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import minetweaker.api.server.ICommandFunction;
import minetweaker.util.IEventHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import powercrystals.minefactoryreloaded.MFRRegistry;

public class MFRCommands {
    private static final String[] DESCRIPTION = new String[]{"    MineFactory commands:", "      /minetweaker mfr fertilizers", "        Lists all fertilizers", "      /minetweaker mfr fruits", "        Lists all known fruit blocks", "      /minetweaker mfr laserores", "        Lists all ores known to the mining laser", "      /minetweaker mfr rubbertreebiomes", "        Lists all biomes for the rubber tree", "      /minetweaker mfr sludgedrops", "        Lists all sludge boiler drops"};

    @OnRegister
    public static void onRegister() {
        MineTweakerImplementationAPI.onReloadEvent(new IEventHandler<MineTweakerImplementationAPI.ReloadEvent>(){

            @Override
            public void handle(MineTweakerImplementationAPI.ReloadEvent event) {
                MineTweakerImplementationAPI.addMineTweakerCommand("mfr", DESCRIPTION, new ICommandFunction(){

                    @Override
                    public void execute(String[] arguments, IPlayer player) {
                        if (arguments.length < 1) {
                            player.sendChat("Please specify a mfr command");
                        } else if (arguments[0].equals("fertilizers")) {
                            MineTweakerAPI.logCommand("Fertilizers:");
                            for (Map.Entry fertilizer : MFRRegistry.getFertilizers().entrySet()) {
                                IItemStack item = MineTweakerMC.getItemStack((Item)fertilizer.getKey(), 1, 0);
                                String message = "- " + item + " (" + item.getDisplayName() + ")";
                                MineTweakerAPI.logCommand(message);
                            }
                            player.sendChat("Fertilizer list generated; see minetweaker.log");
                        } else if (arguments[0].equals("fruits")) {
                            MineTweakerAPI.logCommand("Fruit Blocks:");
                            for (Map.Entry fruitBlock : MFRRegistry.getFruits().entrySet()) {
                                Block block = (Block)fruitBlock.getKey();
                                String message = "- " + block.func_149739_a() + " (" + block.func_149732_F() + ")";
                                MineTweakerAPI.logCommand(message);
                            }
                            player.sendChat("Fluit blocks list generated; see minetweaker.log");
                        } else if (arguments[0].equals("laserores")) {
                            MineTweakerAPI.logCommand("Laser ores:");
                            for (Object randomItem : MFRRegistry.getLaserOres()) {
                                if (!(randomItem instanceof WeightedRandomItemStack)) continue;
                                WeightedRandomItemStack randomItemStack = (WeightedRandomItemStack)randomItem;
                                IItemStack item = MineTweakerMC.getIItemStack(randomItemStack.getStack());
                                MineTweakerAPI.logCommand("    (" + randomItemStack.field_76292_a + "): " + item + " (" + item.getDisplayName() + ")");
                            }
                            player.sendChat("Laser ore list generated; see minetweaker.log");
                            for (int i = 0; i < MineTweakerAPI.COLOR_NAMES.length; ++i) {
                                if (MFRRegistry.getLaserPreferredOres((int)i) == null || MFRRegistry.getLaserPreferredOres((int)i).isEmpty()) continue;
                                MineTweakerAPI.logCommand("Laser affinity " + i + " (" + MineTweakerAPI.COLOR_NAMES[i] + "):");
                                for (ItemStack item : MFRRegistry.getLaserPreferredOres((int)i)) {
                                    IItemStack iitem = MineTweakerMC.getIItemStack(item);
                                    MineTweakerAPI.logCommand("    " + iitem + " (" + iitem.getDisplayName() + ")");
                                }
                            }
                            player.sendChat("Laser preferred ore list generated; see minetweaker.log");
                        } else if (arguments[0].equals("rubbertreebiomes")) {
                            MineTweakerAPI.logCommand("Rubber tree biomes:");
                            for (String biome : MFRRegistry.getRubberTreeBiomes()) {
                                MineTweakerAPI.logCommand("    " + biome);
                            }
                            player.sendChat("Rubber tree biome list generated; see minetweaker.log");
                        } else if (arguments[0].equals("sludgedrops")) {
                            MineTweakerAPI.logCommand("Sludge drops:");
                            for (WeightedRandom.Item randItem : MFRRegistry.getSludgeDrops()) {
                                if (!(randItem instanceof WeightedRandomItemStack)) continue;
                                WeightedRandomItemStack randomItem = (WeightedRandomItemStack)randItem;
                                IItemStack item = MineTweakerMC.getIItemStack(randomItem.getStack());
                                MineTweakerAPI.logCommand("    (" + randomItem.field_76292_a + "): " + item + " (" + item.getDisplayName() + ")");
                            }
                            player.sendChat("Sludge drop list generated; see minetweaker.log");
                        } else {
                            player.sendChat("Unknown mfr command: " + arguments[1]);
                        }
                    }
                });
            }
        });
    }
}

