/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.api.converter.IConverter;

public class MethodSelector
implements Predicate<IMethodExecutor> {
    private final Map<String, Class<?>> providedEnv = Maps.newHashMap();
    private final String architecture;

    public MethodSelector(String architecture) {
        this.architecture = architecture;
    }

    public MethodSelector addDefaultEnv() {
        this.providedEnv.put("converter", IConverter.class);
        return this;
    }

    public MethodSelector addProvidedEnv(String name, Class<?> cls) {
        this.providedEnv.put(name, cls);
        return this;
    }

    public boolean apply(IMethodExecutor executor) {
        if (!executor.canInclude(this.architecture)) {
            return false;
        }
        Map<String, Class<?>> requiredEnv = executor.requiredEnv();
        for (Map.Entry<String, Class<?>> e : requiredEnv.entrySet()) {
            String name = e.getKey();
            Class<?> required = e.getValue();
            Class<?> provided = this.providedEnv.get(name);
            if (provided != null && required.isAssignableFrom(provided)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("selector for %s (env: %s)", this.architecture, this.providedEnv);
    }
}

