/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.ContentHelper;
import lib.enderwizards.sandstone.util.InventoryHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.items.ItemSojournerStaff;

@ContentInit
public class ItemLanternOfParanoia
extends ItemToggleable {
    public ItemLanternOfParanoia() {
        super("lantern_of_paranoia");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    protected ItemLanternOfParanoia(String name) {
        super(name);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    public int getRange() {
        return Reliquary.CONFIG.getInt("lantern_of_paranoia", "placement_scan_radius");
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean f) {
        if (!this.isEnabled(ist)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            if (e instanceof EntityPlayer) {
                player = (EntityPlayer)e;
            }
            if (player == null) {
                return;
            }
            int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
            int playerY = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b);
            int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
            block0: for (int xDiff = -this.getRange(); xDiff <= this.getRange(); ++xDiff) {
                for (int zDiff = -this.getRange(); zDiff <= this.getRange(); ++zDiff) {
                    for (int yDiff = this.getRange() / 2; yDiff >= -this.getRange() / 2; --yDiff) {
                        int lightLevel;
                        int x = playerX + xDiff;
                        int y = playerY + yDiff;
                        int z = playerZ + zDiff;
                        if (player.field_70170_p.func_147437_c(x, y, z) && (lightLevel = player.field_70170_p.func_72957_l(x, y, z)) <= Reliquary.CONFIG.getInt("lantern_of_paranoia", "min_light_level") && this.tryToPlaceTorchAround(ist, x, y, z, player, world)) break block0;
                    }
                }
            }
        }
    }

    private boolean findAndDrainSojournersStaff(EntityPlayer player) {
        Item staffItem = Reliquary.CONTENT.getItem("sojourner_staff");
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            if (player.field_71071_by.func_70301_a(slot) == null || staffItem != player.field_71071_by.func_70301_a(slot).func_77973_b()) continue;
            Item torch = ItemBlock.func_150898_a((Block)Blocks.field_150478_aa);
            if (!((ItemSojournerStaff)staffItem).removeItemFromInternalStorage(player.field_71071_by.func_70301_a(slot), torch, 1)) continue;
            return true;
        }
        return false;
    }

    public boolean tryToPlaceTorchAround(ItemStack ist, int xO, int yO, int zO, EntityPlayer player, World world) {
        float xOff;
        Block var12 = Blocks.field_150478_aa;
        int x = xO;
        int y = yO;
        int z = zO;
        double playerEyeHeight = player.field_70163_u + (double)player.func_70047_e();
        for (xOff = -0.2f; xOff <= 0.2f; xOff += 0.4f) {
            for (float yOff = -0.2f; yOff <= 0.2f; yOff += 0.4f) {
                for (float zOff = -0.2f; zOff <= 0.2f; zOff += 0.4f) {
                    int meta;
                    Block block;
                    Vec3 rayTraceVector;
                    Vec3 playerVec = Vec3.func_72443_a((double)(player.field_70165_t + (double)xOff), (double)(playerEyeHeight + (double)yOff), (double)(player.field_70161_v + (double)zOff));
                    MovingObjectPosition mop = world.func_147447_a(playerVec, rayTraceVector = Vec3.func_72443_a((double)((double)x + 0.5 + (double)xOff), (double)((double)y + 0.5 + (double)yOff), (double)((double)z + 0.5 + (double)zOff)), false, false, true);
                    if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || (block = world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)).func_149668_a(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == null || !block.func_149678_a(meta = world.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d), false)) continue;
                    return false;
                }
            }
        }
        xOff = (float)player.field_70165_t;
        float zOff = (float)player.field_70161_v;
        float yOff = (float)player.field_70163_u;
        if (Blocks.field_150478_aa.func_149742_c(world, x, y, z)) {
            int rotation = ((MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 2) % 4;
            int trySide = 0;
            switch (rotation) {
                case 0: {
                    trySide = 5;
                    break;
                }
                case 1: {
                    trySide = 3;
                    break;
                }
                case 2: {
                    trySide = 4;
                    break;
                }
                case 3: {
                    trySide = 2;
                }
            }
            ArrayList<Integer> trySides = new ArrayList<Integer>();
            trySides.add(trySide);
            trySides.add(0);
            int[] tryOtherSides = new int[]{2, 3, 4, 5};
            for (int tryOtherSide : tryOtherSides) {
                if (trySides.contains(tryOtherSide)) continue;
                trySides.add(tryOtherSide);
            }
            Object object = trySides.iterator();
            while (object.hasNext()) {
                int side = (Integer)object.next();
                if (!world.func_147472_a(Blocks.field_150478_aa, x, y, z, false, side, (Entity)player, ist) || !InventoryHelper.consumeItem(Blocks.field_150478_aa, player, 0, 1) && !this.findAndDrainSojournersStaff(player) || !this.placeBlockAt(ist, player, world, x, y, z, side, xOff, yOff, zOff, this.attemptSide(world, x, y, z, side))) continue;
                Blocks.field_150478_aa.func_149726_b(world, x, y, z);
                double gauss = 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f);
                world.func_72869_a("mobSpell", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, gauss, gauss, 0.0);
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), var12.field_149762_H.func_150498_e(), (var12.field_149762_H.func_150497_c() + 1.0f) / 2.0f, var12.field_149762_H.func_150494_d() * 0.8f);
                return true;
            }
        }
        return false;
    }

    private int attemptSide(World world, int x, int y, int z, int side) {
        return Blocks.field_150478_aa.func_149660_a(world, x, y, z, side, (float)x, (float)y, (float)z, 0);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!world.func_147465_d(x, y, z, Blocks.field_150478_aa, metadata, 3)) {
            return false;
        }
        if (ContentHelper.areBlocksEqual(world.func_147439_a(x, y, z), Blocks.field_150478_aa)) {
            Blocks.field_150478_aa.func_149695_a(world, x, y, z, world.func_147439_a(x, y, z));
            Blocks.field_150478_aa.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
        }
        return true;
    }
}

